/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.DigesterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.TimeZoneUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Contact;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.PasswordPolicy;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.Team;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserGroup;
import com.liferay.portal.model.impl.UserModelImpl;
import com.liferay.portal.security.auth.EmailAddressGenerator;
import com.liferay.portal.security.auth.EmailAddressGeneratorFactory;
import com.liferay.portal.security.auth.FullNameGenerator;
import com.liferay.portal.security.auth.FullNameGeneratorFactory;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import com.liferay.portal.service.ContactLocalServiceUtil;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.PasswordPolicyLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.TeamLocalServiceUtil;
import com.liferay.portal.service.UserGroupLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.social.model.SocialEquityValue;
import com.liferay.portlet.social.service.SocialEquityUserLocalServiceUtil;
import com.liferay.util.UniqueList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserImpl
extends UserModelImpl
implements User {
    private Locale _locale;
    private boolean _passwordModified;
    private String _passwordUnencrypted;
    private AtomicReference<Double> _socialContributionEquity;
    private AtomicReference<Double> _socialParticipationEquity;
    private TimeZone _timeZone;

    public Date getBirthday() throws PortalException, SystemException {
        return this.getContact().getBirthday();
    }

    public String getCompanyMx() throws PortalException, SystemException {
        Company company = CompanyLocalServiceUtil.getCompanyById((long)this.getCompanyId());
        return company.getMx();
    }

    public Contact getContact() throws PortalException, SystemException {
        return ContactLocalServiceUtil.getContact((long)this.getContactId());
    }

    @Override
    public String getDigest() {
        String digest = super.getDigest();
        if (Validator.isNull((String)digest) && !this.isPasswordEncrypted()) {
            digest = this.getDigest(this.getPassword());
        }
        return digest;
    }

    public String getDigest(String password) {
        StringBundler sb = new StringBundler(5);
        String digest1 = DigesterUtil.digestHex((String)"MD5", (String[])new String[]{this.getEmailAddress(), "PortalRealm", password});
        sb.append(digest1);
        sb.append(",");
        String digest2 = DigesterUtil.digestHex((String)"MD5", (String[])new String[]{this.getScreenName(), "PortalRealm", password});
        sb.append(digest2);
        sb.append(",");
        String digest3 = DigesterUtil.digestHex((String)"MD5", (String[])new String[]{String.valueOf(this.getUserId()), "PortalRealm", password});
        sb.append(digest3);
        return sb.toString();
    }

    public String getDisplayEmailAddress() {
        String emailAddress = super.getEmailAddress();
        EmailAddressGenerator emailAddressGenerator = EmailAddressGeneratorFactory.getInstance();
        if (emailAddressGenerator.isFake(emailAddress)) {
            emailAddress = "";
        }
        return emailAddress;
    }

    public String getDisplayURL(ThemeDisplay themeDisplay) throws PortalException, SystemException {
        return this.getDisplayURL(themeDisplay.getPortalURL(), themeDisplay.getPathMain());
    }

    public String getDisplayURL(String portalURL, String mainPath) throws PortalException, SystemException {
        if (this.isDefaultUser()) {
            return "";
        }
        Group group = this.getGroup();
        int publicLayoutsPageCount = group.getPublicLayoutsPageCount();
        if (publicLayoutsPageCount > 0) {
            StringBundler sb = new StringBundler(5);
            sb.append(portalURL);
            sb.append(mainPath);
            sb.append("/my_places/view?groupId=");
            sb.append(group.getGroupId());
            sb.append("&privateLayout=0");
            return sb.toString();
        }
        return "";
    }

    public boolean getFemale() throws PortalException, SystemException {
        return !this.getMale();
    }

    public String getFullName() {
        FullNameGenerator fullNameGenerator = FullNameGeneratorFactory.getInstance();
        return fullNameGenerator.getFullName(this.getFirstName(), this.getMiddleName(), this.getLastName());
    }

    public Group getGroup() throws PortalException, SystemException {
        return GroupLocalServiceUtil.getUserGroup((long)this.getCompanyId(), (long)this.getUserId());
    }

    public long[] getGroupIds() throws PortalException, SystemException {
        List<Group> groups = this.getGroups();
        long[] groupIds = new long[groups.size()];
        int i = 0;
        while (i < groups.size()) {
            Group group = groups.get(i);
            groupIds[i] = group.getGroupId();
            ++i;
        }
        return groupIds;
    }

    public List<Group> getGroups() throws PortalException, SystemException {
        return GroupLocalServiceUtil.getUserGroups((long)this.getUserId());
    }

    public Locale getLocale() {
        return this._locale;
    }

    public String getLogin() throws PortalException, SystemException {
        String login = null;
        Company company = CompanyLocalServiceUtil.getCompanyById((long)this.getCompanyId());
        if (company.getAuthType().equals("emailAddress")) {
            login = this.getEmailAddress();
        } else if (company.getAuthType().equals("screenName")) {
            login = this.getScreenName();
        } else if (company.getAuthType().equals("userId")) {
            login = String.valueOf(this.getUserId());
        }
        return login;
    }

    public boolean getMale() throws PortalException, SystemException {
        return this.getContact().getMale();
    }

    public List<Group> getMyPlaces() throws PortalException, SystemException {
        return this.getMyPlaces(-1);
    }

    public List<Group> getMyPlaces(int max) throws PortalException, SystemException {
        Object myPlaces = new UniqueList();
        if (this.isDefaultUser()) {
            return myPlaces;
        }
        int start = -1;
        int end = -1;
        if (max != -1) {
            start = 0;
            end = max;
        }
        LinkedHashMap<String, Long> groupParams = new LinkedHashMap<String, Long>();
        groupParams.put("usersGroups", new Long(this.getUserId()));
        myPlaces.addAll(GroupLocalServiceUtil.search((long)this.getCompanyId(), null, null, groupParams, (int)start, (int)end));
        LinkedHashMap<String, Long> organizationParams = new LinkedHashMap<String, Long>();
        organizationParams.put("usersOrgs", new Long(this.getUserId()));
        List userOrgs = OrganizationLocalServiceUtil.search((long)this.getCompanyId(), (long)-1L, null, null, null, null, organizationParams, (int)start, (int)end);
        for (Organization organization : userOrgs) {
            myPlaces.add(0, organization.getGroup());
            if (PropsValues.ORGANIZATIONS_MEMBERSHIP_STRICT) continue;
            for (Organization ancestorOrganization : organization.getAncestors()) {
                myPlaces.add(0, ancestorOrganization.getGroup());
            }
        }
        if (PropsValues.LAYOUT_USER_PRIVATE_LAYOUTS_ENABLED || PropsValues.LAYOUT_USER_PUBLIC_LAYOUTS_ENABLED) {
            Group userGroup = this.getGroup();
            myPlaces.add(0, userGroup);
        }
        if (max != -1 && myPlaces.size() > max) {
            myPlaces = ListUtil.subList((List)myPlaces, (int)start, (int)end);
        }
        return myPlaces;
    }

    public long[] getOrganizationIds() throws PortalException, SystemException {
        List<Organization> organizations = this.getOrganizations();
        long[] organizationIds = new long[organizations.size()];
        int i = 0;
        while (i < organizations.size()) {
            Organization organization = organizations.get(i);
            organizationIds[i] = organization.getOrganizationId();
            ++i;
        }
        return organizationIds;
    }

    public List<Organization> getOrganizations() throws PortalException, SystemException {
        return OrganizationLocalServiceUtil.getUserOrganizations((long)this.getUserId());
    }

    public boolean getPasswordModified() {
        return this._passwordModified;
    }

    public PasswordPolicy getPasswordPolicy() throws PortalException, SystemException {
        return PasswordPolicyLocalServiceUtil.getPasswordPolicyByUserId((long)this.getUserId());
    }

    public String getPasswordUnencrypted() {
        return this._passwordUnencrypted;
    }

    public int getPrivateLayoutsPageCount() throws PortalException, SystemException {
        Group group = this.getGroup();
        return group.getPrivateLayoutsPageCount();
    }

    public int getPublicLayoutsPageCount() throws PortalException, SystemException {
        Group group = this.getGroup();
        return group.getPublicLayoutsPageCount();
    }

    public Set<String> getReminderQueryQuestions() throws PortalException, SystemException {
        TreeSet<String> questions = new TreeSet<String>();
        List organizations = OrganizationLocalServiceUtil.getUserOrganizations((long)this.getUserId(), (boolean)true);
        for (Organization organization : organizations) {
            Set organizationQuestions = organization.getReminderQueryQuestions(this.getLanguageId());
            if (organizationQuestions.size() == 0) {
                Organization parentOrganization = organization.getParentOrganization();
                while (organizationQuestions.size() == 0 && parentOrganization != null) {
                    organizationQuestions = parentOrganization.getReminderQueryQuestions(this.getLanguageId());
                    parentOrganization = parentOrganization.getParentOrganization();
                }
            }
            questions.addAll(organizationQuestions);
        }
        if (questions.size() == 0) {
            Set defaultQuestions = SetUtil.fromArray((Object[])PropsUtil.getArray("users.reminder.queries.questions"));
            questions.addAll(defaultQuestions);
        }
        return questions;
    }

    public long[] getRoleIds() throws SystemException {
        List<Role> roles = this.getRoles();
        long[] roleIds = new long[roles.size()];
        int i = 0;
        while (i < roles.size()) {
            Role role = roles.get(i);
            roleIds[i] = role.getRoleId();
            ++i;
        }
        return roleIds;
    }

    public List<Role> getRoles() throws SystemException {
        return RoleLocalServiceUtil.getUserRoles((long)this.getUserId());
    }

    public double getSocialContributionEquity() {
        if (this._socialContributionEquity == null) {
            try {
                SocialEquityValue socialEquityValue = SocialEquityUserLocalServiceUtil.getContributionEquity((long)this.getUserId());
                this._socialContributionEquity = new AtomicReference<Double>(socialEquityValue.getValue());
            }
            catch (SystemException systemException) {
                return 0.0;
            }
        }
        return this._socialContributionEquity.get();
    }

    public double getSocialParticipationEquity() {
        if (this._socialParticipationEquity == null) {
            try {
                SocialEquityValue socialEquityValue = SocialEquityUserLocalServiceUtil.getParticipationEquity((long)this.getUserId());
                this._socialParticipationEquity = new AtomicReference<Double>(socialEquityValue.getValue());
            }
            catch (SystemException systemException) {
                return 0.0;
            }
        }
        return this._socialParticipationEquity.get();
    }

    public double getSocialPersonalEquity() {
        return this.getSocialContributionEquity() + this.getSocialParticipationEquity();
    }

    public long[] getTeamIds() throws SystemException {
        List<Team> teams = this.getTeams();
        long[] teamIds = new long[teams.size()];
        int i = 0;
        while (i < teams.size()) {
            Team team = teams.get(i);
            teamIds[i] = team.getTeamId();
            ++i;
        }
        return teamIds;
    }

    public List<Team> getTeams() throws SystemException {
        return TeamLocalServiceUtil.getUserTeams((long)this.getUserId());
    }

    public long[] getUserGroupIds() throws SystemException {
        List<UserGroup> userGroups = this.getUserGroups();
        long[] userGroupIds = new long[userGroups.size()];
        int i = 0;
        while (i < userGroups.size()) {
            UserGroup userGroup = userGroups.get(i);
            userGroupIds[i] = userGroup.getUserGroupId();
            ++i;
        }
        return userGroupIds;
    }

    public List<UserGroup> getUserGroups() throws SystemException {
        return UserGroupLocalServiceUtil.getUserUserGroups((long)this.getUserId());
    }

    public TimeZone getTimeZone() {
        return this._timeZone;
    }

    public boolean hasCompanyMx() throws PortalException, SystemException {
        return this.hasCompanyMx(this.getEmailAddress());
    }

    public boolean hasCompanyMx(String emailAddress) throws PortalException, SystemException {
        if (Validator.isNull((String)emailAddress)) {
            return false;
        }
        Company company = CompanyLocalServiceUtil.getCompanyById((long)this.getCompanyId());
        return company.hasCompanyMx(emailAddress);
    }

    public boolean hasMyPlaces() throws SystemException {
        if (this.isDefaultUser()) {
            return false;
        }
        LinkedHashMap<String, Long> groupParams = new LinkedHashMap<String, Long>();
        groupParams.put("usersGroups", new Long(this.getUserId()));
        int count = GroupLocalServiceUtil.searchCount((long)this.getCompanyId(), null, null, groupParams);
        if (count > 0) {
            return true;
        }
        count = OrganizationLocalServiceUtil.getUserOrganizationsCount((long)this.getUserId());
        if (count > 0) {
            return true;
        }
        return PropsValues.LAYOUT_USER_PRIVATE_LAYOUTS_ENABLED || PropsValues.LAYOUT_USER_PUBLIC_LAYOUTS_ENABLED;
    }

    public boolean hasOrganization() throws PortalException, SystemException {
        return this.getOrganizations().size() > 0;
    }

    public boolean hasPrivateLayouts() throws PortalException, SystemException {
        return this.getPrivateLayoutsPageCount() > 0;
    }

    public boolean hasPublicLayouts() throws PortalException, SystemException {
        return this.getPublicLayoutsPageCount() > 0;
    }

    public boolean hasReminderQuery() {
        return Validator.isNotNull((String)this.getReminderQueryQuestion()) && Validator.isNotNull((String)this.getReminderQueryAnswer());
    }

    public boolean isFemale() throws PortalException, SystemException {
        return this.getFemale();
    }

    public boolean isMale() throws PortalException, SystemException {
        return this.getMale();
    }

    public boolean isPasswordModified() {
        return this._passwordModified;
    }

    @Override
    public void setLanguageId(String languageId) {
        this._locale = LocaleUtil.fromLanguageId((String)languageId);
        super.setLanguageId(LocaleUtil.toLanguageId((Locale)this._locale));
    }

    public void setPasswordModified(boolean passwordModified) {
        this._passwordModified = passwordModified;
    }

    public void setPasswordUnencrypted(String passwordUnencrypted) {
        this._passwordUnencrypted = passwordUnencrypted;
    }

    @Override
    public void setTimeZoneId(String timeZoneId) {
        if (Validator.isNull((String)timeZoneId)) {
            timeZoneId = TimeZoneUtil.getDefault().getID();
        }
        this._timeZone = TimeZoneUtil.getTimeZone((String)timeZoneId);
        super.setTimeZoneId(timeZoneId);
    }

    public void updateSocialContributionEquity(double value) {
        if (this._socialContributionEquity != null) {
            double currentValue = 0.0;
            double newValue = 0.0;
            do {
                currentValue = this._socialContributionEquity.get();
                newValue = currentValue + value;
            } while (!this._socialContributionEquity.compareAndSet(currentValue, newValue));
        }
    }

    public void updateSocialParticipationEquity(double value) {
        if (this._socialParticipationEquity != null) {
            double currentValue = 0.0;
            double newValue = 0.0;
            do {
                currentValue = this._socialParticipationEquity.get();
                newValue = currentValue + value;
            } while (!this._socialParticipationEquity.compareAndSet(currentValue, newValue));
        }
    }
}

