/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lar;

import com.liferay.counter.service.CounterLocalServiceUtil;
import com.liferay.portal.LARFileException;
import com.liferay.portal.LARTypeException;
import com.liferay.portal.LayoutImportException;
import com.liferay.portal.NoSuchLayoutException;
import com.liferay.portal.kernel.cluster.ClusterExecutorUtil;
import com.liferay.portal.kernel.cluster.ClusterRequest;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.UserIdStrategy;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Time;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.zip.ZipReader;
import com.liferay.portal.kernel.zip.ZipReaderFactoryUtil;
import com.liferay.portal.lar.LayoutCache;
import com.liferay.portal.lar.PermissionImporter;
import com.liferay.portal.lar.PortletDataContextImpl;
import com.liferay.portal.lar.PortletDataContextListenerImpl;
import com.liferay.portal.lar.PortletImporter;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.LayoutTemplate;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.User;
import com.liferay.portal.model.impl.ColorSchemeImpl;
import com.liferay.portal.service.ImageLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.service.LayoutTemplateLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.persistence.LayoutUtil;
import com.liferay.portal.service.persistence.UserUtil;
import com.liferay.portal.theme.ThemeLoader;
import com.liferay.portal.theme.ThemeLoaderFactory;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.asset.DuplicateVocabularyException;
import com.liferay.portlet.asset.model.AssetVocabulary;
import com.liferay.portlet.asset.service.AssetVocabularyLocalServiceUtil;
import com.liferay.portlet.asset.service.persistence.AssetVocabularyUtil;
import com.liferay.portlet.journal.model.JournalArticle;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.time.StopWatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutImporter {
    private static Log _log = LogFactoryUtil.getLog(LayoutImporter.class);
    private static MethodHandler _loadThemesMethodHandler = new MethodHandler(new MethodKey(ThemeLoaderFactory.class.getName(), "loadThemes", new Class[0]), new Object[0]);
    private PermissionImporter _permissionImporter = new PermissionImporter();
    private PortletImporter _portletImporter = new PortletImporter();

    public void importLayouts(long userId, long groupId, boolean privateLayout, Map<String, String[]> parameterMap, File file) throws Exception {
        boolean deleteMissingLayouts = MapUtil.getBoolean(parameterMap, (String)"DELETE_MISSING_LAYOUTS", (boolean)Boolean.TRUE);
        boolean deletePortletData = MapUtil.getBoolean(parameterMap, (String)"DELETE_PORTLET_DATA");
        boolean importCategories = MapUtil.getBoolean(parameterMap, (String)"CATEGORIES");
        boolean importPermissions = MapUtil.getBoolean(parameterMap, (String)"PERMISSIONS");
        boolean importUserPermissions = MapUtil.getBoolean(parameterMap, (String)"PERMISSIONS");
        boolean importPortletData = MapUtil.getBoolean(parameterMap, (String)"PORTLET_DATA");
        boolean importPortletSetup = MapUtil.getBoolean(parameterMap, (String)"PORTLET_SETUP");
        boolean importPortletArchivedSetups = MapUtil.getBoolean(parameterMap, (String)"PORTLET_ARCHIVED_SETUPS");
        boolean importPortletUserPreferences = MapUtil.getBoolean(parameterMap, (String)"PORTLET_USER_PREFERENCES");
        boolean importTheme = MapUtil.getBoolean(parameterMap, (String)"THEME");
        String layoutsImportMode = MapUtil.getString(parameterMap, (String)"LAYOUTS_IMPORT_MODE", (String)"MERGE_BY_LAYOUT_ID");
        String portletsMergeMode = MapUtil.getString(parameterMap, (String)"PORTLETS_MERGE_MODE", (String)"REPLACE");
        String userIdStrategy = MapUtil.getString(parameterMap, (String)"USER_ID_STRATEGY");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Delete portlet data " + deletePortletData));
            _log.debug((Object)("Import categories " + importCategories));
            _log.debug((Object)("Import permissions " + importPermissions));
            _log.debug((Object)("Import user permissions " + importUserPermissions));
            _log.debug((Object)("Import portlet data " + importPortletData));
            _log.debug((Object)("Import portlet setup " + importPortletSetup));
            _log.debug((Object)("Import portlet archived setups " + importPortletArchivedSetups));
            _log.debug((Object)("Import portlet user preferences " + importPortletUserPreferences));
            _log.debug((Object)("Import theme " + importTheme));
        }
        StopWatch stopWatch = null;
        if (_log.isInfoEnabled()) {
            stopWatch = new StopWatch();
            stopWatch.start();
        }
        LayoutCache layoutCache = new LayoutCache();
        LayoutSet layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)groupId, (boolean)privateLayout);
        long companyId = layoutSet.getCompanyId();
        User user = UserUtil.findByPrimaryKey((long)userId);
        UserIdStrategy strategy = this._portletImporter.getUserIdStrategy(user, userIdStrategy);
        ZipReader zipReader = ZipReaderFactoryUtil.getZipReader((File)file);
        PortletDataContextImpl context = new PortletDataContextImpl(companyId, groupId, parameterMap, new HashSet<String>(), strategy, zipReader);
        context.setPortetDataContextListener(new PortletDataContextListenerImpl(context));
        context.setPrivateLayout(privateLayout);
        Element rootElement = null;
        InputStream themeZip = null;
        String xml = context.getZipEntryAsString("/manifest.xml");
        if (xml == null) {
            throw new LARFileException("manifest.xml not found in the LAR");
        }
        try {
            Document document = SAXReaderUtil.read((String)xml);
            rootElement = document.getRootElement();
        }
        catch (Exception e) {
            throw new LARFileException((Throwable)e);
        }
        Element headerElement = rootElement.element("header");
        int buildNumber = ReleaseInfo.getBuildNumber();
        int importBuildNumber = GetterUtil.getInteger((String)headerElement.attributeValue("build-number"));
        if (buildNumber != importBuildNumber) {
            throw new LayoutImportException("LAR build number " + importBuildNumber + " does not match " + "portal build number " + buildNumber);
        }
        String larType = headerElement.attributeValue("type");
        if (!larType.equals("layout-set")) {
            throw new LARTypeException("Invalid type of LAR file (" + larType + ")");
        }
        long sourceGroupId = GetterUtil.getLong((String)headerElement.attributeValue("group-id"));
        context.setSourceGroupId(sourceGroupId);
        if (importTheme) {
            themeZip = context.getZipEntryAsInputStream("theme.zip");
        }
        String themeId = headerElement.attributeValue("theme-id");
        String colorSchemeId = headerElement.attributeValue("color-scheme-id");
        boolean useThemeZip = false;
        if (themeZip != null) {
            String importThemeId = this.importTheme(layoutSet, themeZip);
            if (importThemeId != null) {
                themeId = importThemeId;
                colorSchemeId = ColorSchemeImpl.getDefaultRegularColorSchemeId();
                useThemeZip = true;
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Importing theme takes " + stopWatch.getTime() + " ms"));
            }
        }
        boolean wapTheme = false;
        LayoutSetLocalServiceUtil.updateLookAndFeel((long)groupId, (boolean)privateLayout, (String)themeId, (String)colorSchemeId, (String)"", (boolean)wapTheme);
        if (importPermissions) {
            this._permissionImporter.readPortletDataPermissions(context);
        }
        if (importCategories) {
            this._portletImporter.readCategories(context);
        }
        this._portletImporter.readComments(context, rootElement);
        this._portletImporter.readLocks(context, rootElement);
        this._portletImporter.readRatings(context, rootElement);
        this._portletImporter.readTags(context, rootElement);
        List previousLayouts = LayoutUtil.findByG_P((long)groupId, (boolean)privateLayout);
        ArrayList<Layout> newLayouts = new ArrayList<Layout>();
        HashSet<Long> newLayoutIds = new HashSet<Long>();
        Map newLayoutsMap = context.getNewPrimaryKeysMap(Layout.class);
        Element layoutsElement = rootElement.element("layouts");
        List layoutElements = layoutsElement.elements("layout");
        if (_log.isDebugEnabled() && layoutElements.size() > 0) {
            _log.debug((Object)"Importing layouts");
        }
        for (Element layoutElement : layoutElements) {
            this.importLayout(context, user, layoutCache, previousLayouts, newLayouts, newLayoutsMap, newLayoutIds, portletsMergeMode, themeId, colorSchemeId, layoutsImportMode, privateLayout, importPermissions, importUserPermissions, useThemeZip, rootElement, layoutElement);
        }
        Element portletsElement = rootElement.element("portlets");
        List portletElements = portletsElement.elements("portlet");
        if (deletePortletData) {
            if (_log.isDebugEnabled() && portletElements.size() > 0) {
                _log.debug((Object)"Deleting portlet data");
            }
            for (Element portletElement : portletElements) {
                String portletId = portletElement.attributeValue("portlet-id");
                long layoutId = GetterUtil.getLong((String)portletElement.attributeValue("layout-id"));
                long plid = ((Layout)newLayoutsMap.get(layoutId)).getPlid();
                context.setPlid(plid);
                this._portletImporter.deletePortletData((PortletDataContext)context, portletId, plid);
            }
        }
        if (_log.isDebugEnabled() && portletElements.size() > 0) {
            _log.debug((Object)"Importing portlets");
        }
        for (Element portletElement : portletElements) {
            String portletPath = portletElement.attributeValue("path");
            String portletId = portletElement.attributeValue("portlet-id");
            long layoutId = GetterUtil.getLong((String)portletElement.attributeValue("layout-id"));
            long plid = ((Layout)newLayoutsMap.get(layoutId)).getPlid();
            long oldPlid = GetterUtil.getLong((String)portletElement.attributeValue("old-plid"));
            Layout layout = null;
            try {
                layout = LayoutUtil.findByPrimaryKey((long)plid);
            }
            catch (NoSuchLayoutException noSuchLayoutException) {
                continue;
            }
            context.setPlid(plid);
            context.setOldPlid(oldPlid);
            Document portletDocument = SAXReaderUtil.read((String)context.getZipEntryAsString(portletPath));
            portletElement = portletDocument.getRootElement();
            this._portletImporter.importPortletPreferences(context, layoutSet.getCompanyId(), layout.getGroupId(), layout, null, portletElement, importPortletSetup, importPortletArchivedSetups, importPortletUserPreferences, false);
            String scopeLayoutUuid = GetterUtil.getString((String)portletElement.attributeValue("scope-layout-uuid"));
            context.setScopeLayoutUuid(scopeLayoutUuid);
            Element portletDataElement = portletElement.element("portlet-data");
            if (importPortletData && portletDataElement != null) {
                this._portletImporter.importPortletData((PortletDataContext)context, portletId, plid, portletDataElement);
            }
            if (importPermissions) {
                this._permissionImporter.importPortletPermissions(layoutCache, companyId, groupId, userId, layout, portletElement, portletId, importUserPermissions);
            }
            this._portletImporter.importPortletPreferences(context, layoutSet.getCompanyId(), groupId, null, null, portletElement, importPortletSetup, importPortletArchivedSetups, importPortletUserPreferences, false);
        }
        if (deleteMissingLayouts) {
            this.deleteMissingLayouts(groupId, privateLayout, newLayoutIds, previousLayouts);
        }
        LayoutSetLocalServiceUtil.updatePageCount((long)groupId, (boolean)privateLayout);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Importing layouts takes " + stopWatch.getTime() + " ms"));
        }
        for (Layout layout : newLayouts) {
            UnicodeProperties typeSettingsProperties = layout.getTypeSettingsProperties();
            String articleId = typeSettingsProperties.getProperty("article-id");
            if (!Validator.isNotNull((String)articleId)) continue;
            Map articleIds = context.getNewPrimaryKeysMap(JournalArticle.class);
            typeSettingsProperties.setProperty("article-id", MapUtil.getString((Map)articleIds, (String)articleId, (String)articleId));
            LayoutUtil.update((Layout)layout, (boolean)false);
        }
        zipReader.close();
    }

    protected String[] appendPortletIds(String[] portletIds, String[] newPortletIds, String portletsMergeMode) {
        String[] stringArray = newPortletIds;
        int n = newPortletIds.length;
        int n2 = 0;
        while (n2 < n) {
            String portletId = stringArray[n2];
            if (!ArrayUtil.contains((Object[])portletIds, (Object)portletId)) {
                portletIds = portletsMergeMode.equals("ADD_TO_BOTTOM") ? (String[])ArrayUtil.append((Object[])portletIds, (Object)portletId) : (String[])ArrayUtil.append((Object[])new String[]{portletId}, (Object[])portletIds);
            }
            ++n2;
        }
        return portletIds;
    }

    protected void deleteMissingLayouts(long groupId, boolean privateLayout, Set<Long> newLayoutIds, List<Layout> previousLayouts) throws Exception {
        if (_log.isDebugEnabled() && newLayoutIds.size() > 0) {
            _log.debug((Object)"Delete missing layouts");
        }
        for (Layout layout : previousLayouts) {
            if (newLayoutIds.contains(layout.getLayoutId())) continue;
            try {
                LayoutLocalServiceUtil.deleteLayout((Layout)layout, (boolean)false);
            }
            catch (NoSuchLayoutException noSuchLayoutException) {}
        }
        LayoutSetLocalServiceUtil.updatePageCount((long)groupId, (boolean)privateLayout);
    }

    protected void fixTypeSettings(Layout layout) throws Exception {
        if (!layout.isTypeURL()) {
            return;
        }
        UnicodeProperties typeSettings = layout.getTypeSettingsProperties();
        String url = GetterUtil.getString((String)typeSettings.getProperty("url"));
        String friendlyURLPrivateGroupPath = PropsValues.LAYOUT_FRIENDLY_URL_PRIVATE_GROUP_SERVLET_MAPPING;
        String friendlyURLPrivateUserPath = PropsValues.LAYOUT_FRIENDLY_URL_PRIVATE_USER_SERVLET_MAPPING;
        String friendlyURLPublicPath = PropsValues.LAYOUT_FRIENDLY_URL_PUBLIC_SERVLET_MAPPING;
        if (!(url.startsWith(friendlyURLPrivateGroupPath) || url.startsWith(friendlyURLPrivateUserPath) || url.startsWith(friendlyURLPublicPath))) {
            return;
        }
        int x = url.indexOf(47, 1);
        if (x == -1) {
            return;
        }
        int y = url.indexOf(47, x + 1);
        if (y == -1) {
            return;
        }
        String friendlyURL = url.substring(x, y);
        if (!friendlyURL.equals("/[$SAME_GROUP_FRIENDLY_URL$]")) {
            return;
        }
        typeSettings.setProperty("url", String.valueOf(url.substring(0, x)) + layout.getGroup().getFriendlyURL() + url.substring(y));
    }

    protected AssetVocabulary getAssetVocabulary(PortletDataContext context, String vocabularyUuid, String vocabularyName, String userUuid, ServiceContext serviceContext) throws Exception {
        AssetVocabulary assetVocabulary = null;
        try {
            if (context.getDataStrategy().equals("DATA_STRATEGY_MIRROR")) {
                AssetVocabulary existingAssetVocabulary = AssetVocabularyUtil.fetchByUUID_G((String)vocabularyUuid, (long)context.getGroupId());
                if (existingAssetVocabulary == null) {
                    HashMap<Locale, String> titleMap = new HashMap<Locale, String>();
                    titleMap.put(LocaleUtil.getDefault(), vocabularyName);
                    serviceContext.setUuid(vocabularyUuid);
                    assetVocabulary = AssetVocabularyLocalServiceUtil.addVocabulary((long)context.getUserId(userUuid), titleMap, null, (String)"", (ServiceContext)serviceContext);
                } else {
                    assetVocabulary = AssetVocabularyLocalServiceUtil.updateVocabulary((long)existingAssetVocabulary.getVocabularyId(), (Map)existingAssetVocabulary.getTitleMap(), (Map)existingAssetVocabulary.getDescriptionMap(), (String)existingAssetVocabulary.getSettings(), (ServiceContext)serviceContext);
                }
            } else {
                HashMap<Locale, String> titleMap = new HashMap<Locale, String>();
                titleMap.put(LocaleUtil.getDefault(), vocabularyName);
                assetVocabulary = AssetVocabularyLocalServiceUtil.addVocabulary((long)context.getUserId(userUuid), titleMap, null, (String)"", (ServiceContext)serviceContext);
            }
        }
        catch (DuplicateVocabularyException duplicateVocabularyException) {
            assetVocabulary = AssetVocabularyLocalServiceUtil.getGroupVocabulary((long)context.getGroupId(), (String)vocabularyName);
        }
        return assetVocabulary;
    }

    protected void importLayout(PortletDataContext context, User user, LayoutCache layoutCache, List<Layout> previousLayouts, List<Layout> newLayouts, Map<Long, Layout> newLayoutsMap, Set<Long> newLayoutIds, String portletsMergeMode, String themeId, String colorSchemeId, String layoutsImportMode, boolean privateLayout, boolean importPermissions, boolean importUserPermissions, boolean useThemeZip, Element rootElement, Element layoutElement) throws Exception {
        long layoutId;
        long groupId = context.getGroupId();
        String layoutUuid = GetterUtil.getString((String)layoutElement.attributeValue("layout-uuid"));
        long oldLayoutId = layoutId = (long)GetterUtil.getInteger((String)layoutElement.attributeValue("layout-id"));
        boolean deleteLayout = GetterUtil.getBoolean((String)layoutElement.attributeValue("delete"));
        if (deleteLayout) {
            try {
                Layout layout = LayoutLocalServiceUtil.getLayoutByUuidAndGroupId((String)layoutUuid, (long)groupId);
                if (layout != null) {
                    newLayoutsMap.put(oldLayoutId, layout);
                    LayoutLocalServiceUtil.deleteLayout((Layout)layout);
                }
            }
            catch (NoSuchLayoutException noSuchLayoutException) {
                _log.warn((Object)("Error deleting layout for {" + layoutUuid + ", " + groupId + "}"));
            }
            return;
        }
        String path = layoutElement.attributeValue("path");
        if (!context.isPathNotProcessed(path)) {
            return;
        }
        Layout layout = (Layout)context.getZipEntryAsObject(path);
        Layout existingLayout = null;
        Layout importedLayout = null;
        String friendlyURL = layout.getFriendlyURL();
        if (layoutsImportMode.equals("ADD_AS_NEW")) {
            layoutId = LayoutLocalServiceUtil.getNextLayoutId((long)groupId, (boolean)privateLayout);
            friendlyURL = "/" + layoutId;
        } else if (layoutsImportMode.equals("MERGE_BY_LAYOUT_NAME")) {
            Locale locale = LocaleUtil.getDefault();
            String localizedName = layout.getName(locale);
            for (Layout curLayout : previousLayouts) {
                if (!curLayout.getName(locale).equals(localizedName)) continue;
                existingLayout = curLayout;
                break;
            }
            if (existingLayout == null) {
                layoutId = LayoutLocalServiceUtil.getNextLayoutId((long)groupId, (boolean)privateLayout);
            }
        } else {
            existingLayout = LayoutUtil.fetchByUUID_G((String)layout.getUuid(), (long)groupId);
            if (existingLayout == null) {
                existingLayout = LayoutUtil.fetchByG_P_F((long)groupId, (boolean)privateLayout, (String)friendlyURL);
            }
            if (existingLayout == null) {
                layoutId = LayoutLocalServiceUtil.getNextLayoutId((long)groupId, (boolean)privateLayout);
            }
        }
        if (_log.isDebugEnabled()) {
            if (existingLayout == null) {
                _log.debug((Object)("Layout with {groupId=" + groupId + ",privateLayout=" + privateLayout + ",layoutId=" + layoutId + "} does not exist"));
            } else {
                _log.debug((Object)("Layout with {groupId=" + groupId + ",privateLayout=" + privateLayout + ",layoutId=" + layoutId + "} exists"));
            }
        }
        if (existingLayout == null) {
            long plid = CounterLocalServiceUtil.increment();
            importedLayout = LayoutUtil.create((long)plid);
            importedLayout.setUuid(layout.getUuid());
            importedLayout.setGroupId(groupId);
            importedLayout.setPrivateLayout(privateLayout);
            importedLayout.setLayoutId(layoutId);
            if (layout.isIconImage()) {
                long iconImageId = CounterLocalServiceUtil.increment();
                importedLayout.setIconImageId(iconImageId);
            }
        } else {
            importedLayout = existingLayout;
        }
        newLayoutsMap.put(oldLayoutId, importedLayout);
        long parentLayoutId = layout.getParentLayoutId();
        Node parentLayoutNode = rootElement.selectSingleNode("./layouts/layout[@layout-id='" + parentLayoutId + "']");
        if (parentLayoutId != 0L && parentLayoutNode != null) {
            this.importLayout(context, user, layoutCache, previousLayouts, newLayouts, newLayoutsMap, newLayoutIds, portletsMergeMode, themeId, colorSchemeId, layoutsImportMode, privateLayout, importPermissions, importUserPermissions, useThemeZip, rootElement, (Element)parentLayoutNode);
            Layout parentLayout = newLayoutsMap.get(parentLayoutId);
            parentLayoutId = parentLayout.getLayoutId();
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Importing layout with layout id " + layoutId + " and parent layout id " + parentLayoutId));
        }
        importedLayout.setCompanyId(user.getCompanyId());
        importedLayout.setParentLayoutId(parentLayoutId);
        importedLayout.setName(layout.getName());
        importedLayout.setTitle(layout.getTitle());
        importedLayout.setDescription(layout.getDescription());
        importedLayout.setType(layout.getType());
        if (layout.isTypePortlet() && Validator.isNotNull((String)layout.getTypeSettings()) && !portletsMergeMode.equals("REPLACE")) {
            this.mergePortlets(importedLayout, layout.getTypeSettings(), portletsMergeMode);
        } else if (layout.isTypeLinkToLayout()) {
            UnicodeProperties typeSettingsProperties = layout.getTypeSettingsProperties();
            long linkToLayoutId = GetterUtil.getLong((String)typeSettingsProperties.getProperty("linkToLayoutId", ""));
            if (linkToLayoutId > 0L) {
                Node linkedLayoutNode = rootElement.selectSingleNode("./layouts/layout[@layout-id='" + linkToLayoutId + "']");
                this.importLayout(context, user, layoutCache, previousLayouts, newLayouts, newLayoutsMap, newLayoutIds, portletsMergeMode, themeId, colorSchemeId, layoutsImportMode, privateLayout, importPermissions, importUserPermissions, useThemeZip, rootElement, (Element)linkedLayoutNode);
                Layout linkedLayout = newLayoutsMap.get(linkToLayoutId);
                typeSettingsProperties.setProperty("linkToLayoutId", String.valueOf(linkedLayout.getLayoutId()));
            }
            importedLayout.setTypeSettings(layout.getTypeSettings());
        } else {
            importedLayout.setTypeSettings(layout.getTypeSettings());
        }
        importedLayout.setHidden(layout.isHidden());
        importedLayout.setFriendlyURL(friendlyURL);
        if (useThemeZip) {
            importedLayout.setThemeId("");
            importedLayout.setColorSchemeId("");
        } else {
            importedLayout.setThemeId(layout.getThemeId());
            importedLayout.setColorSchemeId(layout.getColorSchemeId());
        }
        importedLayout.setWapThemeId(layout.getWapThemeId());
        importedLayout.setWapColorSchemeId(layout.getWapColorSchemeId());
        importedLayout.setCss(layout.getCss());
        importedLayout.setPriority(layout.getPriority());
        this.fixTypeSettings(importedLayout);
        if (layout.isIconImage()) {
            String iconImagePath = layoutElement.elementText("icon-image-path");
            byte[] iconBytes = context.getZipEntryAsByteArray(iconImagePath);
            if (iconBytes != null && iconBytes.length > 0) {
                importedLayout.setIconImage(true);
                ImageLocalServiceUtil.updateImage((long)importedLayout.getIconImageId(), (byte[])iconBytes);
            }
        } else {
            ImageLocalServiceUtil.deleteImage((long)importedLayout.getIconImageId());
        }
        LayoutUtil.update((Layout)importedLayout, (boolean)false);
        context.setPlid(importedLayout.getPlid());
        context.setOldPlid(layout.getPlid());
        newLayoutIds.add(importedLayout.getLayoutId());
        newLayouts.add(importedLayout);
        if (importPermissions) {
            this._permissionImporter.importLayoutPermissions(layoutCache, context.getCompanyId(), groupId, user.getUserId(), importedLayout, layoutElement, rootElement, importUserPermissions);
        }
        this._portletImporter.importPortletData(context, "87", null, layoutElement);
    }

    protected String importTheme(LayoutSet layoutSet, InputStream themeZip) throws Exception {
        ThemeLoader themeLoader = ThemeLoaderFactory.getDefaultThemeLoader();
        if (themeLoader == null) {
            _log.error((Object)"No theme loaders are deployed");
            return null;
        }
        ZipReader zipReader = ZipReaderFactoryUtil.getZipReader((InputStream)themeZip);
        String lookAndFeelXML = zipReader.getEntryAsString("liferay-look-and-feel.xml");
        String themeId = String.valueOf(layoutSet.getGroupId());
        themeId = layoutSet.isPrivateLayout() ? String.valueOf(themeId) + "-private" : String.valueOf(themeId) + "-public";
        if (PropsValues.THEME_LOADER_NEW_THEME_ID_ON_IMPORT) {
            Date now = new Date();
            themeId = String.valueOf(themeId) + "-" + Time.getShortTimestamp((Date)now);
        }
        String themeName = themeId;
        lookAndFeelXML = StringUtil.replace((String)lookAndFeelXML, (String[])new String[]{"[$GROUP_ID$]", "[$THEME_ID$]", "[$THEME_NAME$]"}, (String[])new String[]{String.valueOf(layoutSet.getGroupId()), themeId, themeName});
        FileUtil.deltree((String)(themeLoader.getFileStorage() + "/" + themeId));
        List zipEntries = zipReader.getEntries();
        for (String zipEntry : zipEntries) {
            String key = zipEntry;
            if (key.contains("/")) {
                key = key.substring(key.lastIndexOf(47));
            }
            if (key.equals("liferay-look-and-feel.xml")) {
                FileUtil.write((String)(themeLoader.getFileStorage() + "/" + themeId + "/" + key), (byte[])lookAndFeelXML.getBytes());
                continue;
            }
            InputStream is = zipReader.getEntryAsInputStream(zipEntry);
            FileUtil.write((String)(themeLoader.getFileStorage() + "/" + themeId + "/" + key), (InputStream)is);
        }
        themeLoader.loadThemes();
        ClusterRequest clusterRequest = ClusterRequest.createMulticastRequest((MethodHandler)_loadThemesMethodHandler, (boolean)true);
        clusterRequest.setFireAndForget(true);
        ClusterExecutorUtil.execute((ClusterRequest)clusterRequest);
        themeId = String.valueOf(themeId) + "_WAR_" + themeLoader.getServletContextName();
        return PortalUtil.getJsSafePortletId((String)themeId);
    }

    protected void mergePortlets(Layout layout, String newTypeSettings, String portletsMergeMode) {
        try {
            String columnId2;
            UnicodeProperties previousProperties = layout.getTypeSettingsProperties();
            LayoutTypePortlet previousLayoutType = (LayoutTypePortlet)layout.getLayoutType();
            List previousColumns = previousLayoutType.getLayoutTemplate().getColumns();
            UnicodeProperties newProperties = new UnicodeProperties(true);
            newProperties.load(newTypeSettings);
            String layoutTemplateId = newProperties.getProperty("layout-template-id");
            LayoutTemplate newLayoutTemplate = LayoutTemplateLocalServiceUtil.getLayoutTemplate((String)layoutTemplateId, (boolean)false, null);
            Object[] lostPortletIds = new String[]{};
            for (String columnId2 : newLayoutTemplate.getColumns()) {
                String columnValue = newProperties.getProperty(columnId2);
                Object[] portletIds = StringUtil.split((String)columnValue);
                if (!previousColumns.contains(columnId2)) {
                    lostPortletIds = (String[])ArrayUtil.append((Object[])lostPortletIds, (Object[])portletIds);
                    continue;
                }
                String[] previousPortletIds = StringUtil.split((String)previousProperties.getProperty(columnId2));
                portletIds = this.appendPortletIds(previousPortletIds, (String[])portletIds, portletsMergeMode);
                previousProperties.setProperty(columnId2, StringUtil.merge((Object[])portletIds));
            }
            columnId2 = (String)previousColumns.get(0);
            Object[] portletIds = StringUtil.split((String)previousProperties.getProperty(columnId2));
            this.appendPortletIds((String[])portletIds, (String[])lostPortletIds, portletsMergeMode);
            previousProperties.setProperty(columnId2, StringUtil.merge((Object[])portletIds));
            layout.setTypeSettings(previousProperties.toString());
        }
        catch (IOException iOException) {
            layout.setTypeSettings(newTypeSettings);
        }
    }
}

