/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.increment;

import com.liferay.portal.increment.BufferedIncreasableEntry;
import com.liferay.portal.kernel.concurrent.BatchablePipe;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;

public class BufferedIncrementMessageListener
implements MessageListener {
    private static Log _log = LogFactoryUtil.getLog(BufferedIncrementMessageListener.class);

    public void receive(Message message) {
        try {
            this.doReceive(message);
        }
        catch (Exception e) {
            _log.error((Object)("Unable to process message " + message), (Throwable)e);
        }
    }

    protected void doReceive(Message message) throws Exception {
        BufferedIncreasableEntry bufferedIncreasableEntry;
        BatchablePipe batchablePipe = (BatchablePipe)message.getPayload();
        while ((bufferedIncreasableEntry = (BufferedIncreasableEntry)batchablePipe.take()) != null) {
            try {
                bufferedIncreasableEntry.proceed();
            }
            catch (Throwable t) {
                _log.error((Object)"Cannot write buffered increment value to the database", t);
            }
        }
    }
}

