/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.freemarker;

import com.liferay.portal.freemarker.URLTemplateLoader;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PortalUtil;
import java.io.IOException;
import java.net.URL;
import javax.servlet.ServletContext;

public class ServletTemplateLoader
extends URLTemplateLoader {
    private static Log _log = LogFactoryUtil.getLog(ServletTemplateLoader.class);

    public URL getURL(String name) throws IOException {
        URL url = null;
        int pos = name.indexOf("_SERVLET_CONTEXT_");
        if (pos != -1) {
            ServletContext servletContext;
            String servletContextName = name.substring(0, pos);
            if (Validator.isNull((String)servletContextName)) {
                servletContextName = PortalUtil.getPathContext();
            }
            if ((servletContext = ServletContextPool.get((String)servletContextName)) != null) {
                String templateName = name.substring(pos + "_SERVLET_CONTEXT_".length());
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(String.valueOf(name) + " is associated with the servlet context " + servletContextName + " " + servletContext));
                }
                if ((url = servletContext.getResource(templateName)) == null && templateName.endsWith("/init_custom.ftl")) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)("The template " + name + " should be created"));
                    }
                    String portalServletContextName = PortalUtil.getPathContext();
                    ServletContext portalServletContext = ServletContextPool.get((String)portalServletContextName);
                    url = portalServletContext.getResource("/html/themes/_unstyled/template/init_custom.ftl");
                }
            } else {
                _log.error((Object)(String.valueOf(name) + " is not valid because " + servletContextName + " does not map to a servlet context"));
            }
        }
        return url;
    }
}

