/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.deploy.hot.messaging;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;

public class HotDeployMessageListener
implements MessageListener {
    private static Log _log = LogFactoryUtil.getLog(HotDeployMessageListener.class);

    public void receive(Message message) {
        try {
            this.doReceive(message);
        }
        catch (Exception e) {
            _log.error((Object)("Unable to process message " + message), (Throwable)e);
        }
    }

    protected void doReceive(Message message) throws Exception {
        String command = message.getString("command");
        String servletContextName = message.getString("servletContextName");
        if (_log.isDebugEnabled()) {
            if (command.equals("deploy")) {
                _log.debug((Object)(String.valueOf(servletContextName) + " was deployed"));
            } else if (command.equals("undeploy")) {
                _log.debug((Object)(String.valueOf(servletContextName) + " was undeployed"));
            }
        }
    }
}

