/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.shard;

import com.liferay.portal.util.PropsValues;
import java.util.Map;
import org.hibernate.SessionFactory;
import org.springframework.aop.TargetSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShardSessionFactoryTargetSource
implements TargetSource {
    private static ThreadLocal<SessionFactory> _sessionFactory = new ThreadLocal<SessionFactory>(){

        @Override
        protected SessionFactory initialValue() {
            return (SessionFactory)_sessionFactories.get(PropsValues.SHARD_DEFAULT_NAME);
        }
    };
    private static Map<String, SessionFactory> _sessionFactories;

    public SessionFactory getSessionFactory() {
        return _sessionFactory.get();
    }

    public Object getTarget() throws Exception {
        return this.getSessionFactory();
    }

    public Class<?> getTargetClass() {
        return _sessionFactories.get(PropsValues.SHARD_DEFAULT_NAME).getClass();
    }

    public boolean isStatic() {
        return false;
    }

    public void releaseTarget(Object target) throws Exception {
    }

    public void setSessionFactory(String shardName) {
        _sessionFactory.set(_sessionFactories.get(shardName));
    }

    public void setSessionFactories(Map<String, SessionFactory> sessionFactories) {
        _sessionFactories = sessionFactories;
    }
}

