/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.shard;

import com.liferay.portal.util.PropsValues;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.aop.TargetSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShardDataSourceTargetSource
implements TargetSource {
    private static ThreadLocal<DataSource> _dataSource = new ThreadLocal<DataSource>(){

        @Override
        protected DataSource initialValue() {
            return (DataSource)_dataSources.get(PropsValues.SHARD_DEFAULT_NAME);
        }
    };
    private static Map<String, DataSource> _dataSources;

    public DataSource getDataSource() {
        return _dataSource.get();
    }

    public Object getTarget() throws Exception {
        return this.getDataSource();
    }

    public Class<DataSource> getTargetClass() {
        return DataSource.class;
    }

    public boolean isStatic() {
        return false;
    }

    public void releaseTarget(Object target) throws Exception {
    }

    public void setDataSource(String shardName) {
        _dataSource.set(_dataSources.get(shardName));
    }

    public void setDataSources(Map<String, DataSource> dataSources) {
        _dataSources = dataSources;
    }
}

