/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.orm.hibernate;

import com.liferay.portal.dao.orm.hibernate.DialectImpl;
import com.liferay.portal.dao.orm.hibernate.SessionImpl;
import com.liferay.portal.kernel.bean.ClassLoaderBeanHandler;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.ORMException;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.util.PropsValues;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import org.hibernate.engine.SessionFactoryImplementor;

public class SessionFactoryImpl
implements SessionFactory {
    private static Log _log = LogFactoryUtil.getLog(SessionFactoryImpl.class);
    private ClassLoader _sessionFactoryClassLoader;
    private SessionFactoryImplementor _sessionFactoryImplementor;

    public void closeSession(Session session) throws ORMException {
        if (!PropsValues.SPRING_HIBERNATE_SESSION_DELEGATED) {
            session.close();
        }
    }

    public Dialect getDialect() throws ORMException {
        return new DialectImpl(this._sessionFactoryImplementor.getDialect());
    }

    public SessionFactoryImplementor getSessionFactoryImplementor() {
        return this._sessionFactoryImplementor;
    }

    public Session openNewSession(Connection connection) throws ORMException {
        return this.wrapSession((org.hibernate.Session)this._sessionFactoryImplementor.openSession(connection));
    }

    public Session openSession() throws ORMException {
        org.hibernate.classic.Session session = null;
        session = PropsValues.SPRING_HIBERNATE_SESSION_DELEGATED ? this._sessionFactoryImplementor.getCurrentSession() : this._sessionFactoryImplementor.openSession();
        if (_log.isDebugEnabled()) {
            org.hibernate.impl.SessionImpl sessionImpl = (org.hibernate.impl.SessionImpl)session;
            _log.debug((Object)("Session is using connection release mode " + sessionImpl.getConnectionReleaseMode()));
        }
        return this.wrapSession((org.hibernate.Session)session);
    }

    public void setSessionFactoryClassLoader(ClassLoader sessionFactoryClassLoader) {
        this._sessionFactoryClassLoader = sessionFactoryClassLoader;
    }

    public void setSessionFactoryImplementor(SessionFactoryImplementor sessionFactoryImplementor) {
        this._sessionFactoryImplementor = sessionFactoryImplementor;
    }

    protected Session wrapSession(org.hibernate.Session session) {
        SessionImpl liferaySession = new SessionImpl(session);
        if (this._sessionFactoryClassLoader != null) {
            liferaySession = (Session)Proxy.newProxyInstance(this._sessionFactoryClassLoader, new Class[]{Session.class}, (InvocationHandler)new ClassLoaderBeanHandler((Object)liferaySession, this._sessionFactoryClassLoader));
        }
        return liferaySession;
    }
}

