/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cluster;

import com.liferay.portal.cluster.ClusterInvokeThreadLocal;
import com.liferay.portal.kernel.cluster.ClusterExecutorUtil;
import com.liferay.portal.kernel.cluster.ClusterRequest;
import com.liferay.portal.kernel.cluster.Clusterable;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodTargetClassKey;
import com.liferay.portal.spring.aop.AnnotationChainableMethodAdvice;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInvocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterableAdvice
extends AnnotationChainableMethodAdvice<Clusterable> {
    private static Clusterable _nullClusterable = new Clusterable(){

        public Class<? extends Annotation> annotationType() {
            return Clusterable.class;
        }
    };
    private String _servletContextName;

    @Override
    public void afterReturning(MethodInvocation methodInvocation, Object result) throws Throwable {
        if (!ClusterInvokeThreadLocal.isEnabled()) {
            return;
        }
        MethodTargetClassKey methodTargetClassKey = this.buildMethodTargetClassKey(methodInvocation);
        Clusterable clusterable = (Clusterable)this.findAnnotation(methodTargetClassKey);
        if (clusterable == _nullClusterable) {
            return;
        }
        Method method = methodTargetClassKey.getMethod();
        Method utilClassMethod = this._getUtilClassMethod(method);
        MethodHandler methodHandler = new MethodHandler(utilClassMethod, methodInvocation.getArguments());
        ClusterRequest clusterRequest = ClusterRequest.createMulticastRequest((MethodHandler)methodHandler, (boolean)true);
        clusterRequest.setServletContextName(this._servletContextName);
        ClusterExecutorUtil.execute((ClusterRequest)clusterRequest);
    }

    @Override
    public Clusterable getNullAnnotation() {
        return _nullClusterable;
    }

    public void setServletContextName(String servletContextName) {
        this._servletContextName = servletContextName;
    }

    private Method _getUtilClassMethod(Method method) throws Exception {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        Class<?> declaringClass = method.getDeclaringClass();
        String utilClassName = declaringClass.getName().concat("Util");
        Class<?> utilClass = contextClassLoader.loadClass(utilClassName);
        return utilClass.getMethod(method.getName(), method.getParameterTypes());
    }
}

