/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cluster;

import com.liferay.portal.cluster.AddressImpl;
import com.liferay.portal.cluster.ClusterBase;
import com.liferay.portal.cluster.ClusterRequestReceiver;
import com.liferay.portal.cluster.DebuggingClusterEventListenerImpl;
import com.liferay.portal.kernel.cluster.Address;
import com.liferay.portal.kernel.cluster.ClusterEvent;
import com.liferay.portal.kernel.cluster.ClusterEventListener;
import com.liferay.portal.kernel.cluster.ClusterException;
import com.liferay.portal.kernel.cluster.ClusterExecutor;
import com.liferay.portal.kernel.cluster.ClusterMessageType;
import com.liferay.portal.kernel.cluster.ClusterNode;
import com.liferay.portal.kernel.cluster.ClusterNodeResponse;
import com.liferay.portal.kernel.cluster.ClusterRequest;
import com.liferay.portal.kernel.cluster.FutureClusterResponses;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.InetAddressUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.WeakValueConcurrentHashMap;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.util.PortalPortEventListener;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jgroups.ChannelException;
import org.jgroups.JChannel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterExecutorImpl
extends ClusterBase
implements ClusterExecutor,
PortalPortEventListener {
    private static final String _DEFAULT_CLUSTER_NAME = "LIFERAY-CONTROL-CHANNEL";
    private static Log _log = LogFactoryUtil.getLog(ClusterExecutorImpl.class);
    private Map<Address, ClusterNode> _addressMap = new ConcurrentHashMap<Address, ClusterNode>();
    private CopyOnWriteArrayList<ClusterEventListener> _clusterEventListeners = new CopyOnWriteArrayList();
    private Map<String, Address> _clusterNodeIdMap = new ConcurrentHashMap<String, Address>();
    private JChannel _controlChannel;
    private Map<String, FutureClusterResponses> _executionResultMap = new WeakValueConcurrentHashMap();
    private String _localClusterNodeId;
    private boolean _shortcutLocalMethod;

    public void addClusterEventListener(ClusterEventListener clusterEventListener) {
        if (!this.isEnabled()) {
            return;
        }
        this._clusterEventListeners.addIfAbsent(clusterEventListener);
    }

    @Override
    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        if (PropsValues.CLUSTER_EXECUTOR_DEBUG_ENABLED) {
            this.addClusterEventListener(new DebuggingClusterEventListenerImpl());
        }
    }

    @Override
    public void destroy() {
        if (!this.isEnabled()) {
            return;
        }
        this._controlChannel.close();
    }

    public FutureClusterResponses execute(ClusterRequest clusterRequest) throws SystemException {
        if (!this.isEnabled()) {
            return null;
        }
        List<Address> addresses = this.prepareAddresses(clusterRequest);
        FutureClusterResponses futureClusterResponses = new FutureClusterResponses(addresses);
        if (!clusterRequest.isFireAndForget()) {
            String uuid = clusterRequest.getUuid();
            this._executionResultMap.put(uuid, futureClusterResponses);
        }
        if (!clusterRequest.isSkipLocal() && this._shortcutLocalMethod && addresses.remove(this.getLocalControlAddress())) {
            ClusterNodeResponse clusterNodeResponse = this.runLocalMethod(clusterRequest.getMethodHandler());
            clusterNodeResponse.setMulticast(clusterRequest.isMulticast());
            clusterNodeResponse.setUuid(clusterRequest.getUuid());
            futureClusterResponses.addClusterNodeResponse(clusterNodeResponse);
        }
        if (clusterRequest.isMulticast()) {
            this.sendMulticastRequest(clusterRequest);
        } else {
            this.sendUnicastRequest(clusterRequest, addresses);
        }
        return futureClusterResponses;
    }

    public List<ClusterEventListener> getClusterEventListeners() {
        if (!this.isEnabled()) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(this._clusterEventListeners);
    }

    public List<ClusterNode> getClusterNodes() {
        if (!this.isEnabled()) {
            return Collections.EMPTY_LIST;
        }
        return new ArrayList<ClusterNode>(this._addressMap.values());
    }

    public ClusterNode getLocalClusterNode() throws SystemException {
        if (!this.isEnabled()) {
            return null;
        }
        ClusterNode clusterNode = this._addressMap.get(this.getLocalControlAddress());
        if (clusterNode == null) {
            this._localClusterNodeId = PortalUUIDUtil.generate();
            clusterNode = new ClusterNode(this._localClusterNodeId);
            clusterNode.setPort(PortalUtil.getPortalPort());
            try {
                InetAddress inetAddress = this.bindInetAddress;
                if (inetAddress == null) {
                    inetAddress = InetAddressUtil.getLocalInetAddress();
                }
                clusterNode.setInetAddress(inetAddress);
                clusterNode.setHostName(inetAddress.getHostName());
            }
            catch (Exception e) {
                throw new SystemException("Unable to determine local network address", (Throwable)e);
            }
        }
        return clusterNode;
    }

    public void initialize() {
        if (!this.isEnabled()) {
            return;
        }
        try {
            PortalUtil.addPortalPortEventListener((PortalPortEventListener)this);
            ClusterNode clusterNode = this.getLocalClusterNode();
            ClusterRequest clusterRequest = ClusterRequest.createClusterRequest((ClusterMessageType)ClusterMessageType.NOTIFY, (ClusterNode)clusterNode);
            this._controlChannel.send(null, null, (Serializable)clusterRequest);
        }
        catch (ChannelException ce) {
            _log.error((Object)"Unable to send multicast message ", (Throwable)ce);
        }
        catch (SystemException se) {
            _log.error((Object)"Unable to determine local network address", (Throwable)se);
        }
    }

    public boolean isClusterNodeAlive(String clusterNodeId) {
        if (!this.isEnabled()) {
            return false;
        }
        return this._clusterNodeIdMap.containsKey(clusterNodeId);
    }

    @Override
    public boolean isEnabled() {
        return PropsValues.CLUSTER_LINK_ENABLED;
    }

    public void portalPortConfigured(int port) {
        block3: {
            if (!this.isEnabled()) {
                return;
            }
            try {
                ClusterNode clusterNode = this.getLocalClusterNode();
                clusterNode.setPort(port);
                ClusterRequest clusterRequest = ClusterRequest.createClusterRequest((ClusterMessageType)ClusterMessageType.UPDATE, (ClusterNode)clusterNode);
                this._controlChannel.send(null, null, (Serializable)clusterRequest);
            }
            catch (Exception e) {
                if (!_log.isErrorEnabled()) break block3;
                _log.error((Object)"Unable to determine configure node port", (Throwable)e);
            }
        }
    }

    public void removeClusterEventListener(ClusterEventListener clusterEventListener) {
        if (!this.isEnabled()) {
            return;
        }
        this._clusterEventListeners.remove(clusterEventListener);
    }

    public void setClusterEventListeners(List<ClusterEventListener> clusterEventListeners) {
        if (!this.isEnabled()) {
            return;
        }
        this._clusterEventListeners.addAllAbsent(clusterEventListeners);
    }

    public void setShortcutLocalMethod(boolean shortcutLocalMethod) {
        if (!this.isEnabled()) {
            return;
        }
        this._shortcutLocalMethod = shortcutLocalMethod;
    }

    protected void fireClusterEvent(ClusterEvent clusterEvent) {
        for (ClusterEventListener listener : this._clusterEventListeners) {
            listener.processClusterEvent(clusterEvent);
        }
    }

    protected JChannel getControlChannel() {
        return this._controlChannel;
    }

    protected FutureClusterResponses getExecutionResults(String uuid) {
        return this._executionResultMap.get(uuid);
    }

    protected Address getLocalControlAddress() {
        return new AddressImpl(this._controlChannel.getLocalAddress());
    }

    @Override
    protected void initChannels() {
        Properties controlProperties = PropsUtil.getProperties((String)"cluster.link.channel.properties.control", (boolean)false);
        String controlProperty = controlProperties.getProperty("cluster.link.channel.properties.control");
        ClusterRequestReceiver clusterInvokeReceiver = new ClusterRequestReceiver(this);
        try {
            this._controlChannel = this.createJChannel(controlProperty, clusterInvokeReceiver, _DEFAULT_CLUSTER_NAME);
        }
        catch (ChannelException ce) {
            _log.error((Object)ce, (Throwable)ce);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    protected boolean isShortcutLocalMethod() {
        return this._shortcutLocalMethod;
    }

    protected void memberJoined(Address joinAddress, ClusterNode clusterNode) {
        this._addressMap.put(joinAddress, clusterNode);
        Address previousAddress = this._clusterNodeIdMap.put(clusterNode.getClusterNodeId(), joinAddress);
        if (previousAddress == null && !this.getLocalControlAddress().equals(joinAddress)) {
            ClusterEvent clusterEvent = ClusterEvent.join((ClusterNode[])new ClusterNode[]{clusterNode});
            this.fireClusterEvent(clusterEvent);
        }
    }

    protected void memberRemoved(List<Address> departAddresses) {
        ArrayList<ClusterNode> departingClusterNodes = new ArrayList<ClusterNode>();
        for (Address departAddress : departAddresses) {
            ClusterNode departingClusterNode = this._addressMap.remove(departAddress);
            if (departingClusterNode == null) continue;
            departingClusterNodes.add(departingClusterNode);
            this._clusterNodeIdMap.remove(departingClusterNode.getClusterNodeId());
        }
        if (departingClusterNodes.isEmpty()) {
            return;
        }
        ClusterEvent clusterEvent = ClusterEvent.depart(departingClusterNodes);
        this.fireClusterEvent(clusterEvent);
    }

    protected List<Address> prepareAddresses(ClusterRequest clusterRequest) {
        boolean isMulticast = clusterRequest.isMulticast();
        List<Address> addresses = null;
        if (isMulticast) {
            addresses = this.getAddresses(this._controlChannel);
        } else {
            Collection clusterNodeIds = clusterRequest.getTargetClusterNodeIds();
            addresses = new ArrayList<Address>(clusterNodeIds.size());
            for (String clusterNodeId : clusterNodeIds) {
                Address address = this._clusterNodeIdMap.get(clusterNodeId);
                addresses.add(address);
            }
        }
        return addresses;
    }

    protected ClusterNodeResponse runLocalMethod(MethodHandler methodHandler) throws SystemException {
        ClusterNodeResponse clusterNodeResponse = new ClusterNodeResponse();
        ClusterNode localClusterNode = this.getLocalClusterNode();
        clusterNodeResponse.setClusterNode(localClusterNode);
        clusterNodeResponse.setClusterMessageType(ClusterMessageType.EXECUTE);
        if (methodHandler == null) {
            clusterNodeResponse.setException((Exception)new ClusterException("Payload is not of type " + MethodHandler.class.getName()));
            return clusterNodeResponse;
        }
        try {
            Object returnValue = methodHandler.invoke(true);
            if (returnValue instanceof Serializable) {
                clusterNodeResponse.setResult(returnValue);
            } else if (returnValue != null) {
                clusterNodeResponse.setException((Exception)new ClusterException("Return value is not serializable"));
            }
        }
        catch (Exception e) {
            clusterNodeResponse.setException(e);
        }
        return clusterNodeResponse;
    }

    protected void sendMulticastRequest(ClusterRequest clusterRequest) throws SystemException {
        try {
            this._controlChannel.send(null, null, (Serializable)clusterRequest);
        }
        catch (ChannelException ce) {
            _log.error((Object)("Unable to send multicast message " + clusterRequest), (Throwable)ce);
            throw new SystemException("Unable to send multicast request", (Throwable)ce);
        }
    }

    protected void sendUnicastRequest(ClusterRequest clusterRequest, List<Address> addresses) throws SystemException {
        for (Address address : addresses) {
            org.jgroups.Address jGroupsAddress = (org.jgroups.Address)address.getRealAddress();
            try {
                this._controlChannel.send(jGroupsAddress, null, (Serializable)clusterRequest);
            }
            catch (ChannelException ce) {
                _log.error((Object)("Unable to send unicast message " + clusterRequest), (Throwable)ce);
                throw new SystemException("Unable to send unicast request", (Throwable)ce);
            }
        }
    }
}

