/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.memcached;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.MemcachedClientIF;
import org.apache.commons.pool.PoolableObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemcachedClientPoolableObjectFactory
implements PoolableObjectFactory {
    private static final int _DEFAULT_MEMCACHED_PORT = 11211;
    private ConnectionFactory _connectionFactory;
    private List<InetSocketAddress> _inetSocketAddresses = new ArrayList<InetSocketAddress>();

    public void activateObject(Object obj) throws Exception {
    }

    public void destroyObject(Object obj) {
        MemcachedClientIF memcachedClient = (MemcachedClientIF)obj;
        memcachedClient.shutdown();
    }

    public Object makeObject() throws Exception {
        return new MemcachedClient(this._connectionFactory, this._inetSocketAddresses);
    }

    public void passivateObject(Object obj) throws Exception {
    }

    public void setAddresses(List<String> addresses) {
        for (String address : addresses) {
            String[] hostAndPort = StringUtil.split((String)address, (String)":");
            String hostName = hostAndPort[0];
            int port = 11211;
            if (hostAndPort.length == 2) {
                port = GetterUtil.getInteger((String)hostAndPort[1]);
            }
            InetSocketAddress inetSocketAddress = new InetSocketAddress(hostName, port);
            this._inetSocketAddresses.add(inetSocketAddress);
        }
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this._connectionFactory = connectionFactory;
    }

    public boolean validateObject(Object obj) {
        return true;
    }
}

