/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.documentlibrary.util;

import com.liferay.documentlibrary.util.Hook;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.service.ServiceContext;
import java.io.File;
import java.io.InputStream;
import java.util.Date;

public class SafeFileNameHookWrapper
implements Hook {
    private Hook _hook;

    public SafeFileNameHookWrapper(Hook hook) {
        this._hook = hook;
    }

    public void addDirectory(long companyId, long repositoryId, String dirName) throws PortalException, SystemException {
        String safeDirName = FileUtil.encodeSafeFileName((String)dirName);
        if (!safeDirName.equals(dirName)) {
            try {
                this._hook.move(dirName, safeDirName);
            }
            catch (Exception exception) {}
        }
        this._hook.addDirectory(companyId, repositoryId, safeDirName);
    }

    public void addFile(long companyId, String portletId, long groupId, long repositoryId, String fileName, long fileEntryId, String properties, Date modifiedDate, ServiceContext serviceContext, byte[] bytes) throws PortalException, SystemException {
        String safeFileName = FileUtil.encodeSafeFileName((String)fileName);
        this.renameUnsafeFile(companyId, portletId, groupId, repositoryId, fileName, safeFileName);
        this._hook.addFile(companyId, portletId, groupId, repositoryId, safeFileName, fileEntryId, properties, modifiedDate, serviceContext, bytes);
    }

    public void addFile(long companyId, String portletId, long groupId, long repositoryId, String fileName, long fileEntryId, String properties, Date modifiedDate, ServiceContext serviceContext, File file) throws PortalException, SystemException {
        String safeFileName = FileUtil.encodeSafeFileName((String)fileName);
        this.renameUnsafeFile(companyId, portletId, groupId, repositoryId, fileName, safeFileName);
        this._hook.addFile(companyId, portletId, groupId, repositoryId, safeFileName, fileEntryId, properties, modifiedDate, serviceContext, file);
    }

    public void addFile(long companyId, String portletId, long groupId, long repositoryId, String fileName, long fileEntryId, String properties, Date modifiedDate, ServiceContext serviceContext, InputStream is) throws PortalException, SystemException {
        String safeFileName = FileUtil.encodeSafeFileName((String)fileName);
        this.renameUnsafeFile(companyId, portletId, groupId, repositoryId, fileName, safeFileName);
        this._hook.addFile(companyId, portletId, groupId, repositoryId, safeFileName, fileEntryId, properties, modifiedDate, serviceContext, is);
    }

    public void checkRoot(long companyId) throws SystemException {
        this._hook.checkRoot(companyId);
    }

    public void deleteDirectory(long companyId, String portletId, long repositoryId, String dirName) throws PortalException, SystemException {
        String safeDirName = FileUtil.encodeSafeFileName((String)dirName);
        if (!safeDirName.equals(dirName)) {
            try {
                this._hook.deleteDirectory(companyId, portletId, repositoryId, dirName);
                return;
            }
            catch (Exception exception) {}
        }
        this._hook.deleteDirectory(companyId, portletId, repositoryId, safeDirName);
    }

    public void deleteFile(long companyId, String portletId, long repositoryId, String fileName) throws PortalException, SystemException {
        String safeFileName = FileUtil.encodeSafeFileName((String)fileName);
        if (!safeFileName.equals(fileName) && this._hook.hasFile(companyId, repositoryId, fileName, "1.0")) {
            this._hook.deleteFile(companyId, portletId, repositoryId, fileName);
            return;
        }
        this._hook.deleteFile(companyId, portletId, repositoryId, safeFileName);
    }

    public void deleteFile(long companyId, String portletId, long repositoryId, String fileName, String versionNumber) throws PortalException, SystemException {
        String safeFileName = FileUtil.encodeSafeFileName((String)fileName);
        if (!safeFileName.equals(fileName) && this._hook.hasFile(companyId, repositoryId, fileName, versionNumber)) {
            this._hook.deleteFile(companyId, portletId, repositoryId, fileName, versionNumber);
            return;
        }
        this._hook.deleteFile(companyId, portletId, repositoryId, safeFileName, versionNumber);
    }

    public byte[] getFile(long companyId, long repositoryId, String fileName) throws PortalException, SystemException {
        String safeFileName = FileUtil.encodeSafeFileName((String)fileName);
        if (!safeFileName.equals(fileName) && this._hook.hasFile(companyId, repositoryId, fileName, "1.0")) {
            return this._hook.getFile(companyId, repositoryId, fileName);
        }
        return this._hook.getFile(companyId, repositoryId, safeFileName);
    }

    public byte[] getFile(long companyId, long repositoryId, String fileName, String versionNumber) throws PortalException, SystemException {
        String safeFileName = FileUtil.encodeSafeFileName((String)fileName);
        if (!safeFileName.equals(fileName) && this._hook.hasFile(companyId, repositoryId, fileName, versionNumber)) {
            return this._hook.getFile(companyId, repositoryId, fileName, versionNumber);
        }
        return this._hook.getFile(companyId, repositoryId, safeFileName, versionNumber);
    }

    public InputStream getFileAsStream(long companyId, long repositoryId, String fileName) throws PortalException, SystemException {
        String safeFileName = FileUtil.encodeSafeFileName((String)fileName);
        if (!safeFileName.equals(fileName) && this._hook.hasFile(companyId, repositoryId, fileName, "1.0")) {
            return this._hook.getFileAsStream(companyId, repositoryId, fileName);
        }
        return this._hook.getFileAsStream(companyId, repositoryId, safeFileName);
    }

    public InputStream getFileAsStream(long companyId, long repositoryId, String fileName, String versionNumber) throws PortalException, SystemException {
        String safeFileName = FileUtil.encodeSafeFileName((String)fileName);
        if (!safeFileName.equals(fileName) && this._hook.hasFile(companyId, repositoryId, fileName, versionNumber)) {
            return this._hook.getFileAsStream(companyId, repositoryId, fileName, versionNumber);
        }
        return this._hook.getFileAsStream(companyId, repositoryId, safeFileName, versionNumber);
    }

    public String[] getFileNames(long companyId, long repositoryId, String dirName) throws PortalException, SystemException {
        String safeDirName = FileUtil.encodeSafeFileName((String)dirName);
        if (!safeDirName.equals(dirName)) {
            try {
                this._hook.move(dirName, safeDirName);
            }
            catch (Exception exception) {}
        }
        String[] fileNames = this._hook.getFileNames(companyId, repositoryId, safeDirName);
        String[] decodedFileNames = new String[fileNames.length];
        int i = 0;
        while (i < fileNames.length) {
            decodedFileNames[i] = FileUtil.decodeSafeFileName((String)fileNames[i]);
            ++i;
        }
        return decodedFileNames;
    }

    public long getFileSize(long companyId, long repositoryId, String fileName) throws PortalException, SystemException {
        String safeFileName = FileUtil.encodeSafeFileName((String)fileName);
        if (!safeFileName.equals(fileName) && this._hook.hasFile(companyId, repositoryId, fileName, "1.0")) {
            return this._hook.getFileSize(companyId, repositoryId, fileName);
        }
        return this._hook.getFileSize(companyId, repositoryId, safeFileName);
    }

    public boolean hasFile(long companyId, long repositoryId, String fileName, String versionNumber) throws PortalException, SystemException {
        String safeFileName = FileUtil.encodeSafeFileName((String)fileName);
        if (!safeFileName.equals(fileName) && this._hook.hasFile(companyId, repositoryId, fileName, versionNumber)) {
            return true;
        }
        return this._hook.hasFile(companyId, repositoryId, safeFileName, versionNumber);
    }

    public void move(String srcDir, String destDir) throws SystemException {
        this._hook.move(srcDir, destDir);
    }

    public void reindex(String[] ids) throws SearchException {
        this._hook.reindex(ids);
    }

    public void updateFile(long companyId, String portletId, long groupId, long repositoryId, long newRepositoryId, String fileName, long fileEntryId) throws PortalException, SystemException {
        String safeFileName = FileUtil.encodeSafeFileName((String)fileName);
        this.renameUnsafeFile(companyId, portletId, groupId, repositoryId, fileName, safeFileName);
        this._hook.updateFile(companyId, portletId, groupId, repositoryId, newRepositoryId, safeFileName, fileEntryId);
    }

    public void updateFile(long companyId, String portletId, long groupId, long repositoryId, String fileName, String newFileName, boolean reindex) throws PortalException, SystemException {
        String safeFileName = FileUtil.encodeSafeFileName((String)fileName);
        String safeNewFileName = FileUtil.encodeSafeFileName((String)newFileName);
        if (!safeFileName.equals(fileName) && this._hook.hasFile(companyId, repositoryId, fileName, "1.0")) {
            safeFileName = fileName;
        }
        this._hook.updateFile(companyId, portletId, groupId, repositoryId, safeFileName, safeNewFileName, reindex);
    }

    public void updateFile(long companyId, String portletId, long groupId, long repositoryId, String fileName, String versionNumber, String sourceFileName, long fileEntryId, String properties, Date modifiedDate, ServiceContext serviceContext, byte[] bytes) throws PortalException, SystemException {
        String safeFileName = FileUtil.encodeSafeFileName((String)fileName);
        String safeSourceFileName = FileUtil.encodeSafeFileName((String)sourceFileName);
        this.renameUnsafeFile(companyId, portletId, groupId, repositoryId, fileName, safeFileName);
        this.renameUnsafeFile(companyId, portletId, groupId, repositoryId, sourceFileName, safeSourceFileName);
        this._hook.updateFile(companyId, portletId, groupId, repositoryId, safeFileName, versionNumber, safeSourceFileName, fileEntryId, properties, modifiedDate, serviceContext, bytes);
    }

    public void updateFile(long companyId, String portletId, long groupId, long repositoryId, String fileName, String versionNumber, String sourceFileName, long fileEntryId, String properties, Date modifiedDate, ServiceContext serviceContext, File file) throws PortalException, SystemException {
        String safeFileName = FileUtil.encodeSafeFileName((String)fileName);
        String safeSourceFileName = FileUtil.encodeSafeFileName((String)sourceFileName);
        this.renameUnsafeFile(companyId, portletId, groupId, repositoryId, fileName, safeFileName);
        this.renameUnsafeFile(companyId, portletId, groupId, repositoryId, sourceFileName, safeSourceFileName);
        this._hook.updateFile(companyId, portletId, groupId, repositoryId, safeFileName, versionNumber, safeSourceFileName, fileEntryId, properties, modifiedDate, serviceContext, file);
    }

    public void updateFile(long companyId, String portletId, long groupId, long repositoryId, String fileName, String versionNumber, String sourceFileName, long fileEntryId, String properties, Date modifiedDate, ServiceContext serviceContext, InputStream is) throws PortalException, SystemException {
        String safeFileName = FileUtil.encodeSafeFileName((String)fileName);
        String safeSourceFileName = FileUtil.encodeSafeFileName((String)sourceFileName);
        this.renameUnsafeFile(companyId, portletId, groupId, repositoryId, fileName, safeFileName);
        this.renameUnsafeFile(companyId, portletId, groupId, repositoryId, sourceFileName, safeSourceFileName);
        this._hook.updateFile(companyId, portletId, groupId, repositoryId, safeFileName, versionNumber, safeSourceFileName, fileEntryId, properties, modifiedDate, serviceContext, is);
    }

    protected void renameUnsafeFile(long companyId, String portletId, long groupId, long repositoryId, String fileName, String safeFileName) throws PortalException, SystemException {
        if (!safeFileName.equals(fileName) && this._hook.hasFile(companyId, repositoryId, fileName, "1.0")) {
            this._hook.updateFile(companyId, portletId, groupId, repositoryId, fileName, safeFileName, true);
        }
    }
}

