/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.documentlibrary.util;

import com.liferay.documentlibrary.model.FileModel;
import com.liferay.documentlibrary.util.Hook;
import com.liferay.documentlibrary.util.HookFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.asset.service.AssetCategoryLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetTagLocalServiceUtil;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryException;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.impl.DLFileEntryImpl;
import com.liferay.portlet.documentlibrary.service.DLFileEntryLocalServiceUtil;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeFactoryUtil;
import com.liferay.portlet.expando.util.ExpandoBridgeIndexerUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import javax.portlet.PortletURL;

public class DLIndexer
extends BaseIndexer {
    public static final String[] CLASS_NAMES = new String[]{FileModel.class.getName()};
    private static Log _log = LogFactoryUtil.getLog(DLIndexer.class);

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public Summary getSummary(Document document, String snippet, PortletURL portletURL) {
        return null;
    }

    protected void doDelete(Object obj) throws Exception {
        FileModel fileModel = (FileModel)obj;
        DocumentImpl document = new DocumentImpl();
        document.addUID(fileModel.getPortletId(), fileModel.getRepositoryId(), fileModel.getFileName());
        SearchEngineUtil.deleteDocument((long)fileModel.getCompanyId(), (String)document.get("uid"));
    }

    protected Document doGetDocument(Object obj) throws Exception {
        FileModel fileModel = (FileModel)obj;
        long companyId = fileModel.getCompanyId();
        String portletId = fileModel.getPortletId();
        long groupId = this.getParentGroupId(fileModel.getGroupId());
        long scopeGroupId = fileModel.getGroupId();
        long userId = fileModel.getUserId();
        long folderId = DLFileEntryImpl.getFolderId(groupId, fileModel.getRepositoryId());
        long repositoryId = fileModel.getRepositoryId();
        String fileName = fileModel.getFileName();
        long fileEntryId = fileModel.getFileEntryId();
        String properties = fileModel.getProperties();
        Date modifiedDate = fileModel.getModifiedDate();
        long[] assetCategoryIds = fileModel.getAssetCategoryIds();
        String[] assetTagNames = fileModel.getAssetTagNames();
        DLFileEntry fileEntry = null;
        try {
            fileEntry = fileEntryId > 0L ? DLFileEntryLocalServiceUtil.getFileEntry((long)fileEntryId) : DLFileEntryLocalServiceUtil.getFileEntry((long)groupId, (long)folderId, (String)fileName);
        }
        catch (NoSuchFileEntryException noSuchFileEntryException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Not indexing document " + companyId + " " + portletId + " " + scopeGroupId + " " + repositoryId + " " + fileName + " " + fileEntryId));
            }
            return null;
        }
        if (userId == 0L) {
            userId = fileEntry.getUserId();
        }
        if (properties == null) {
            properties = fileEntry.getLuceneProperties();
        }
        if (modifiedDate == null) {
            modifiedDate = fileEntry.getModifiedDate();
        }
        if (assetCategoryIds == null) {
            assetCategoryIds = AssetCategoryLocalServiceUtil.getCategoryIds((String)DLFileEntry.class.getName(), (long)fileEntry.getFileEntryId());
        }
        if (assetTagNames == null) {
            assetTagNames = AssetTagLocalServiceUtil.getTagNames((String)DLFileEntry.class.getName(), (long)fileEntry.getFileEntryId());
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Indexing document " + companyId + " " + portletId + " " + scopeGroupId + " " + repositoryId + " " + fileName + " " + fileEntry.getFileEntryId()));
        }
        boolean indexContent = true;
        InputStream is = null;
        try {
            long size;
            Hook hook = HookFactory.getInstance();
            if (PropsValues.DL_FILE_INDEXING_MAX_SIZE == 0L) {
                indexContent = false;
            } else if (PropsValues.DL_FILE_INDEXING_MAX_SIZE != -1L && (size = hook.getFileSize(companyId, repositoryId, fileName)) > PropsValues.DL_FILE_INDEXING_MAX_SIZE) {
                indexContent = false;
            }
            if (indexContent) {
                is = hook.getFileAsStream(companyId, repositoryId, fileName);
            }
        }
        catch (Exception exception) {}
        if (indexContent && is == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Document " + companyId + " " + portletId + " " + scopeGroupId + " " + repositoryId + " " + fileName + " " + fileEntry.getFileEntryId() + " does not " + "have any content"));
            }
            return null;
        }
        DocumentImpl document = new DocumentImpl();
        document.addUID(portletId, repositoryId, fileName);
        document.addModifiedDate(modifiedDate);
        document.addKeyword("companyId", companyId);
        document.addKeyword("portletId", portletId);
        document.addKeyword("groupId", groupId);
        document.addKeyword("scopeGroupId", scopeGroupId);
        document.addKeyword("userId", userId);
        if (indexContent) {
            try {
                document.addFile("content", is, fileEntry.getTitle());
            }
            catch (IOException iOException) {
                throw new SearchException("Cannot extract text from file" + companyId + " " + portletId + " " + scopeGroupId + " " + repositoryId + " " + fileName);
            }
        }
        document.addText("properties", properties);
        document.addKeyword("assetCategoryIds", assetCategoryIds);
        document.addKeyword("assetTagNames", assetTagNames);
        document.addKeyword("folderId", folderId);
        document.addKeyword("repositoryId", repositoryId);
        document.addKeyword("path", fileName);
        document.addKeyword("entryClassName", DLFileEntry.class.getName());
        document.addKeyword("entryClassPK", fileEntry.getFileEntryId());
        ExpandoBridge expandoBridge = ExpandoBridgeFactoryUtil.getExpandoBridge((long)companyId, (String)DLFileEntry.class.getName(), (long)fileEntry.getFileEntryId());
        ExpandoBridgeIndexerUtil.addAttributes((Document)document, (ExpandoBridge)expandoBridge);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Document " + companyId + " " + portletId + " " + scopeGroupId + " " + repositoryId + " " + fileName + " " + fileEntry.getFileEntryId() + " indexed successfully"));
        }
        return document;
    }

    protected void doReindex(Object obj) throws Exception {
        FileModel fileModel = (FileModel)obj;
        Document document = this.getDocument(fileModel);
        if (document != null) {
            SearchEngineUtil.updateDocument((long)fileModel.getCompanyId(), (Document)document);
        }
    }

    protected void doReindex(String className, long classPK) throws Exception {
    }

    protected void doReindex(String[] ids) throws Exception {
        Hook hook = HookFactory.getInstance();
        hook.reindex(ids);
    }

    protected String getPortletId(SearchContext searchContext) {
        return (String)((Object)searchContext.getAttribute("portletId"));
    }
}

