/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.util;

import com.netflix.astyanax.util.RecordReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.utils.Pair;
import org.apache.commons.csv.CSVParser;

public class CsvRecordReader
implements RecordReader {
    private CSVParser parser;
    private boolean hasHeaderLine = true;
    private String[] names = null;

    public CsvRecordReader(Reader reader) {
        this.parser = new CSVParser(reader);
    }

    public CsvRecordReader setHasHeaderLine(boolean flag) {
        this.hasHeaderLine = flag;
        return this;
    }

    public CsvRecordReader setNames(String ... names) {
        this.names = names;
        return this;
    }

    @Override
    public void start() throws IOException {
        if (this.hasHeaderLine) {
            this.names = this.parser.getLine();
        }
    }

    @Override
    public void shutdown() {
    }

    @Override
    public List<Pair<String, String>> next() throws IOException {
        String[] row = this.parser.getLine();
        if (null == row) {
            return null;
        }
        ArrayList<Pair<String, String>> columns = new ArrayList<Pair<String, String>>();
        for (int i = 0; i < row.length && i < this.names.length; ++i) {
            columns.add((Pair<String, String>)new Pair((Object)this.names[i], (Object)row[i]));
        }
        return columns;
    }
}

