/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.serializers;

import com.netflix.astyanax.serializers.AbstractSerializer;
import com.netflix.astyanax.serializers.ComparatorType;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.apache.cassandra.db.marshal.IntegerType;

public final class BigIntegerSerializer
extends AbstractSerializer<BigInteger> {
    private static final BigIntegerSerializer INSTANCE = new BigIntegerSerializer();

    public static BigIntegerSerializer get() {
        return INSTANCE;
    }

    @Override
    public BigInteger fromByteBuffer(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return null;
        }
        int length = byteBuffer.remaining();
        byte[] bytes = new byte[length];
        byteBuffer.duplicate().get(bytes);
        return new BigInteger(bytes);
    }

    @Override
    public ByteBuffer toByteBuffer(BigInteger obj) {
        if (obj == null) {
            return null;
        }
        return ByteBuffer.wrap(obj.toByteArray());
    }

    @Override
    public ComparatorType getComparatorType() {
        return ComparatorType.INTEGERTYPE;
    }

    @Override
    public ByteBuffer fromString(String str) {
        return IntegerType.instance.fromString(str);
    }

    @Override
    public String getString(ByteBuffer byteBuffer) {
        return IntegerType.instance.getString(byteBuffer);
    }

    @Override
    public ByteBuffer getNext(ByteBuffer byteBuffer) {
        BigInteger bigint = this.fromByteBuffer(byteBuffer.duplicate());
        bigint = bigint.add(new BigInteger("1"));
        return this.toByteBuffer(bigint);
    }
}

