/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.impl;

import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.netflix.astyanax.connectionpool.Host;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;

public class FilteringHostSupplier
implements Supplier<List<Host>> {
    private final Supplier<List<Host>> sourceSupplier;
    private final Supplier<List<Host>> filterSupplier;

    public FilteringHostSupplier(Supplier<List<Host>> filterSupplier, Supplier<List<Host>> sourceSupplier) {
        this.sourceSupplier = sourceSupplier;
        this.filterSupplier = filterSupplier;
    }

    public List<Host> get() {
        List filterList = Lists.newArrayList();
        List sourceList = Lists.newArrayList();
        try {
            sourceList = (List)this.sourceSupplier.get();
            filterList = (List)this.filterSupplier.get();
        }
        catch (RuntimeException e) {
            if (sourceList != null) {
                return sourceList;
            }
            throw e;
        }
        if (filterList.isEmpty()) {
            return sourceList;
        }
        final HashMap lookup = Maps.newHashMap();
        for (Host host : filterList) {
            lookup.put(host.getIpAddress(), host);
            for (String addr : host.getAlternateIpAddresses()) {
                lookup.put(addr, host);
            }
        }
        ArrayList result = Lists.newArrayList((Iterable)Collections2.filter((Collection)sourceList, (Predicate)new Predicate<Host>(){

            public boolean apply(@Nullable Host host) {
                Host foundHost = (Host)lookup.get(host.getHostName());
                if (foundHost == null) {
                    String addr;
                    Iterator<String> i$ = host.getAlternateIpAddresses().iterator();
                    while (i$.hasNext() && (foundHost = (Host)lookup.get(addr = i$.next())) == null) {
                    }
                }
                if (foundHost != null) {
                    host.setTokenRanges(foundHost.getTokenRanges());
                    return true;
                }
                return false;
            }
        }));
        if (result.isEmpty()) {
            return sourceList;
        }
        return result;
    }
}

