/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.entitystore;

import com.google.common.base.Preconditions;
import com.netflix.astyanax.ColumnListMutation;
import com.netflix.astyanax.Keyspace;
import com.netflix.astyanax.MutationBatch;
import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.entitystore.EntityAnnotation;
import com.netflix.astyanax.entitystore.EntityManager;
import com.netflix.astyanax.entitystore.TTL;
import com.netflix.astyanax.model.Column;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.ColumnList;
import com.netflix.astyanax.model.ConsistencyLevel;
import com.netflix.astyanax.query.ColumnFamilyQuery;
import com.netflix.astyanax.query.RowQuery;
import com.netflix.astyanax.retry.RetryPolicy;
import java.lang.reflect.Field;
import java.util.Map;
import javax.persistence.PersistenceException;

public class DefaultEntityManager<T, K>
implements EntityManager<T, K> {
    private final Class<T> clazz;
    private final EntityAnnotation entityAnnotation;
    private final Keyspace keyspace;
    private final ColumnFamily<K, String> columnFamily;
    private final ConsistencyLevel readConsitency;
    private final ConsistencyLevel writeConsistency;
    private final Integer ttl;
    private final RetryPolicy retryPolicy;

    private DefaultEntityManager(Builder<T, K> builder) {
        this.clazz = ((Builder)builder).clazz;
        this.entityAnnotation = ((Builder)builder).entityAnnotation;
        this.keyspace = ((Builder)builder).keyspace;
        this.columnFamily = ((Builder)builder).columnFamily;
        this.readConsitency = ((Builder)builder).readConsitency;
        this.writeConsistency = ((Builder)builder).writeConsistency;
        this.ttl = ((Builder)builder).ttl;
        this.retryPolicy = ((Builder)builder).retryPolicy;
    }

    private Integer getTTL(Field field) {
        TTL ttlAnnotation = field.getAnnotation(TTL.class);
        if (ttlAnnotation != null) {
            return ttlAnnotation.value();
        }
        return this.ttl;
    }

    @Override
    public void put(T entity) throws PersistenceException {
        try {
            MutationBatch mb = this.keyspace.prepareMutationBatch();
            if (this.writeConsistency != null) {
                mb.withConsistencyLevel(this.writeConsistency);
            }
            if (this.retryPolicy != null) {
                mb.withRetryPolicy(this.retryPolicy);
            }
            Field idField = this.entityAnnotation.getId();
            Object rowKey = idField.get(entity);
            ColumnListMutation<String> clm = mb.withRow(this.columnFamily, rowKey);
            Map<String, EntityAnnotation.ColumnMapper> columnMappers = this.entityAnnotation.getColumnMappers();
            for (Map.Entry<String, EntityAnnotation.ColumnMapper> entry : columnMappers.entrySet()) {
                String columnName = entry.getKey();
                Field field = entry.getValue().getField();
                Object value = field.get(entity);
                Serializer<?> valueSerializer = entry.getValue().getSerializer();
                Integer ttl = this.getTTL(field);
                clm.putColumn(columnName, value, valueSerializer, ttl);
            }
            mb.execute();
        }
        catch (Exception e) {
            throw new PersistenceException("failed to write entity", (Throwable)e);
        }
    }

    @Override
    public T get(K id) throws PersistenceException {
        try {
            ColumnFamilyQuery<K, String> cfq = this.keyspace.prepareQuery(this.columnFamily);
            if (this.readConsitency != null) {
                cfq.setConsistencyLevel(this.readConsitency);
            }
            if (this.retryPolicy != null) {
                cfq.withRetryPolicy(this.retryPolicy);
            }
            RowQuery<K, String> rq = cfq.getKey(id);
            ColumnList cl = (ColumnList)rq.execute().getResult();
            T entity = this.clazz.newInstance();
            Field idField = this.entityAnnotation.getId();
            idField.set(entity, id);
            Map<String, EntityAnnotation.ColumnMapper> columnMappers = this.entityAnnotation.getColumnMappers();
            for (Column c : cl) {
                EntityAnnotation.ColumnMapper columnMapper = columnMappers.get(c.getName());
                Serializer<?> valueSerializer = columnMapper.getSerializer();
                Object fieldValue = c.getValue(valueSerializer);
                Field field = columnMapper.getField();
                field.set(entity, fieldValue);
            }
            return entity;
        }
        catch (Exception e) {
            throw new PersistenceException("failed to write entity", (Throwable)e);
        }
    }

    @Override
    public void delete(K id) throws PersistenceException {
        try {
            MutationBatch mb = this.keyspace.prepareMutationBatch();
            ColumnListMutation<String> clm = mb.withRow(this.columnFamily, id);
            clm.delete();
            if (this.writeConsistency != null) {
                mb.withConsistencyLevel(this.writeConsistency);
            }
            if (this.retryPolicy != null) {
                mb.withRetryPolicy(this.retryPolicy);
            }
            mb.execute();
        }
        catch (Exception e) {
            throw new PersistenceException("failed to write entity", (Throwable)e);
        }
    }

    public static class Builder<T, K> {
        private Class<T> clazz = null;
        private EntityAnnotation entityAnnotation = null;
        private Keyspace keyspace = null;
        private ColumnFamily<K, String> columnFamily = null;
        private ConsistencyLevel readConsitency = null;
        private ConsistencyLevel writeConsistency = null;
        private Integer ttl = null;
        private RetryPolicy retryPolicy = null;

        public Builder<T, K> withEntityType(Class<T> clazz) {
            Preconditions.checkNotNull(clazz);
            this.clazz = clazz;
            this.entityAnnotation = new EntityAnnotation(clazz);
            return this;
        }

        public Builder<T, K> withKeyspace(Keyspace keyspace) {
            Preconditions.checkNotNull((Object)keyspace);
            this.keyspace = keyspace;
            return this;
        }

        public Builder<T, K> withColumnFamily(ColumnFamily<K, String> columnFamily) {
            Preconditions.checkNotNull(columnFamily);
            this.columnFamily = columnFamily;
            return this;
        }

        public Builder<T, K> withReadConsistency(ConsistencyLevel level) {
            Preconditions.checkNotNull((Object)((Object)level));
            this.readConsitency = level;
            return this;
        }

        public Builder<T, K> withWriteConsistency(ConsistencyLevel level) {
            Preconditions.checkNotNull((Object)((Object)level));
            this.writeConsistency = level;
            return this;
        }

        public Builder<T, K> withConsistency(ConsistencyLevel level) {
            Preconditions.checkNotNull((Object)((Object)level));
            this.readConsitency = level;
            this.writeConsistency = level;
            return this;
        }

        public Builder<T, K> withTTL(Integer ttl) {
            this.ttl = ttl;
            return this;
        }

        public Builder<T, K> withRetryPolicy(RetryPolicy policy) {
            Preconditions.checkNotNull((Object)policy);
            this.retryPolicy = policy;
            return this;
        }

        public DefaultEntityManager<T, K> build() {
            Preconditions.checkNotNull(this.clazz, (Object)"clazz is not set");
            Preconditions.checkNotNull((Object)this.keyspace, (Object)"keyspace is not set");
            Preconditions.checkNotNull(this.columnFamily, (Object)"columnFamily is not set");
            return new DefaultEntityManager(this);
        }
    }
}

