/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.connectionpool.impl;

import com.netflix.astyanax.connectionpool.Connection;
import com.netflix.astyanax.connectionpool.ConnectionPoolConfiguration;
import com.netflix.astyanax.connectionpool.ConnectionPoolMonitor;
import com.netflix.astyanax.connectionpool.HostConnectionPool;
import com.netflix.astyanax.connectionpool.Operation;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.connectionpool.exceptions.NoAvailableHostsException;
import com.netflix.astyanax.connectionpool.impl.AbstractExecuteWithFailoverImpl;
import java.util.List;

public class RoundRobinExecuteWithFailover<CL, R>
extends AbstractExecuteWithFailoverImpl<CL, R> {
    private int index;
    protected HostConnectionPool<CL> pool;
    private int retryCountdown;
    protected final List<HostConnectionPool<CL>> pools;
    protected final int size;
    protected int waitDelta;
    protected int waitMultiplier = 1;

    public RoundRobinExecuteWithFailover(ConnectionPoolConfiguration config, ConnectionPoolMonitor monitor, List<HostConnectionPool<CL>> pools, int index) throws ConnectionException {
        super(config, monitor);
        this.index = index;
        this.pools = pools;
        if (pools == null || pools.isEmpty()) {
            throw new NoAvailableHostsException("No hosts to borrow from");
        }
        this.size = pools.size();
        this.retryCountdown = Math.min(config.getMaxFailoverCount(), this.size);
        if (this.retryCountdown < 0) {
            this.retryCountdown = this.size;
        } else if (this.retryCountdown == 0) {
            this.retryCountdown = 1;
        }
        this.waitDelta = config.getMaxTimeoutWhenExhausted() / this.retryCountdown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextHostIndex() {
        try {
            int n = this.index % this.size;
            return n;
        }
        finally {
            ++this.index;
            if (this.index < 0) {
                this.index = 0;
            }
        }
    }

    @Override
    public boolean canRetry() {
        return --this.retryCountdown > 0;
    }

    @Override
    public HostConnectionPool<CL> getCurrentHostConnectionPool() {
        return this.pool;
    }

    @Override
    public Connection<CL> borrowConnection(Operation<CL, R> operation) throws ConnectionException {
        this.pool = this.pools.get(this.getNextHostIndex());
        return this.pool.borrowConnection(this.waitDelta * this.waitMultiplier);
    }
}

