/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.connectionpool.impl;

import com.google.common.base.Supplier;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.netflix.astyanax.connectionpool.ConnectionPool;
import com.netflix.astyanax.connectionpool.Host;
import com.netflix.astyanax.connectionpool.NodeDiscovery;
import com.netflix.astyanax.connectionpool.impl.NodeDiscoveryMonitorManager;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.joda.time.DateTime;

public class NodeDiscoveryImpl
implements NodeDiscovery {
    private final ConnectionPool<?> connectionPool;
    private final ScheduledExecutorService executor;
    private final int interval;
    private final String name;
    private final Supplier<List<Host>> hostSupplier;
    private final AtomicReference<DateTime> lastUpdateTime = new AtomicReference();
    private final AtomicReference<Exception> lastException = new AtomicReference();
    private final AtomicLong refreshCounter = new AtomicLong();
    private final AtomicLong errorCounter = new AtomicLong();

    public NodeDiscoveryImpl(String name, int interval, Supplier<List<Host>> hostSupplier, ConnectionPool<?> connectionPool) {
        this(name, interval, hostSupplier, connectionPool, Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).build()));
    }

    public NodeDiscoveryImpl(String name, int interval, Supplier<List<Host>> hostSupplier, ConnectionPool<?> connectionPool, ScheduledExecutorService executor) {
        this.connectionPool = connectionPool;
        this.interval = interval;
        this.hostSupplier = hostSupplier;
        this.name = name;
        this.executor = executor;
    }

    @Override
    public void start() {
        this.update();
        this.executor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setName("RingDescribeAutoDiscovery");
                NodeDiscoveryImpl.this.update();
            }
        }, this.interval, this.interval, TimeUnit.MILLISECONDS);
        NodeDiscoveryMonitorManager.getInstance().registerMonitor(this.name, this);
    }

    @Override
    public void shutdown() {
        this.executor.shutdown();
        NodeDiscoveryMonitorManager.getInstance().unregisterMonitor(this.name, this);
    }

    private void update() {
        try {
            this.connectionPool.setHosts((Collection)this.hostSupplier.get());
            this.refreshCounter.incrementAndGet();
            this.lastUpdateTime.set(new DateTime());
        }
        catch (Exception e) {
            this.errorCounter.incrementAndGet();
            this.lastException.set(e);
        }
    }

    @Override
    public DateTime getLastRefreshTime() {
        return this.lastUpdateTime.get();
    }

    @Override
    public long getRefreshCount() {
        return this.refreshCounter.get();
    }

    @Override
    public Exception getLastException() {
        return this.lastException.get();
    }

    @Override
    public long getErrorCount() {
        return this.errorCounter.get();
    }

    @Override
    public String getRawHostList() {
        try {
            return ((List)this.hostSupplier.get()).toString();
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }
}

