/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.jdbc;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.derby.iapi.jdbc.JDBCBoot;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.jdbc.InternalDriver;

public final class EmbeddedSimpleDataSource
implements DataSource {
    private String password;
    private String user;
    private String databaseName;
    private String dataSourceName;
    private String description;
    private String createDatabase;
    private String shutdownDatabase;
    private String connectionAttributes;
    private transient PrintWriter printer;
    private transient int loginTimeout;
    private transient InternalDriver driver;
    private transient String jdbcurl;

    public EmbeddedSimpleDataSource() {
        this.update();
    }

    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    public void setLoginTimeout(int n) throws SQLException {
        this.loginTimeout = n;
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.printer;
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.printer = printWriter;
    }

    public final synchronized void setDatabaseName(String string) {
        this.databaseName = string;
        this.update();
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public final void setDataSourceName(String string) {
        this.dataSourceName = string;
    }

    public final String getDataSourceName() {
        return this.dataSourceName;
    }

    public final void setDescription(String string) {
        this.description = string;
    }

    public final String getDescription() {
        return this.description;
    }

    public final void setUser(String string) {
        this.user = string;
    }

    public final String getUser() {
        return this.user;
    }

    public final void setPassword(String string) {
        this.password = string;
    }

    public final String getPassword() {
        return this.password;
    }

    public final void setCreateDatabase(String string) {
        this.createDatabase = string != null && string.toLowerCase(Locale.ENGLISH).equals("create") ? string : null;
    }

    public final String getCreateDatabase() {
        return this.createDatabase;
    }

    public final void setShutdownDatabase(String string) {
        this.shutdownDatabase = string != null && string.equalsIgnoreCase("shutdown") ? string : null;
    }

    public final String getShutdownDatabase() {
        return this.shutdownDatabase;
    }

    public final void setConnectionAttributes(String string) {
        this.connectionAttributes = string;
        this.update();
    }

    public final String getConnectionAttributes() {
        return this.connectionAttributes;
    }

    public final Connection getConnection() throws SQLException {
        return this.getConnection(this.getUser(), this.getPassword());
    }

    public final Connection getConnection(String string, String string2) throws SQLException {
        Connection connection;
        Properties properties = new Properties();
        if (string != null) {
            properties.put("user", string);
        }
        if (string2 != null) {
            properties.put("password", string2);
        }
        if (this.createDatabase != null) {
            properties.put("create", "true");
        }
        if (this.shutdownDatabase != null) {
            properties.put("shutdown", "true");
        }
        if ((connection = this.findDriver().connect(this.jdbcurl, properties, this.loginTimeout)) == null) {
            throw Util.generateCsSQLException("XCY00.S", (Object)"databaseName", this.getDatabaseName());
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InternalDriver findDriver() throws SQLException {
        String string = this.jdbcurl;
        if (this.driver == null || !this.driver.acceptsURL(string)) {
            EmbeddedSimpleDataSource embeddedSimpleDataSource = this;
            synchronized (embeddedSimpleDataSource) {
                if (this.driver == null || !this.driver.acceptsURL(string)) {
                    new JDBCBoot().boot("jdbc:derby:", new PrintWriter(System.err, true));
                    this.driver = InternalDriver.activeDriver();
                    if (this.driver == null) {
                        throw Util.generateCsSQLException("08006.C.8");
                    }
                }
            }
        }
        return this.driver;
    }

    private void update() {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append("jdbc:derby:");
        String string = this.getDatabaseName();
        if (string != null) {
            string = string.trim();
        }
        if (string == null || string.length() == 0) {
            string = " ";
        }
        stringBuffer.append(string);
        String string2 = this.getConnectionAttributes();
        if (string2 != null && (string2 = string2.trim()).length() != 0) {
            stringBuffer.append(';');
            stringBuffer.append(this.connectionAttributes);
        }
        this.jdbcurl = stringBuffer.toString();
    }
}

