/*
 * Decompiled with CFR 0.152.
 */
package lombok.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import lombok.core.AST;
import lombok.core.DiagnosticsReceiver;
import lombok.core.ImportList;
import lombok.core.LombokImmutableList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LombokNode<A extends AST<A, L, N>, L extends LombokNode<A, L, N>, N>
implements DiagnosticsReceiver {
    protected final A ast;
    protected final AST.Kind kind;
    protected final N node;
    protected LombokImmutableList<L> children;
    protected L parent;
    protected boolean isStructurallySignificant;

    protected LombokNode(A ast, N node, List<L> children, AST.Kind kind) {
        this.ast = ast;
        this.kind = kind;
        this.node = node;
        this.children = children != null ? LombokImmutableList.copyOf(children) : LombokImmutableList.of();
        for (LombokNode child : this.children) {
            child.parent = this;
            if (child.isStructurallySignificant) continue;
            child.isStructurallySignificant = this.calculateIsStructurallySignificant(node);
        }
        this.isStructurallySignificant = this.calculateIsStructurallySignificant(null);
    }

    public A getAst() {
        return this.ast;
    }

    public String toString() {
        return String.format("NODE %s (%s) %s", new Object[]{this.kind, this.node == null ? "(NULL)" : this.node.getClass(), this.node == null ? "" : this.node});
    }

    public String getPackageDeclaration() {
        return ((AST)this.ast).getPackageDeclaration();
    }

    public ImportList getImportList() {
        return ((AST)this.ast).getImportList();
    }

    protected abstract boolean calculateIsStructurallySignificant(N var1);

    public L getNodeFor(N obj) {
        return ((AST)this.ast).get(obj);
    }

    public N get() {
        return this.node;
    }

    public AST.Kind getKind() {
        return this.kind;
    }

    public abstract String getName();

    public L up() {
        L result = this.parent;
        while (result != null && !((LombokNode)result).isStructurallySignificant) {
            result = ((LombokNode)result).parent;
        }
        return result;
    }

    public Collection<L> upFromAnnotationToFields() {
        if (this.getKind() != AST.Kind.ANNOTATION) {
            return Collections.emptyList();
        }
        L field = this.up();
        if (field == null || ((LombokNode)field).getKind() != AST.Kind.FIELD) {
            return Collections.emptyList();
        }
        L type = ((LombokNode)field).up();
        if (type == null || ((LombokNode)type).getKind() != AST.Kind.TYPE) {
            return Collections.emptyList();
        }
        ArrayList<LombokNode> fields = new ArrayList<LombokNode>();
        for (LombokNode potentialField : ((LombokNode)type).down()) {
            if (potentialField.getKind() != AST.Kind.FIELD || !this.fieldContainsAnnotation(potentialField.get(), this.get())) continue;
            fields.add(potentialField);
        }
        return fields;
    }

    protected abstract boolean fieldContainsAnnotation(N var1, N var2);

    public L directUp() {
        return this.parent;
    }

    public LombokImmutableList<L> down() {
        return this.children;
    }

    public int getLatestJavaSpecSupported() {
        return ((AST)this.ast).getLatestJavaSpecSupported();
    }

    public int getSourceVersion() {
        return ((AST)this.ast).getSourceVersion();
    }

    public L top() {
        return ((AST)this.ast).top();
    }

    public String getFileName() {
        return ((AST)this.ast).getFileName();
    }

    public L add(N newChild, AST.Kind newChildKind) {
        ((AST)this.ast).setChanged();
        Object n = ((AST)this.ast).buildTree(newChild, newChildKind);
        if (n == null) {
            return null;
        }
        ((LombokNode)n).parent = this;
        this.children = this.children.append(n);
        return n;
    }

    public void rebuild() {
        IdentityHashMap oldNodes = new IdentityHashMap();
        this.gatherAndRemoveChildren(oldNodes);
        Object newNode = ((AST)this.ast).buildTree(this.get(), this.kind);
        ((AST)this.ast).setChanged();
        ((AST)this.ast).replaceNewWithExistingOld(oldNodes, newNode);
    }

    private void gatherAndRemoveChildren(Map<N, L> map) {
        for (LombokNode child : this.children) {
            child.gatherAndRemoveChildren(map);
        }
        ((AST)this.ast).identityDetector.remove(this.get());
        map.put(this.get(), this);
        this.children = LombokImmutableList.of();
        ((AST)this.ast).getNodeMap().remove(this.get());
    }

    public void removeChild(L child) {
        ((AST)this.ast).setChanged();
        this.children = this.children.removeElement(child);
    }

    public boolean isStructurallySignificant() {
        return this.isStructurallySignificant;
    }
}

