/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.commons.infra;

import gr.uoa.di.madgik.commons.utils.XMLUtils;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class HostingNodeTopology {
    private static Map<String, Node> nodes;
    private static Logger logger;

    public static void fromXML(String xml) throws Exception {
        Document d = XMLUtils.Deserialize(xml);
        List<Element> domains = XMLUtils.GetChildElementsWithName(d.getDocumentElement(), "domain");
        for (Element domain : domains) {
            String domainName = XMLUtils.GetAttribute(domain, "name");
            String rackId = null;
            List<Element> racks = XMLUtils.GetChildElementsWithName(domain, "rack");
            if (racks.size() > 0) {
                for (Element rack : racks) {
                    rackId = UUID.randomUUID().toString();
                    List<Element> nodeElements = XMLUtils.GetChildElementsWithName(rack, "node");
                    for (Element node : nodeElements) {
                        String hostName = XMLUtils.GetChildText(node);
                        nodes.put(hostName, new Node(domainName, rackId, hostName));
                    }
                }
                continue;
            }
            List<Element> nodeElements = XMLUtils.GetChildElementsWithName(domain, "node");
            for (Element node : nodeElements) {
                String hostName = XMLUtils.GetChildText(node);
                nodes.put(hostName, new Node(domainName, rackId, hostName));
            }
        }
    }

    public static boolean containsNode(String hostname) {
        return nodes.containsKey(hostname);
    }

    public static boolean sameNode(String hostName1, String hostName2) throws Exception {
        if (!HostingNodeTopology.containsNode(hostName1) || !HostingNodeTopology.containsNode(hostName2)) {
            throw new Exception("No information on given hosts (" + hostName1 + "," + hostName2 + ")");
        }
        return HostingNodeTopology.nodes.get((Object)hostName1).hostname.equals(HostingNodeTopology.nodes.get((Object)hostName2).hostname);
    }

    public static boolean sameRack(String hostName1, String hostName2) throws Exception {
        if (!HostingNodeTopology.containsNode(hostName1) || !HostingNodeTopology.containsNode(hostName2)) {
            throw new Exception("No information on given hosts (" + hostName1 + "," + hostName2 + ")");
        }
        return HostingNodeTopology.nodes.get((Object)hostName1).rack.equals(HostingNodeTopology.nodes.get((Object)hostName2).rack);
    }

    public static boolean sameDomain(String hostName1, String hostName2) throws Exception {
        if (!HostingNodeTopology.containsNode(hostName1) || !HostingNodeTopology.containsNode(hostName2)) {
            throw new Exception("No information on given hosts (" + hostName1 + "," + hostName2 + ")");
        }
        return HostingNodeTopology.nodes.get((Object)hostName1).domain.equals(HostingNodeTopology.nodes.get((Object)hostName2).domain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        block6: {
            nodes = new HashMap<String, Node>();
            logger = null;
            try {
                logger = Logger.getLogger(HostingNodeTopology.class.getName());
                URL resourceNT = Thread.currentThread().getContextClassLoader().getResource("nodeTopology.xml");
                if (resourceNT == null) break block6;
                char[] buffer = new char[1024];
                StringBuilder nt = new StringBuilder();
                int read = 0;
                try (InputStreamReader in = new InputStreamReader(resourceNT.openStream(), "UTF-8");){
                    do {
                        if ((read = ((Reader)in).read(buffer, 0, buffer.length)) <= 0) continue;
                        nt.append(buffer, 0, read);
                    } while (read >= 0);
                }
                HostingNodeTopology.fromXML(nt.toString());
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Error while reading network topology configuration", e);
            }
        }
    }

    private static class Node {
        public final String domain;
        public final String rack;
        public final String hostname;

        public Node(String domain, String rack, String hostname) {
            this.domain = domain;
            this.rack = rack;
            this.hostname = hostname;
        }
    }
}

