/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import org.apache.poi.util.LittleEndian;

public abstract class FormattedDiskPage {
    protected byte[] _fkp;
    protected int _crun;
    protected int _offset;

    public FormattedDiskPage() {
    }

    public FormattedDiskPage(byte[] documentStream, int offset) {
        this._crun = LittleEndian.getUnsignedByte((byte[])documentStream, (int)(offset + 511));
        this._fkp = documentStream;
        this._offset = offset;
    }

    protected int getStart(int index) {
        return LittleEndian.getInt((byte[])this._fkp, (int)(this._offset + index * 4));
    }

    protected int getEnd(int index) {
        return LittleEndian.getInt((byte[])this._fkp, (int)(this._offset + (index + 1) * 4));
    }

    public int size() {
        return this._crun;
    }

    protected abstract byte[] getGrpprl(int var1);
}

