/*
 * Decompiled with CFR 0.152.
 */
package com.germinus.easyconf;

import com.germinus.easyconf.AggregatedProperties;
import com.germinus.easyconf.ClasspathUtil;
import com.germinus.easyconf.ComponentProperties;
import com.germinus.easyconf.ConfigurationException;
import com.germinus.easyconf.ConfigurationObjectCache;
import com.germinus.easyconf.ConfigurationSerializer;
import com.germinus.easyconf.DatasourceURL;
import com.germinus.easyconf.DigesterRulesNotFoundException;
import com.germinus.easyconf.FileURLChangedReloadingStrategy;
import com.germinus.easyconf.InvalidPropertyException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.configuration.DatabaseConfiguration;
import org.apache.commons.configuration.reloading.ReloadingStrategy;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Substitutor;
import org.apache.commons.digester.substitution.MultiVariableExpander;
import org.apache.commons.digester.substitution.VariableExpander;
import org.apache.commons.digester.substitution.VariableSubstitutor;
import org.apache.commons.digester.xmlrules.DigesterLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

class ConfigurationLoader {
    private static final Log log = LogFactory.getLog((Class)(class$com$germinus$easyconf$ConfigurationLoader == null ? (class$com$germinus$easyconf$ConfigurationLoader = ConfigurationLoader.class$("com.germinus.easyconf.ConfigurationLoader")) : class$com$germinus$easyconf$ConfigurationLoader));
    private static final ConfigurationSerializer serializer = ConfigurationSerializer.getSerializer();
    static /* synthetic */ Class class$com$germinus$easyconf$ConfigurationLoader;

    ConfigurationLoader() {
    }

    public ComponentProperties readPropertiesConfiguration(String companyId, String componentName) {
        AggregatedProperties properties = new AggregatedProperties(companyId, componentName);
        properties.addGlobalFileName("global-configuration.properties");
        properties.addBaseFileName(componentName + ".properties");
        log.info((Object)("Properties for " + componentName + " loaded from " + properties.loadedSources()));
        return new ComponentProperties(properties);
    }

    public ConfigurationObjectCache readConfigurationObject(String companyId, String componentName, String confName, ComponentProperties properties) throws IOException, SAXException {
        log.info((Object)("Reading the configuration object for " + componentName));
        ConfigurationObjectCache result = null;
        String inexistentSource = null;
        String sourceName = properties.getString("easyconf:configuration-objects-source", inexistentSource);
        if (sourceName != inexistentSource) {
            if (DatasourceURL.isDatasource(sourceName)) {
                result = this.readConfigurationObjectFromDatabase(companyId, componentName, confName, properties, sourceName);
            } else {
                throw new ConfigurationException("The specified value for easyconf:configuration-object-source is not valid: " + sourceName);
            }
        }
        if (result == null) {
            result = this.readConfigurationObjectFromXMLFile(companyId, componentName, confName, properties);
        }
        return result;
    }

    private ConfigurationObjectCache readConfigurationObjectFromDatabase(String companyId, String componentName, String confName, ComponentProperties properties, String sourceName) {
        DatasourceURL dsURL = new DatasourceURL(sourceName, companyId, componentName, "easyconf_configuration_objects");
        String confObjXML = dsURL.getConfiguration().getString(confName);
        if (confObjXML == null) {
            return null;
        }
        Object confObject = serializer.deserialize(confObjXML);
        ConfigurationObjectCache result = new ConfigurationObjectCache(confObject, null, properties, confName);
        return result;
    }

    private ConfigurationObjectCache readConfigurationObjectFromXMLFile(String companyId, String componentName, String confName, ComponentProperties properties) throws FileNotFoundException, IOException, SAXException {
        String confFileName = null;
        URL confFile = null;
        if (companyId != null) {
            confFileName = componentName + '-' + companyId + ".xml";
            confFile = ClasspathUtil.locateResource(null, confFileName);
            log.info((Object)("Loaded " + confFileName + ": " + confFile));
        }
        if (confFile == null) {
            confFileName = confName == "DEFAULT_CONF_OBJECT" ? componentName + ".xml" : componentName + '.' + confName + ".xml";
            confFile = ClasspathUtil.locateResource(null, confFileName);
        }
        if (confFile == null) {
            throw new FileNotFoundException("File " + confFileName + " not found");
        }
        Object confObj = this.loadXMLFile(confFile, properties);
        ConfigurationObjectCache result = new ConfigurationObjectCache(confObj, confFile, properties, confName);
        Long delay = properties.getDelayPeriod();
        if (delay != null) {
            result.setReloadingStrategy((ReloadingStrategy)new FileURLChangedReloadingStrategy(confFile, delay));
        }
        return result;
    }

    Object loadXMLFile(URL confFileUrl, ComponentProperties properties) throws IOException, SAXException {
        log.debug((Object)("Loading XML file: " + confFileUrl));
        String componentName = properties.getComponentName();
        String rulesFileName = componentName + ".digesterRules.xml";
        URL digesterRulesUrl = ClasspathUtil.locateResource(rulesFileName);
        if (digesterRulesUrl == null) {
            throw new DigesterRulesNotFoundException(componentName, rulesFileName);
        }
        Digester digester = DigesterLoader.createDigester((URL)digesterRulesUrl);
        digester.setUseContextClassLoader(true);
        digester.setValidating(false);
        MultiVariableExpander expander = new MultiVariableExpander();
        expander.addSource("$", properties.toMap());
        VariableSubstitutor substitutor = new VariableSubstitutor((VariableExpander)expander);
        digester.setSubstitutor((Substitutor)substitutor);
        try {
            Object confObj = digester.parse(confFileUrl.openStream());
            log.info((Object)("Read configuration from " + confFileUrl));
            return confObj;
        }
        catch (IllegalArgumentException e) {
            throw new InvalidPropertyException(properties.getComponentName(), e);
        }
    }

    public void saveConfigurationObjectIntoDatabase(Object configurationObject, String companyId, String componentName, String confName, ComponentProperties properties) {
        log.info((Object)("Saving the configuration object into the database for " + componentName));
        String inexistentSource = null;
        String sourceName = properties.getString("easyconf:configuration-objects-source", inexistentSource);
        if (sourceName == inexistentSource) {
            throw new ConfigurationException("It is imposible to save the configuration object. Please specify a valid datasource in property easyconf:configuration-objects-source");
        }
        if (!DatasourceURL.isDatasource(sourceName)) {
            throw new ConfigurationException("The specified value for easyconf:configuration-object-source is not valid: " + sourceName);
        }
        DatasourceURL dsURL = new DatasourceURL(sourceName, companyId, componentName, "easyconf_configuration_objects");
        DatabaseConfiguration dbConf = dsURL.getConfiguration();
        String xml = serializer.serialize(configurationObject);
        dbConf.setProperty(confName, (Object)xml);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

