/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.trash;

import java.util.ArrayList;
import java.util.List;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibary.model.items.type.WorkspaceItemType;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.common.homelibrary.home.workspace.trash.WorkspaceTrashFolder;
import org.gcube.common.homelibrary.home.workspace.trash.WorkspaceTrashItem;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceFolder;
import org.gcube.common.homelibrary.jcr.workspace.servlet.JCRServlets;
import org.gcube.common.homelibrary.jcr.workspace.servlet.wrapper.DelegateManager;
import org.gcube.common.homelibrary.jcr.workspace.trash.JCRWorkspaceTrashItem;
import org.gcube.common.homelibrary.model.exceptions.RepositoryException;

public class JCRWorkspaceTrashFolder
extends JCRWorkspaceFolder
implements WorkspaceTrashFolder {
    public JCRWorkspaceTrashFolder(JCRWorkspace workspace, ItemDelegate delegate) throws RepositoryException {
        super(workspace, delegate);
    }

    public WorkspaceTrashItem getTrashItemById(String id) throws InternalErrorException {
        JCRWorkspaceTrashItem trashItem;
        block8: {
            ItemDelegate trashNode = null;
            trashItem = null;
            JCRServlets servlets = null;
            try {
                try {
                    servlets = new JCRServlets(this.workspace.getOwner().getPortalLogin());
                    trashNode = servlets.getItemById(id);
                    if (!trashNode.getPrimaryType().equals("nthl:trashItem")) break block8;
                    try {
                        trashItem = new JCRWorkspaceTrashItem(this.workspace, trashNode);
                    }
                    catch (Exception e) {
                        throw new InternalErrorException("Trash not found " + e);
                    }
                }
                catch (RepositoryException e) {
                    throw new InternalErrorException((Throwable)e);
                }
                catch (ItemNotFoundException e) {
                    throw new InternalErrorException((Throwable)e);
                }
            }
            finally {
                servlets.releaseSession();
            }
        }
        return trashItem;
    }

    public List<WorkspaceTrashItem> listTrashItems() throws InternalErrorException, ItemNotFoundException {
        ItemDelegate node = null;
        ArrayList<WorkspaceTrashItem> children = null;
        JCRServlets servlets = null;
        try {
            try {
                servlets = new JCRServlets(this.workspace.getOwner().getPortalLogin());
                children = new ArrayList<WorkspaceTrashItem>();
                node = servlets.getItemById(this.getId());
                DelegateManager wrap = new DelegateManager(node, this.workspace.getOwner().getPortalLogin());
                List<ItemDelegate> trashNodes = wrap.getNodes();
                for (ItemDelegate trashNode : trashNodes) {
                    if (!trashNode.getPrimaryType().equals("nthl:trashItem")) continue;
                    WorkspaceTrashItem trashItem = (WorkspaceTrashItem)this.workspace.getItem(trashNode.getId());
                    children.add(trashItem);
                }
            }
            catch (RepositoryException e) {
                throw new InternalErrorException((Throwable)e);
            }
            catch (ItemNotFoundException e) {
                throw new ItemNotFoundException(e.getMessage());
            }
            catch (Exception e) {
                e.printStackTrace();
                servlets.releaseSession();
            }
        }
        finally {
            servlets.releaseSession();
        }
        return children;
    }

    public List<String> emptyTrash() throws InternalErrorException {
        ItemDelegate trashNode = null;
        JCRServlets servlets = null;
        try {
            try {
                servlets = new JCRServlets(this.workspace.getOwner().getPortalLogin());
                trashNode = servlets.getItemById(this.getId());
                DelegateManager wrap = new DelegateManager(trashNode, this.workspace.getOwner().getPortalLogin());
                List<ItemDelegate> children = wrap.getNodes();
                for (ItemDelegate child : children) {
                    if (!child.getPrimaryType().equals("nthl:trashItem")) continue;
                    try {
                        JCRWorkspaceTrashItem trashItem = new JCRWorkspaceTrashItem(this.workspace, child);
                        trashItem.deletePermanently();
                    }
                    catch (Exception e) {
                        throw new InternalErrorException((Throwable)e);
                    }
                }
            }
            catch (RepositoryException e) {
                throw new InternalErrorException((Throwable)e);
            }
            catch (ItemNotFoundException e) {
                throw new InternalErrorException((Throwable)e);
            }
        }
        finally {
            servlets.releaseSession();
        }
        return null;
    }

    public List<String> restoreAll() throws InternalErrorException {
        ItemDelegate trashNode = null;
        JCRServlets servlets = null;
        try {
            try {
                servlets = new JCRServlets(this.workspace.getOwner().getPortalLogin());
                trashNode = servlets.getItemById(this.getId());
                DelegateManager wrap = new DelegateManager(trashNode, this.workspace.getOwner().getPortalLogin());
                List<ItemDelegate> children = wrap.getNodes();
                for (ItemDelegate child : children) {
                    if (!child.getPrimaryType().equals("nthl:trashItem")) continue;
                    try {
                        JCRWorkspaceTrashItem trashItem = new JCRWorkspaceTrashItem(this.workspace, child);
                        trashItem.restore();
                    }
                    catch (Exception e) {
                        throw new InternalErrorException((Throwable)e);
                    }
                }
            }
            catch (RepositoryException e) {
                throw new InternalErrorException((Throwable)e);
            }
            catch (ItemNotFoundException e) {
                throw new InternalErrorException((Throwable)e);
            }
        }
        finally {
            servlets.releaseSession();
        }
        return null;
    }

    @Override
    public WorkspaceItemType getType() {
        return WorkspaceItemType.TRASH_FOLDER;
    }
}

