/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.servlet;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.List;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.lang.Validate;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibary.model.items.SearchItemDelegate;
import org.gcube.common.homelibary.model.items.accounting.AccountingDelegate;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.common.homelibrary.jcr.repository.JCRRepository;
import org.gcube.common.homelibrary.jcr.workspace.lock.JCRLockManager;
import org.gcube.common.homelibrary.model.exceptions.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRServlets {
    private String urlRepository;
    private Logger logger = LoggerFactory.getLogger(JCRServlets.class);
    private String login;
    private String sessionId;
    private JCRLockManager lockManager;

    public JCRServlets(String login) throws RepositoryException {
        this.login = login;
        this.urlRepository = JCRRepository.url;
        this.sessionId = this.getSession();
    }

    public JCRServlets() throws RepositoryException {
        this.login = null;
        this.urlRepository = JCRRepository.url;
        this.sessionId = this.getSession();
    }

    private String getSession() {
        String uuid = null;
        GetMethod getMethod = null;
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
        HttpClient httpClient = new HttpClient();
        try {
            try {
                getMethod = new GetMethod(String.valueOf(JCRRepository.url) + "/CreateSession?" + JCRRepository.getCredentials() + "&login=" + this.login);
                httpClient.executeMethod((HttpMethod)getMethod);
                uuid = (String)xstream.fromXML(getMethod.getResponseBodyAsStream());
                this.logger.info("Get session " + uuid + " by " + this.login);
            }
            catch (Exception e) {
                e.getStackTrace();
                if (getMethod != null) {
                    getMethod.releaseConnection();
                }
            }
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return uuid;
    }

    public void releaseSession() {
        this.logger.info("Calling servlet releaseSession " + this.sessionId + " by " + this.login);
        GetMethod getMethod = null;
        HttpClient httpClient = new HttpClient();
        try {
            try {
                getMethod = new GetMethod(String.valueOf(JCRRepository.url) + "/ReleaseSession?" + JCRRepository.getCredentials() + "&login=" + this.login + "&uuid=" + this.sessionId);
                httpClient.executeMethod((HttpMethod)getMethod);
            }
            catch (Exception e) {
                e.getStackTrace();
                if (getMethod != null) {
                    getMethod.releaseConnection();
                }
            }
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
    }

    public List<ItemDelegate> getChildrenById(String id) {
        this.logger.info("Calling servlet getChildrenById " + id + " by " + this.login);
        List items = null;
        GetMethod getMethod = null;
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
        HttpClient httpClient = new HttpClient();
        try {
            try {
                getMethod = new GetMethod(String.valueOf(JCRRepository.url) + "/get/GetChildrenById?" + JCRRepository.getCredentials() + "&id=" + id + "&login=" + this.login + "&uuid=" + this.sessionId);
                httpClient.executeMethod((HttpMethod)getMethod);
                items = (List)xstream.fromXML(getMethod.getResponseBodyAsStream());
            }
            catch (Exception e) {
                e.getStackTrace();
                if (getMethod != null) {
                    getMethod.releaseConnection();
                }
            }
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return items;
    }

    public ItemDelegate getItemByPath(String path) throws ItemNotFoundException {
        this.logger.info("Calling Servlet GetItemByPath " + path + " by " + this.login);
        ItemDelegate item = null;
        GetMethod getMethod = null;
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
        HttpClient httpClient = new HttpClient();
        try {
            try {
                getMethod = new GetMethod(String.valueOf(this.urlRepository) + "/get/GetItemByPath?" + JCRRepository.getCredentials() + "&path=" + URLEncoder.encode(path, "UTF-8") + "&login=" + this.login + "&uuid=" + this.sessionId);
                httpClient.executeMethod((HttpMethod)getMethod);
                item = (ItemDelegate)xstream.fromXML(getMethod.getResponseBodyAsStream());
            }
            catch (Exception e) {
                throw new ItemNotFoundException(e.getMessage());
            }
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return item;
    }

    public ItemDelegate getItemById(String id) throws ItemNotFoundException {
        ItemDelegate item = null;
        GetMethod getMethod = null;
        HttpClient httpClient = new HttpClient();
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
        try {
            try {
                getMethod = new GetMethod(String.valueOf(this.urlRepository) + "/get/GetItemById?" + JCRRepository.getCredentials() + "&id=" + id);
                httpClient.executeMethod((HttpMethod)getMethod);
                item = (ItemDelegate)xstream.fromXML(getMethod.getResponseBodyAsStream());
            }
            catch (Exception e) {
                throw new ItemNotFoundException(e.getMessage());
            }
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return item;
    }

    public ItemDelegate getParentById(String id) throws ItemNotFoundException {
        ItemDelegate item = null;
        GetMethod getMethod = null;
        HttpClient httpClient = new HttpClient();
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
        try {
            try {
                getMethod = new GetMethod(String.valueOf(this.urlRepository) + "/get/GetParentById?" + JCRRepository.getCredentials() + "&id=" + id + "&uuid=" + this.sessionId);
                httpClient.executeMethod((HttpMethod)getMethod);
                item = (ItemDelegate)xstream.fromXML(getMethod.getResponseBodyAsStream());
            }
            catch (Exception e) {
                throw new ItemNotFoundException(e.getMessage());
            }
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return item;
    }

    public ItemDelegate saveItem(ItemDelegate item) throws RepositoryException {
        Validate.notNull((Object)item, (String)"item must be not null");
        this.logger.info("Calling Servlet SaveItem " + item.getName() + " by " + this.login);
        ItemDelegate modifiedItem = null;
        PostMethod post = null;
        HttpClient httpClient = new HttpClient();
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
        try {
            try {
                post = new PostMethod(String.valueOf(this.urlRepository) + "/post/SaveItem?" + JCRRepository.getCredentials() + "&uuid=" + this.sessionId);
                post.setRequestEntity((RequestEntity)new StringRequestEntity(xstream.toXML((Object)item), "application/json", null));
                int response = httpClient.executeMethod((HttpMethod)post);
                if (response != 200) {
                    throw new HttpException("Received error status " + response);
                }
                modifiedItem = (ItemDelegate)xstream.fromXML(post.getResponseBodyAsStream());
            }
            catch (IOException e) {
                e.printStackTrace();
                if (post != null) {
                    post.releaseConnection();
                }
            }
        }
        finally {
            if (post != null) {
                post.releaseConnection();
            }
        }
        return modifiedItem;
    }

    public ItemDelegate clone(String srcAbsPath, String destAbsPath, boolean removeExisting) throws HttpException, IOException {
        this.logger.info("Calling Servlet Clone from " + srcAbsPath + " to " + destAbsPath + " by " + this.login);
        ItemDelegate modifiedItem = null;
        GetMethod getMethod = new GetMethod();
        HttpClient httpClient = new HttpClient();
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
        try {
            getMethod = new GetMethod(String.valueOf(this.urlRepository) + "/get/Clone?" + JCRRepository.getCredentials() + "&srcAbsPath=" + URLEncoder.encode(srcAbsPath, "UTF-8") + "&destAbsPath=" + URLEncoder.encode(destAbsPath, "UTF-8") + "&removeExisting=" + removeExisting + "&uuid=" + this.sessionId);
            httpClient.executeMethod((HttpMethod)getMethod);
            modifiedItem = (ItemDelegate)xstream.fromXML(getMethod.getResponseBodyAsStream());
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return modifiedItem;
    }

    public ItemDelegate move(String srcAbsPath, String destAbsPath) throws HttpException, IOException {
        this.logger.info("Calling Servlet Move from " + srcAbsPath + " to " + destAbsPath + " by " + this.login);
        ItemDelegate modifiedItem = null;
        GetMethod getMethod = null;
        HttpClient httpClient = new HttpClient();
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
        try {
            getMethod = new GetMethod(String.valueOf(this.urlRepository) + "/get/Move?" + JCRRepository.getCredentials() + "&srcAbsPath=" + URLEncoder.encode(srcAbsPath, "UTF-8") + "&destAbsPath=" + URLEncoder.encode(destAbsPath, "UTF-8") + "&uuid=" + this.sessionId);
            int response = httpClient.executeMethod((HttpMethod)getMethod);
            if (response != 200) {
                throw new HttpException("Received error status " + response);
            }
            modifiedItem = (ItemDelegate)xstream.fromXML(getMethod.getResponseBodyAsStream());
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return modifiedItem;
    }

    public void removeItem(String absPath) throws IOException {
        this.logger.info("Calling Servlet RemoveItem " + absPath + " by " + this.login);
        PostMethod post = new PostMethod();
        HttpClient httpClient = new HttpClient();
        try {
            post = new PostMethod(String.valueOf(this.urlRepository) + "/post/RemoveItem?" + JCRRepository.getCredentials() + "&absPath=" + URLEncoder.encode(absPath, "UTF-8") + "&uuid=" + this.sessionId);
            int response = httpClient.executeMethod((HttpMethod)post);
            if (response != 200) {
                throw new HttpException("Received error status " + response);
            }
        }
        finally {
            if (post != null) {
                post.releaseConnection();
            }
        }
    }

    public ItemDelegate copy(String srcAbsPath, String destAbsPath) throws IOException {
        ItemDelegate item = null;
        GetMethod post = new GetMethod();
        HttpClient httpClient = new HttpClient();
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
        try {
            post = new GetMethod(String.valueOf(this.urlRepository) + "/get/Copy?" + JCRRepository.getCredentials() + "&srcAbsPath=" + URLEncoder.encode(srcAbsPath, "UTF-8") + "&destAbsPath=" + URLEncoder.encode(destAbsPath, "UTF-8") + "&uuid=" + this.sessionId);
            int response = httpClient.executeMethod((HttpMethod)post);
            if (response != 200) {
                throw new HttpException("Received error status " + response);
            }
            item = (ItemDelegate)xstream.fromXML(post.getResponseBodyAsStream());
        }
        finally {
            if (post != null) {
                post.releaseConnection();
            }
        }
        return item;
    }

    public ItemDelegate copyContent(String srcId, String destId) throws IOException {
        ItemDelegate item = null;
        PostMethod post = new PostMethod();
        HttpClient httpClient = new HttpClient();
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
        try {
            post = new PostMethod(String.valueOf(this.urlRepository) + "/post/CopyContent?" + JCRRepository.getCredentials() + "&srcId=" + srcId + "&destId=" + destId + "&uuid=" + this.sessionId);
            int response = httpClient.executeMethod((HttpMethod)post);
            if (response != 200) {
                throw new HttpException("Received error status " + response);
            }
            item = (ItemDelegate)xstream.fromXML(post.getResponseBodyAsStream());
        }
        finally {
            if (post != null) {
                post.releaseConnection();
            }
        }
        return item;
    }

    public List<SearchItemDelegate> executeQuery(String query, String lang, int limit) throws HttpException, IOException {
        GetMethod get = null;
        HttpClient httpClient = new HttpClient();
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
        List list = null;
        try {
            get = new GetMethod(String.valueOf(this.urlRepository) + "/get/ExecuteQuery?" + JCRRepository.getCredentials() + "&query=" + URLEncoder.encode(query, "UTF-8") + "&lang=" + lang + "&login=" + this.login + "&limit=" + limit + "&uuid=" + this.sessionId);
            int response = httpClient.executeMethod((HttpMethod)get);
            if (response != 200) {
                throw new HttpException("Received error status " + response);
            }
            list = (List)xstream.fromXML(get.getResponseBodyAsStream());
        }
        finally {
            if (get != null) {
                get.releaseConnection();
            }
        }
        return list;
    }

    public List<ItemDelegate> searchItems(String query, String lang) throws HttpException, IOException {
        GetMethod get = null;
        HttpClient httpClient = new HttpClient();
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
        List list = null;
        try {
            get = new GetMethod(String.valueOf(this.urlRepository) + "/get/SearchItems?" + JCRRepository.getCredentials() + "&query=" + URLEncoder.encode(query, "UTF-8") + "&lang=" + lang + "&login=" + this.login + "&uuid=" + this.sessionId);
            int response = httpClient.executeMethod((HttpMethod)get);
            if (response != 200) {
                throw new HttpException("Received error status " + response);
            }
            list = (List)xstream.fromXML(get.getResponseBodyAsStream());
        }
        finally {
            if (get != null) {
                get.releaseConnection();
            }
        }
        return list;
    }

    public void saveAccountingItem(AccountingDelegate item) {
        Validate.notNull((Object)item, (String)"item must be not null");
        PostMethod post = null;
        HttpClient httpClient = new HttpClient();
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
        try {
            try {
                post = new PostMethod(String.valueOf(this.urlRepository) + "/post/SaveAccountingItem?" + JCRRepository.getCredentials() + "&uuid=" + this.sessionId);
                post.setRequestEntity((RequestEntity)new StringRequestEntity(xstream.toXML((Object)item), "application/json", null));
                int response = httpClient.executeMethod((HttpMethod)post);
                if (response != 200) {
                    throw new HttpException("Received error status " + response);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                if (post != null) {
                    post.releaseConnection();
                }
            }
        }
        finally {
            if (post != null) {
                post.releaseConnection();
            }
        }
    }

    public List<AccountingDelegate> getAccountingById(String id) {
        List items = null;
        GetMethod getMethod = null;
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
        HttpClient httpClient = new HttpClient();
        try {
            try {
                getMethod = new GetMethod(String.valueOf(JCRRepository.url) + "/GetAccountingById?" + JCRRepository.getCredentials() + "&id=" + id + "&uuid=" + this.sessionId);
                httpClient.executeMethod((HttpMethod)getMethod);
                items = (List)xstream.fromXML(getMethod.getResponseBodyAsStream());
            }
            catch (Exception e) {
                e.getStackTrace();
                if (getMethod != null) {
                    getMethod.releaseConnection();
                }
            }
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return items;
    }

    public ItemDelegate createReference(String itemId, String destinationFolderId) throws HttpException, IOException {
        this.logger.info("Calling Servlet createReference of Node Id " + itemId + " to destination folder ID" + destinationFolderId + " by " + this.login);
        ItemDelegate modifiedItem = null;
        GetMethod getMethod = null;
        HttpClient httpClient = new HttpClient();
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
        try {
            getMethod = new GetMethod(String.valueOf(this.urlRepository) + "/get/CreateReference?" + JCRRepository.getCredentials() + "&srcId=" + itemId + "&destId=" + destinationFolderId + "&login=" + this.login + "&uuid=" + this.sessionId);
            int response = httpClient.executeMethod((HttpMethod)getMethod);
            if (response != 200) {
                throw new HttpException("Received error status " + response);
            }
            modifiedItem = (ItemDelegate)xstream.fromXML(getMethod.getResponseBodyAsStream());
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return modifiedItem;
    }

    public JCRLockManager getLockManager() {
        if (this.lockManager == null) {
            this.lockManager = new JCRLockManager(this.login, this.sessionId);
        }
        return this.lockManager;
    }
}

