/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.folder.items;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.PathNotFoundException;
import javax.jcr.ValueFormatException;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibary.model.items.type.FolderItemType;
import org.gcube.common.homelibary.model.items.type.NodeProperty;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRFile;
import org.gcube.common.homelibrary.jcr.workspace.util.WorkspaceItemUtil;
import org.gcube.common.homelibrary.model.exceptions.RepositoryException;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;

public class JCRPDFFile
extends JCRFile {
    public JCRPDFFile(JCRWorkspace workspace, ItemDelegate delegate) throws RepositoryException {
        super(workspace, delegate);
    }

    public JCRPDFFile(JCRWorkspace workspace, ItemDelegate delegate, String mimeType, File tmpFile) throws RepositoryException, IOException, RemoteBackendException {
        super(workspace, delegate, mimeType, tmpFile);
        try {
            this.setProperties(delegate, tmpFile);
        }
        catch (PathNotFoundException | ValueFormatException e) {
            e.printStackTrace();
        }
    }

    public JCRPDFFile(JCRWorkspace workspace, ItemDelegate itemDelegate, String mimeType, File tmpFile, String path) throws RepositoryException, IOException, RemoteBackendException {
        super(workspace, itemDelegate, mimeType, tmpFile, path);
        try {
            this.setProperties(itemDelegate, tmpFile);
        }
        catch (PathNotFoundException | ValueFormatException e) {
            e.printStackTrace();
        }
    }

    private void setProperties(ItemDelegate itemDelegate, File tmp) throws ValueFormatException, PathNotFoundException, RepositoryException, IOException {
        Map content = itemDelegate.getContent();
        FileInputStream dataPdf = new FileInputStream(tmp);
        HashMap<String, String> infoPDF = WorkspaceItemUtil.getPDFInfo(dataPdf);
        int numberOfPages = Integer.parseInt((String)infoPDF.get("hl-numberOfPages"));
        String version = (String)infoPDF.get("hl-version");
        String author = (String)infoPDF.get("Author");
        String title = (String)infoPDF.get("Title");
        String producer = (String)infoPDF.get("Producer");
        content.put(NodeProperty.NUMBER_OF_PAGES, new XStream().toXML((Object)numberOfPages));
        content.put(NodeProperty.VERSION, new XStream().toXML((Object)version));
        content.put(NodeProperty.AUTHOR, new XStream().toXML((Object)author));
        content.put(NodeProperty.PDF_TITLE, new XStream().toXML((Object)title));
        content.put(NodeProperty.PRODUCER, new XStream().toXML((Object)producer));
        ((InputStream)dataPdf).close();
    }

    public FolderItemType getFolderItemType() {
        return FolderItemType.EXTERNAL_PDF_FILE;
    }

    public int getNumberOfPages() {
        int numberOfPages = 0;
        try {
            numberOfPages = (Integer)new XStream().fromXML((String)this.itemDelegate.getContent().get(NodeProperty.NUMBER_OF_PAGES));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return numberOfPages;
    }

    public String getVersion() {
        String version = null;
        try {
            version = (String)this.itemDelegate.getContent().get(NodeProperty.VERSION);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return version;
    }

    public String getAuthor() {
        String author = null;
        try {
            author = (String)this.itemDelegate.getContent().get(NodeProperty.AUTHOR);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return author;
    }

    public String getTitle() {
        String title = null;
        try {
            title = (String)this.itemDelegate.getContent().get(NodeProperty.PDF_TITLE);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return title;
    }

    public String getProducer() {
        String title = null;
        try {
            title = (String)this.itemDelegate.getContent().get(NodeProperty.PRODUCER);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return title;
    }

    @Override
    public void updateInfo(File tmp) throws InternalErrorException {
        super.updateInfo(tmp);
        try {
            this.setProperties(this.itemDelegate, tmp);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

