/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.folder.items;

import com.thoughtworks.xstream.XStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibary.model.items.type.FolderItemType;
import org.gcube.common.homelibary.model.items.type.NodeProperty;
import org.gcube.common.homelibary.model.items.type.WorkspaceItemType;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.WorkspaceSharedFolder;
import org.gcube.common.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WrongDestinationException;
import org.gcube.common.homelibrary.home.workspace.folder.items.GCubeItem;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceItem;
import org.gcube.common.homelibrary.jcr.workspace.servlet.JCRServlets;
import org.gcube.common.homelibrary.model.exceptions.RepositoryException;

public class JCRGCubeItem
extends JCRWorkspaceItem
implements GCubeItem {
    public JCRGCubeItem(JCRWorkspace workspace, ItemDelegate node, String name, String description, List<String> scopes, String creator, String itemType, Map<String, String> properties) throws RepositoryException, ItemNotFoundException {
        super(workspace, node, name, description);
        Validate.notNull(scopes, (String)"scopes must be not null");
        Validate.notEmpty(scopes, (String)"scopes must be not empty");
        Validate.notNull((Object)creator, (String)"creator must be not null");
        Validate.notNull((Object)itemType, (String)"item type must be not null");
        this.delegate.setProperties(new HashMap());
        this.delegate.getProperties().put(NodeProperty.CREATOR, creator);
        this.delegate.getProperties().put(NodeProperty.ITEM_TYPE, itemType);
        this.delegate.getProperties().put(NodeProperty.SCOPES, new XStream().toXML(scopes));
        this.delegate.getProperties().put(NodeProperty.PROPERTY, new XStream().toXML(properties));
        this.delegate.getProperties().put(NodeProperty.IS_SHARED, new XStream().toXML((Object)false));
    }

    public JCRGCubeItem(JCRWorkspace workspace, ItemDelegate delegate) throws RepositoryException {
        super(workspace, delegate);
    }

    public WorkspaceItemType getType() {
        return WorkspaceItemType.FOLDER_ITEM;
    }

    public List<? extends WorkspaceItem> getChildren() throws InternalErrorException {
        return null;
    }

    public List<String> getScopes() throws InternalErrorException {
        return (List)new XStream().fromXML((String)this.delegate.getProperties().get(NodeProperty.SCOPES));
    }

    public String getItemType() {
        return (String)this.delegate.getProperties().get(NodeProperty.ITEM_TYPE);
    }

    public String getCreator() {
        return (String)this.delegate.getProperties().get(NodeProperty.CREATOR);
    }

    public FolderItemType getFolderItemType() {
        return FolderItemType.GCUBE_ITEM;
    }

    public long getLength() throws InternalErrorException {
        return 0L;
    }

    public String getMimeType() throws InternalErrorException {
        return null;
    }

    public void removeChild(WorkspaceItem child) throws InternalErrorException, InsufficientPrivilegesException {
    }

    @Override
    public boolean isShared() throws InternalErrorException {
        return this.delegate.isShared();
    }

    public WorkspaceSharedFolder share(List<String> users) throws InternalErrorException {
        WorkspaceSharedFolder folder = null;
        try {
            folder = this.workspace.shareFolder(users, this.getId());
        }
        catch (InsufficientPrivilegesException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongDestinationException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (ItemNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WorkspaceFolderNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        return folder;
    }

    public void setSharedRootId(String id) {
        Map properties = this.delegate.getProperties();
        properties.put(NodeProperty.SHARED_ROOT_ID, id);
        properties.put(NodeProperty.IS_SHARED, new XStream().toXML((Object)true));
        this.delegate.setProperties(properties);
    }

    @Override
    public ItemDelegate save() throws RepositoryException {
        return super.save();
    }

    @Override
    public String getIdSharedFolder() throws InternalErrorException {
        ItemDelegate item;
        block6: {
            JCRServlets servlets = null;
            item = null;
            try {
                servlets = new JCRServlets(this.workspace.getOwner().getPortalLogin());
                item = servlets.getItemById(this.getId());
            }
            catch (ItemNotFoundException e) {
                logger.error("impossible to retrieve item id: " + this.getId());
                servlets.releaseSession();
                break block6;
            }
            catch (RepositoryException e) {
                try {
                    throw new InternalErrorException((Throwable)e);
                }
                catch (Throwable throwable) {
                    servlets.releaseSession();
                    throw throwable;
                }
            }
            servlets.releaseSession();
        }
        return (String)item.getProperties().get(NodeProperty.SHARED_ROOT_ID);
    }

    public InputStream getData() throws InternalErrorException {
        InputStream stream = null;
        JCRServlets servlets = null;
        try {
            servlets = new JCRServlets(this.workspace.getOwner().getPortalLogin());
            ItemDelegate node = servlets.getItemById(this.delegate.getId());
            String remotePath = null;
            try {
                remotePath = (String)node.getProperties().get(NodeProperty.REMOTE_STORAGE_PATH);
            }
            catch (Exception e) {
                servlets.releaseSession();
                return null;
            }
            try {
                if (remotePath != null) {
                    logger.trace("Content retrieved from remote storage...");
                    try {
                        stream = this.workspace.getStorage().getRemoteFile(remotePath, this.workspace.getOwner().getPortalLogin());
                    }
                    catch (Exception e) {
                        logger.error("no payload for " + this.getName());
                    }
                }
            }
            catch (RepositoryException e) {
                throw new InternalErrorException((Throwable)e);
            }
            catch (ItemNotFoundException e) {
                throw new InternalErrorException((Throwable)e);
            }
        }
        finally {
            servlets.releaseSession();
        }
        return stream;
    }
}

