/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.sharing;

import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibrary.home.HomeManager;
import org.gcube.common.homelibrary.home.User;
import org.gcube.common.homelibrary.home.exceptions.HomeNotFoundException;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.exceptions.UserNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.common.homelibrary.home.workspace.sharing.WorkspaceMessage;
import org.gcube.common.homelibrary.home.workspace.sharing.WorkspaceMessageManager;
import org.gcube.common.homelibrary.jcr.sharing.JCRWorkspaceMessage;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.common.homelibrary.jcr.workspace.servlet.JCRServlets;
import org.gcube.common.homelibrary.jcr.workspace.servlet.wrapper.DelegateManager;
import org.gcube.common.homelibrary.model.exceptions.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRWorkspaceMessageManager
implements WorkspaceMessageManager {
    private JCRWorkspace workspace;
    private static Logger logger = LoggerFactory.getLogger(JCRWorkspaceMessageManager.class);
    protected static final String CONTENT = "jcr:content";
    protected static final String ATTACHMENTS = "hl:attachments";

    public JCRWorkspaceMessageManager(JCRWorkspace workspace) {
        this.workspace = workspace;
    }

    public String sendMessageToPortalLogins(String subject, String body, List<String> attachmentIds, List<String> addresses) throws InternalErrorException {
        JCRWorkspaceMessage itemToSend = null;
        JCRServlets session = null;
        try {
            try {
                session = new JCRServlets(this.workspace.getOwner().getPortalLogin());
                String messageId = UUID.randomUUID().toString();
                ItemDelegate nodeHiddenFolder = this.workspace.getRepository().getHiddenFolder(session);
                ItemDelegate nodeOutBox = this.workspace.getRepository().getOutBoxFolder(session);
                DelegateManager nodeOutBoxWrap = new DelegateManager(nodeOutBox, this.workspace.getOwner().getPortalLogin());
                ItemDelegate nodeSentMessage = nodeOutBoxWrap.addNode(messageId, "nthl:itemSentRequest".toString());
                JCRWorkspaceMessage itemInSentFolder = new JCRWorkspaceMessage(this.workspace, nodeSentMessage, JCRWorkspaceMessage.WorkspaceMessageType.SENT, messageId, subject, body, this.workspace.getOwner(), attachmentIds, addresses, nodeHiddenFolder);
                List<String> copyAttachmentsIds = itemInSentFolder.getCopyAttachmentsIds();
                for (String user : addresses) {
                    logger.debug("Send message to user " + user);
                    HomeManager homeManager = this.workspace.getHome().getHomeManager();
                    homeManager.getHome(user);
                    ItemDelegate node = this.workspace.getRepository().getInBoxFolder(session, user);
                    DelegateManager nodeWrap = new DelegateManager(node, this.workspace.getOwner().getPortalLogin());
                    ItemDelegate itemNode = nodeWrap.addNode(messageId, "nthl:itemSentRequest".toString());
                    itemToSend = new JCRWorkspaceMessage(this.workspace, itemNode, JCRWorkspaceMessage.WorkspaceMessageType.RECEIVED, messageId, subject, body, this.workspace.getOwner(), copyAttachmentsIds, addresses, nodeHiddenFolder);
                }
            }
            catch (HomeNotFoundException e) {
                logger.error("User home not found", (Throwable)e);
                throw new InternalErrorException((Throwable)e);
            }
            catch (RepositoryException e) {
                logger.error("Internal error exception", (Throwable)e);
                throw new InternalErrorException((Throwable)e);
            }
            catch (UserNotFoundException e) {
                throw new InternalErrorException((Throwable)e);
            }
        }
        finally {
            session.releaseSession();
        }
        return itemToSend.getId();
    }

    public String sendMessageToUsers(String subject, String body, List<String> attachmentIds, List<User> addresses) throws InternalErrorException {
        LinkedList<String> list = new LinkedList<String>();
        for (User user : addresses) {
            list.add(user.getPortalLogin());
        }
        this.sendMessageToPortalLogins(subject, body, attachmentIds, list);
        return body;
    }

    public WorkspaceMessage getSentMessage(String id) throws InternalErrorException, ItemNotFoundException {
        JCRServlets session = null;
        try {
            JCRWorkspaceMessage message;
            session = new JCRServlets(this.workspace.getOwner().getPortalLogin());
            ItemDelegate outBoxFolder = this.workspace.getRepository().getOutBoxFolder(session);
            DelegateManager nodeWrap = new DelegateManager(outBoxFolder, this.workspace.getOwner().getPortalLogin());
            ItemDelegate messageNode = nodeWrap.getNode(id);
            JCRWorkspaceMessage jCRWorkspaceMessage = message = new JCRWorkspaceMessage(this.workspace, messageNode, JCRWorkspaceMessage.WorkspaceMessageType.SENT);
            return jCRWorkspaceMessage;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.releaseSession();
        }
    }

    public WorkspaceMessage getReceivedMessage(String id) throws InternalErrorException, ItemNotFoundException {
        JCRServlets session = null;
        try {
            JCRWorkspaceMessage message;
            session = new JCRServlets(this.workspace.getOwner().getPortalLogin());
            ItemDelegate outBoxFolder = this.workspace.getRepository().getOutBoxFolder(session);
            DelegateManager nodeWrap = new DelegateManager(outBoxFolder, this.workspace.getOwner().getPortalLogin());
            ItemDelegate messageNode = nodeWrap.getNode(id);
            JCRWorkspaceMessage jCRWorkspaceMessage = message = new JCRWorkspaceMessage(this.workspace, messageNode, JCRWorkspaceMessage.WorkspaceMessageType.RECEIVED);
            return jCRWorkspaceMessage;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.releaseSession();
        }
    }

    public void deleteReceivedMessage(String id) {
        JCRServlets session = null;
        try {
            try {
                session = new JCRServlets(this.workspace.getOwner().getPortalLogin());
                ItemDelegate outBoxFolder = this.workspace.getRepository().getOutBoxFolder(session);
                DelegateManager nodeWrap = new DelegateManager(outBoxFolder, this.workspace.getOwner().getPortalLogin());
                ItemDelegate messageNode = nodeWrap.getNode(id);
                this.workspace.getStorage().removeRemoteFolder(messageNode.getPath(), this.workspace.getOwner().getPortalLogin());
                session.removeItem(messageNode.getPath());
            }
            catch (Exception e) {
                logger.error("Internal error exception", (Throwable)e);
                session.releaseSession();
            }
        }
        finally {
            session.releaseSession();
        }
    }

    public void deleteSentMessage(String id) {
        JCRServlets session = null;
        try {
            try {
                session = new JCRServlets(this.workspace.getOwner().getPortalLogin());
                ItemDelegate outBoxFolder = this.workspace.getRepository().getOutBoxFolder(session);
                DelegateManager nodeWrap = new DelegateManager(outBoxFolder, this.workspace.getOwner().getPortalLogin());
                ItemDelegate messageNode = nodeWrap.getNode(id);
                this.workspace.getStorage().removeRemoteFolder(messageNode.getPath(), this.workspace.getOwner().getPortalLogin());
                session.removeItem(messageNode.getPath());
            }
            catch (Exception e) {
                logger.error("Internal error exception", (Throwable)e);
                session.releaseSession();
            }
        }
        finally {
            session.releaseSession();
        }
    }

    public List<WorkspaceMessage> getReceivedMessages() {
        LinkedList<WorkspaceMessage> list = new LinkedList<WorkspaceMessage>();
        JCRServlets session = null;
        try {
            try {
                session = new JCRServlets(this.workspace.getOwner().getPortalLogin());
                ItemDelegate nodeInBox = this.workspace.getRepository().getOwnInBoxFolder(session);
                List<ItemDelegate> recedivedMessages = session.getChildrenById(nodeInBox.getId());
                for (ItemDelegate messageNode : recedivedMessages) {
                    list.add(new JCRWorkspaceMessage(this.workspace, messageNode, JCRWorkspaceMessage.WorkspaceMessageType.RECEIVED));
                }
            }
            catch (Exception e) {
                logger.error("Internal error exception", (Throwable)e);
                session.releaseSession();
            }
        }
        finally {
            session.releaseSession();
        }
        return list;
    }

    public List<WorkspaceMessage> getSentMessages() {
        LinkedList<WorkspaceMessage> list = new LinkedList<WorkspaceMessage>();
        JCRServlets session = null;
        try {
            try {
                session = new JCRServlets(this.workspace.getOwner().getPortalLogin());
                ItemDelegate nodeOutBox = this.workspace.getRepository().getOutBoxFolder(session);
                List<ItemDelegate> sentMessages = session.getChildrenById(nodeOutBox.getId());
                for (ItemDelegate messageNode : sentMessages) {
                    list.add(new JCRWorkspaceMessage(this.workspace, messageNode, JCRWorkspaceMessage.WorkspaceMessageType.SENT));
                }
            }
            catch (Exception e) {
                logger.error("Internal error exception", (Throwable)e);
                session.releaseSession();
            }
        }
        finally {
            session.releaseSession();
        }
        return list;
    }

    public int getMessagesNotOpened() {
        int count = 0;
        for (WorkspaceMessage message : this.getReceivedMessages()) {
            if (((JCRWorkspaceMessage)message).isOpened()) continue;
            ++count;
        }
        return count;
    }

    public List<WorkspaceMessage> searchInMessages(String word) throws InternalErrorException {
        JCRServlets session = null;
        try {
            List<WorkspaceMessage> list;
            session = new JCRServlets(this.workspace.getOwner().getPortalLogin());
            ItemDelegate nodeInBox = this.workspace.getRepository().getOwnInBoxFolder(session);
            List<ItemDelegate> iterator = this.getNodeSearched(session, nodeInBox, word);
            List<WorkspaceMessage> list2 = list = this.getMessagesSearched(iterator, JCRWorkspaceMessage.WorkspaceMessageType.RECEIVED);
            return list2;
        }
        catch (RepositoryException e) {
            logger.error("Error ", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.releaseSession();
        }
    }

    public List<WorkspaceMessage> searchOutMessages(String word) throws InternalErrorException {
        JCRServlets session = null;
        try {
            List<WorkspaceMessage> list;
            session = new JCRServlets(this.workspace.getOwner().getPortalLogin());
            ItemDelegate nodeOutBox = this.workspace.getRepository().getOutBoxFolder(session);
            List<ItemDelegate> iterator = this.getNodeSearched(session, nodeOutBox, word);
            List<WorkspaceMessage> list2 = list = this.getMessagesSearched(iterator, JCRWorkspaceMessage.WorkspaceMessageType.SENT);
            return list2;
        }
        catch (RepositoryException e) {
            logger.error("Error", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.releaseSession();
        }
    }

    private List<WorkspaceMessage> getMessagesSearched(List<ItemDelegate> iterator, JCRWorkspaceMessage.WorkspaceMessageType type) {
        LinkedList<WorkspaceMessage> list = new LinkedList<WorkspaceMessage>();
        for (ItemDelegate node : iterator) {
            try {
                list.add(new JCRWorkspaceMessage(this.workspace, node, type));
            }
            catch (Exception e) {
                try {
                    logger.error("Item " + node.getName() + "unknow");
                }
                catch (Exception e1) {
                    logger.error("Error ", (Throwable)e1);
                }
            }
        }
        return list;
    }

    private List<ItemDelegate> getNodeSearched(JCRServlets session, ItemDelegate searchRoot, String word) throws InternalErrorException {
        List<ItemDelegate> list;
        try {
            String query = "/jcr:root" + searchRoot.getPath() + "//element()[jcr:contains(@hl:subject,'*" + word + "*') or " + "jcr:contains(@hl:body,'*" + word + "*') ] ";
            list = session.searchItems(query, "xpath");
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        return list;
    }
}

