/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.sharing;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.HttpException;
import org.apache.jackrabbit.util.Text;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibary.model.items.type.NodeProperty;
import org.gcube.common.homelibary.model.items.type.WorkspaceItemType;
import org.gcube.common.homelibrary.home.User;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WrongDestinationException;
import org.gcube.common.homelibrary.home.workspace.sharing.WorkspaceMessage;
import org.gcube.common.homelibrary.jcr.JCRUser;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceItem;
import org.gcube.common.homelibrary.jcr.workspace.servlet.JCRServlets;
import org.gcube.common.homelibrary.model.exceptions.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRWorkspaceMessage
implements WorkspaceMessage {
    private static Logger logger = LoggerFactory.getLogger(JCRWorkspaceMessage.class);
    private final JCRWorkspace workspace;
    private List<String> copyAttachmentIds;
    private final WorkspaceMessageType type;
    private ItemDelegate delegate;

    public JCRWorkspaceMessage(JCRWorkspace workspace, ItemDelegate delegate, WorkspaceMessageType type) throws RepositoryException {
        this.delegate = delegate;
        this.type = type;
        this.workspace = workspace;
    }

    public JCRWorkspaceMessage(JCRWorkspace workspace, ItemDelegate node, WorkspaceMessageType type, String messageId, String subject, String body, User sender, List<String> attachmentIds, List<String> addresses, ItemDelegate nodeHiddenFolder) throws RepositoryException, InternalErrorException {
        this.type = type;
        this.workspace = workspace;
        this.delegate = node;
        this.copyAttachmentIds = new ArrayList<String>();
        HashMap<NodeProperty, String> properties = new HashMap<NodeProperty, String>();
        properties.put(NodeProperty.SUBJECT, subject);
        properties.put(NodeProperty.BODY, body);
        properties.put(NodeProperty.READ, new XStream().toXML((Object)false));
        properties.put(NodeProperty.OPEN, new XStream().toXML((Object)false));
        properties.put(NodeProperty.ADDRESSES, new XStream().toXML(addresses));
        properties.put(NodeProperty.ATTACHMENTS, new XStream().toXML(attachmentIds));
        properties.put(NodeProperty.USER_ID, sender.getId());
        HashMap<NodeProperty, String> portalLogin = new HashMap<NodeProperty, String>();
        portalLogin.put(NodeProperty.USER_ID, sender.getId());
        portalLogin.put(NodeProperty.PORTAL_LOGIN, sender.getPortalLogin());
        properties.put(NodeProperty.OWNER, new XStream().toXML(portalLogin));
        node.setProperties(properties);
        LinkedList<User> users = new LinkedList<User>();
        for (String address : addresses) {
            User user = workspace.getHome().getHomeManager().getUser(address);
            if (user == null) continue;
            users.add(user);
        }
        JCRServlets servlets = null;
        try {
            try {
                servlets = new JCRServlets(workspace.getOwner().getPortalLogin());
                this.delegate = servlets.saveItem(node);
                logger.info("attachmentIds.size() " + attachmentIds.size());
                for (String attachmentId : attachmentIds) {
                    ItemDelegate nodeItem = null;
                    try {
                        nodeItem = servlets.getItemById(attachmentId);
                    }
                    catch (ItemNotFoundException e1) {
                        throw new InternalErrorException((Throwable)e1);
                    }
                    JCRWorkspaceItem item = workspace.getWorkspaceItem(nodeItem);
                    if (!item.getType().equals((Object)WorkspaceItemType.FOLDER_ITEM)) continue;
                    logger.info("nodeItem.getName() " + nodeItem.getName());
                    ItemDelegate rootAttachments = servlets.getItemById((String)this.delegate.getProperties().get(NodeProperty.ATTACHMENTS_ID));
                    ItemDelegate newNode = item.internalCopy(servlets, rootAttachments, nodeItem.getName());
                    if (this.type.equals((Object)WorkspaceMessageType.SENT)) {
                        workspace.copyRemoteContent(servlets, newNode, null);
                        logger.info("add new id to copyAttachmentIds " + newNode.getId());
                        this.copyAttachmentIds.add(newNode.getId());
                    } else if (this.type.equals((Object)WorkspaceMessageType.RECEIVED)) {
                        String hardLinkRemotePath = String.valueOf(node.getPath()) + "/" + nodeItem.getName();
                        workspace.setHardLink(newNode, hardLinkRemotePath);
                    }
                    workspace.fireItemSentEvent(item, users);
                }
            }
            catch (ItemAlreadyExistException e) {
                throw new InternalErrorException((Throwable)e);
            }
            catch (WrongDestinationException e) {
                throw new InternalErrorException((Throwable)e);
            }
            catch (ItemNotFoundException e) {
                throw new InternalErrorException((Throwable)e);
            }
            catch (RepositoryException e) {
                throw new InternalErrorException((Throwable)e);
            }
        }
        finally {
            servlets.releaseSession();
        }
    }

    public String getId() {
        return this.delegate.getId();
    }

    public User getSender() {
        Map userNode = (Map)new XStream().fromXML((String)this.delegate.getProperties().get(NodeProperty.OWNER));
        return new JCRUser((String)userNode.get(NodeProperty.USER_ID), (String)userNode.get(NodeProperty.PORTAL_LOGIN));
    }

    public Calendar getSendTime() {
        return this.delegate.getCreationTime();
    }

    public String getSubject() {
        return (String)this.delegate.getProperties().get(NodeProperty.SUBJECT);
    }

    public String getBody() {
        return (String)this.delegate.getProperties().get(NodeProperty.BODY);
    }

    public List<String> getAttachmentsIds() {
        return (List)new XStream().fromXML((String)this.delegate.getProperties().get(NodeProperty.ATTACHMENTS));
    }

    public List<String> getCopyAttachmentsIds() {
        return this.copyAttachmentIds;
    }

    public boolean isRead() {
        return (Boolean)new XStream().fromXML((String)this.delegate.getProperties().get(NodeProperty.READ));
    }

    public List<String> getAddresses() {
        return (List)new XStream().fromXML((String)this.delegate.getProperties().get(NodeProperty.ADDRESSES));
    }

    public boolean isOpened() {
        return (Boolean)new XStream().fromXML((String)this.delegate.getProperties().get(NodeProperty.OPEN));
    }

    public void open() throws InternalErrorException {
        ItemDelegate root = null;
        JCRServlets servlets = null;
        try {
            try {
                servlets = new JCRServlets(this.workspace.getOwner().getPortalLogin());
                switch (this.type) {
                    case RECEIVED: {
                        root = this.workspace.getRepository().getOwnInBoxFolder(servlets);
                        break;
                    }
                    case SENT: {
                        root = this.workspace.getRepository().getOutBoxFolder(servlets);
                    }
                }
                ItemDelegate node = servlets.getItemById(this.getId());
                node.getProperties().put(NodeProperty.OPEN, new XStream().toXML((Object)true));
                servlets.saveItem(node);
            }
            catch (ItemNotFoundException | RepositoryException e) {
                throw new InternalErrorException(e);
            }
        }
        finally {
            servlets.releaseSession();
        }
    }

    public void setStatus(boolean status) throws InternalErrorException {
        JCRServlets servlets = null;
        ItemDelegate root = null;
        try {
            try {
                servlets = new JCRServlets(this.workspace.getOwner().getPortalLogin());
                switch (this.type) {
                    case RECEIVED: {
                        root = this.workspace.getRepository().getOwnInBoxFolder(servlets);
                        break;
                    }
                    case SENT: {
                        root = this.workspace.getRepository().getOutBoxFolder(servlets);
                    }
                }
                ItemDelegate node = servlets.getItemById(this.getId());
                node.getProperties().put(NodeProperty.READ, new XStream().toXML((Object)status));
                servlets.saveItem(node);
                servlets.saveItem(node);
            }
            catch (ItemNotFoundException | RepositoryException e) {
                throw new InternalErrorException(e);
            }
        }
        finally {
            servlets.releaseSession();
        }
    }

    public void saveAttachments(String destinationFolderId) throws InternalErrorException, WrongDestinationException, ItemNotFoundException {
        JCRServlets servlets = null;
        try {
            try {
                WorkspaceFolder folder;
                ItemDelegate folderNode;
                servlets = new JCRServlets(this.workspace.getOwner().getPortalLogin());
                try {
                    folderNode = servlets.getItemById(destinationFolderId);
                    folder = (WorkspaceFolder)this.workspace.getItem(destinationFolderId);
                }
                catch (Exception e) {
                    throw new WrongDestinationException(e.getMessage());
                }
                for (String attachmentId : this.getAttachmentsIds()) {
                    this.saveAttachment(attachmentId, folder, folderNode);
                }
            }
            catch (RepositoryException e1) {
                throw new InternalErrorException(e1.getMessage());
            }
        }
        finally {
            servlets.releaseSession();
        }
    }

    public WorkspaceItem saveAttachment(String attachmentId, String destinationFolderId) throws InternalErrorException, WrongDestinationException, ItemNotFoundException {
        WorkspaceFolder folder;
        ItemDelegate folderNode;
        JCRServlets servlets = null;
        try {
            try {
                servlets = new JCRServlets(this.workspace.getOwner().getPortalLogin());
                folderNode = servlets.getItemById(destinationFolderId);
                folder = (WorkspaceFolder)this.workspace.getItem(destinationFolderId);
            }
            catch (ItemNotFoundException e) {
                throw new WrongDestinationException(e.getMessage());
            }
            catch (RepositoryException e) {
                throw new InternalErrorException(e.getMessage());
            }
        }
        finally {
            servlets.releaseSession();
        }
        return this.saveAttachment(attachmentId, folder, folderNode);
    }

    private WorkspaceItem saveAttachment(String attachmentId, WorkspaceFolder folder, ItemDelegate folderNode) throws ItemNotFoundException, WrongDestinationException, InternalErrorException {
        JCRServlets servlets = null;
        try {
            servlets = new JCRServlets(this.workspace.getOwner().getPortalLogin());
            ItemDelegate attachment = servlets.getItemById(attachmentId);
            String name = folder.getUniqueName(attachment.getTitle(), false);
            String pathDestination = String.valueOf(folderNode.getPath()) + this.workspace.getPathSeparator() + Text.escapeIllegalJcrChars((String)name);
            try {
                servlets.copy(attachment.getPath(), pathDestination);
            }
            catch (HttpException e1) {
                e1.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            ItemDelegate itemSaved = servlets.getItemByPath(pathDestination);
            itemSaved.setOwner(this.workspace.getOwner().getPortalLogin());
            itemSaved.setTitle(name);
            this.workspace.copyRemoteContent(servlets, itemSaved, folderNode);
            servlets.saveItem(itemSaved);
            WorkspaceItem workspaceItem = this.workspace.getItem(itemSaved.getId());
            return workspaceItem;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            servlets.releaseSession();
        }
    }

    public List<WorkspaceItem> getAttachments() throws InternalErrorException {
        LinkedList<WorkspaceItem> list = new LinkedList<WorkspaceItem>();
        try {
            for (String id : this.getAttachmentsIds()) {
                list.add(this.workspace.getItem(id));
            }
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        return list;
    }

    public static enum WorkspaceMessageType {
        RECEIVED,
        SENT;

    }
}

