/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.service.operation;

import java.io.OutputStream;
import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.service.directoryOperation.Encrypter;
import org.gcube.contentmanagement.blobstorage.service.operation.Monitor;
import org.gcube.contentmanagement.blobstorage.service.operation.Operation;
import org.gcube.contentmanagement.blobstorage.transport.TransportManager;
import org.gcube.contentmanagement.blobstorage.transport.TransportManagerFactory;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;

public class GetUrl
extends Operation {
    private OutputStream os;
    TransportManager tm;
    public static final String URL_SEPARATOR = "/";

    public GetUrl(String[] server, String user, String pwd, String bucket, Monitor monitor, boolean isChunk, String backendType) {
        super(server, user, pwd, bucket, monitor, isChunk, backendType);
    }

    @Override
    public String initOperation(MyFile file, String remotePath, String author, String[] server, String rootArea, boolean replaceOption) {
        return this.getRemoteIdentifier(remotePath, rootArea);
    }

    @Override
    public String initOperation(MyFile resource, String RemotePath, String author, String[] server, String rootArea) {
        return null;
    }

    @Override
    public Object doIt(MyFile myFile) throws RemoteBackendException {
        String resolverHost = myFile.getResolverHOst();
        String urlBase = "smp://" + resolverHost + URL_SEPARATOR;
        String urlParam = "";
        try {
            String id = this.getId(myFile.getAbsoluteRemotePath(), myFile.isForceCreation());
            urlParam = new Encrypter("DES").encrypt(id);
        }
        catch (Encrypter.EncryptionException e) {
            throw new RemoteBackendException(" Error in getUrl operation problem to encrypt the string", e.getCause());
        }
        this.logger.info("URL generated: " + urlBase + urlParam);
        return urlBase + urlParam;
    }

    private String getId(String path, boolean forceCreation) {
        String id = null;
        if (this.tm == null) {
            TransportManagerFactory tmf = new TransportManagerFactory(this.server, this.user, this.password);
            this.tm = tmf.getTransport(this.backendType);
        }
        try {
            id = this.tm.getId(this.bucket, forceCreation);
        }
        catch (Exception e) {
            throw new RemoteBackendException(" Error in GetUrl operation. Problem to discover remote file:" + this.bucket + " ", e.getCause());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" PATH " + this.bucket);
        }
        return id;
    }
}

