/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.xml.dom4j.converter;

import java.io.IOException;
import java.io.Writer;
import org.compass.core.CompassException;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassSettings;
import org.compass.core.converter.ConversionException;
import org.compass.core.converter.xsem.XmlContentConverter;
import org.compass.core.util.StringBuilderWriter;
import org.compass.core.xml.XmlObject;
import org.compass.core.xml.dom4j.Dom4jXmlObject;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public abstract class AbstractXmlWriterXmlContentConverter
implements XmlContentConverter,
CompassConfigurable {
    private boolean compact;

    public void configure(CompassSettings settings) throws CompassException {
        String outputFormat = settings.getGloablSettings().getSetting("compass.xsem.contentConverter.dom4j.outputFormat", "default");
        if ("default".equals(outputFormat)) {
            this.compact = false;
        } else if ("compact".equals(outputFormat)) {
            this.compact = true;
        }
    }

    public String toXml(XmlObject xmlObject) throws ConversionException {
        Dom4jXmlObject dom4jXmlObject = (Dom4jXmlObject)xmlObject;
        StringBuilderWriter stringWriter = StringBuilderWriter.Cached.cached();
        OutputFormat outputFormat = null;
        if (this.compact) {
            outputFormat = OutputFormat.createCompactFormat();
        }
        XMLWriter xmlWriter = outputFormat != null ? new XMLWriter((Writer)stringWriter, outputFormat) : new XMLWriter((Writer)stringWriter);
        try {
            xmlWriter.write(dom4jXmlObject.getNode());
            xmlWriter.close();
        }
        catch (IOException e) {
            throw new ConversionException("This should not happen", e);
        }
        return stringWriter.toString();
    }
}

