/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.mapping.osem;

import java.util.HashMap;
import org.compass.core.CompassException;
import org.compass.core.mapping.Cascade;
import org.compass.core.mapping.internal.InternalCascadeMapping;
import org.compass.core.mapping.osem.AbstractAccessorMapping;
import org.compass.core.mapping.osem.ClassMapping;
import org.compass.core.mapping.osem.internal.InternalRefAliasObjectMapping;

public abstract class AbstractRefAliasMapping
extends AbstractAccessorMapping
implements InternalRefAliasObjectMapping,
InternalCascadeMapping {
    private String[] refAliases;
    private ClassMapping[] refClassMappings;
    private Class refClass;
    private HashMap<String, ClassMapping> refAliasesMap = new HashMap();
    private Cascade[] cascades;
    private Boolean shouldCascadeDelete;
    private Boolean shouldCascadeCreate;
    private Boolean shouldCascadeSave;

    protected void copy(AbstractRefAliasMapping mapping) {
        super.copy(mapping);
        mapping.setCascades(this.cascades);
        if (this.refAliases != null) {
            String[] copyRefAliases = new String[this.refAliases.length];
            System.arraycopy(this.refAliases, 0, copyRefAliases, 0, this.refAliases.length);
            mapping.setRefAliases(copyRefAliases);
        }
        mapping.setRefClass(this.getRefClass());
        if (this.refClassMappings != null) {
            ClassMapping[] copyRefClassMappings = new ClassMapping[this.refClassMappings.length];
            System.arraycopy(this.refClassMappings, 0, copyRefClassMappings, 0, this.refClassMappings.length);
            mapping.setRefClassMappings(copyRefClassMappings);
        }
    }

    public boolean hasRefAlias(String refAlias) {
        return this.refAliasesMap.get(refAlias) != null;
    }

    public boolean hasAtLeastOneRefAlias(String[] refAliases) {
        if (refAliases == null) {
            return false;
        }
        for (String refAlias : refAliases) {
            if (!this.hasRefAlias(refAlias)) continue;
            return true;
        }
        return false;
    }

    public ClassMapping getRefClassMapping(String alias) {
        return this.refAliasesMap.get(alias);
    }

    public String[] getRefAliases() {
        return this.refAliases;
    }

    public void setRefAliases(String[] refAliases) {
        this.refAliases = refAliases;
    }

    public ClassMapping[] getRefClassMappings() {
        return this.refClassMappings;
    }

    public void setRefClassMappings(ClassMapping[] refClassMappings) {
        this.refClassMappings = refClassMappings;
        if (refClassMappings != null) {
            for (ClassMapping refClassMapping : refClassMappings) {
                this.refAliasesMap.put(refClassMapping.getAlias(), refClassMapping);
            }
        }
    }

    public Class getRefClass() {
        return this.refClass;
    }

    public void setRefClass(Class refClass) {
        this.refClass = refClass;
    }

    public Cascade[] getCascades() {
        return this.cascades;
    }

    public void setCascades(Cascade[] cascades) {
        this.cascades = cascades;
    }

    public Object getCascadeValue(Object root) throws CompassException {
        return this.getGetter().get(root);
    }

    public boolean shouldCascadeDelete() {
        if (this.cascades == null) {
            return false;
        }
        if (this.shouldCascadeDelete != null) {
            return this.shouldCascadeDelete;
        }
        for (Cascade cascade : this.cascades) {
            if (cascade != Cascade.DELETE && cascade != Cascade.ALL) continue;
            this.shouldCascadeDelete = Boolean.TRUE;
        }
        if (this.shouldCascadeDelete == null) {
            this.shouldCascadeDelete = Boolean.FALSE;
        }
        return this.shouldCascadeDelete;
    }

    public boolean shouldCascadeCreate() {
        if (this.cascades == null) {
            return false;
        }
        if (this.shouldCascadeCreate != null) {
            return this.shouldCascadeCreate;
        }
        for (Cascade cascade : this.cascades) {
            if (cascade != Cascade.CREATE && cascade != Cascade.ALL) continue;
            this.shouldCascadeCreate = Boolean.TRUE;
        }
        if (this.shouldCascadeCreate == null) {
            this.shouldCascadeCreate = Boolean.FALSE;
        }
        return this.shouldCascadeCreate;
    }

    public boolean shouldCascadeSave() {
        if (this.cascades == null) {
            return false;
        }
        if (this.shouldCascadeSave != null) {
            return this.shouldCascadeSave;
        }
        for (Cascade cascade : this.cascades) {
            if (cascade != Cascade.SAVE && cascade != Cascade.ALL) continue;
            this.shouldCascadeSave = Boolean.TRUE;
        }
        if (this.shouldCascadeSave == null) {
            this.shouldCascadeSave = Boolean.FALSE;
        }
        return this.shouldCascadeSave;
    }

    public boolean shouldCascade(Cascade cascade) {
        if (this.cascades == null || this.cascades.length == 0) {
            return false;
        }
        if (cascade == Cascade.ALL) {
            return true;
        }
        if (cascade == Cascade.CREATE) {
            return this.shouldCascadeCreate();
        }
        if (cascade == Cascade.SAVE) {
            return this.shouldCascadeSave();
        }
        if (cascade == Cascade.DELETE) {
            return this.shouldCascadeDelete();
        }
        throw new IllegalArgumentException("Should cascade can't handle [" + (Object)((Object)cascade) + "]");
    }
}

