/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.transaction.mt;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.compass.core.config.SearchEngineFactoryAware;
import org.compass.core.engine.SearchEngineFactory;
import org.compass.core.lucene.engine.LuceneSearchEngine;
import org.compass.core.lucene.engine.transaction.TransactionProcessor;
import org.compass.core.lucene.engine.transaction.TransactionProcessorFactory;
import org.compass.core.lucene.engine.transaction.mt.MTTransactionProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MTTransactionProcessorFactory
implements TransactionProcessorFactory,
SearchEngineFactoryAware {
    private Map<String, Lock> subIndexOpenWritersLocks = new HashMap<String, Lock>();

    @Override
    public void setSearchEngineFactory(SearchEngineFactory searchEngineFactory) {
        for (String subIndex : searchEngineFactory.getIndexManager().getSubIndexes()) {
            this.subIndexOpenWritersLocks.put(subIndex, new ReentrantLock());
        }
    }

    @Override
    public TransactionProcessor create(LuceneSearchEngine searchEngine) {
        return new MTTransactionProcessor(this, searchEngine);
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isThreadSafe() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T doUnderIndexWriterLock(String subIndex, Callable<T> task) throws Exception {
        Lock lock = this.subIndexOpenWritersLocks.get(subIndex);
        lock.lock();
        try {
            T t = task.call();
            return t;
        }
        finally {
            lock.unlock();
        }
    }
}

