/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.converter.basic.format;

public class NumberUtils {
    public static String int2sortableStr(int val) {
        char[] arr = new char[3];
        NumberUtils.int2sortableStr(val, arr, 0);
        return new String(arr, 0, 3);
    }

    public static String int2sortableStr(String val) {
        return NumberUtils.int2sortableStr(Integer.parseInt(val));
    }

    public static int SortableStr2int(String val) {
        return NumberUtils.SortableStr2int(val, 0, 3);
    }

    public static String long2sortableStr(long val) {
        char[] arr = new char[5];
        NumberUtils.long2sortableStr(val, arr, 0);
        return new String(arr, 0, 5);
    }

    public static String long2sortableStr(String val) {
        return NumberUtils.long2sortableStr(Long.parseLong(val));
    }

    public static long SortableStr2long(String val) {
        return NumberUtils.SortableStr2long(val, 0, 5);
    }

    public static String float2sortableStr(float val) {
        int f = Float.floatToRawIntBits(val);
        if (f < 0) {
            f ^= Integer.MAX_VALUE;
        }
        return NumberUtils.int2sortableStr(f);
    }

    public static String float2sortableStr(String val) {
        return NumberUtils.float2sortableStr(Float.parseFloat(val));
    }

    public static float SortableStr2float(String val) {
        int f = NumberUtils.SortableStr2int(val, 0, 3);
        if (f < 0) {
            f ^= Integer.MAX_VALUE;
        }
        return Float.intBitsToFloat(f);
    }

    public static String SortableStr2floatStr(String val) {
        return Float.toString(NumberUtils.SortableStr2float(val));
    }

    public static String double2sortableStr(double val) {
        long f = Double.doubleToRawLongBits(val);
        if (f < 0L) {
            f ^= Long.MAX_VALUE;
        }
        return NumberUtils.long2sortableStr(f);
    }

    public static String double2sortableStr(String val) {
        return NumberUtils.double2sortableStr(Double.parseDouble(val));
    }

    public static double SortableStr2double(String val) {
        long f = NumberUtils.SortableStr2long(val, 0, 6);
        if (f < 0L) {
            f ^= Long.MAX_VALUE;
        }
        return Double.longBitsToDouble(f);
    }

    public static String SortableStr2doubleStr(String val) {
        return Double.toString(NumberUtils.SortableStr2double(val));
    }

    public static int int2sortableStr(int val, char[] out, int offset) {
        out[offset++] = (char)((val -= Integer.MIN_VALUE) >>> 24);
        out[offset++] = (char)(val >>> 12 & 0xFFF);
        out[offset++] = (char)(val & 0xFFF);
        return 3;
    }

    public static int SortableStr2int(String sval, int offset, int len) {
        int val = sval.charAt(offset++) << 24;
        val |= sval.charAt(offset++) << 12;
        val |= sval.charAt(offset++);
        return val -= Integer.MIN_VALUE;
    }

    public static int long2sortableStr(long val, char[] out, int offset) {
        out[offset++] = (char)((val += Long.MIN_VALUE) >>> 60);
        out[offset++] = (char)(val >>> 45 & 0x7FFFL);
        out[offset++] = (char)(val >>> 30 & 0x7FFFL);
        out[offset++] = (char)(val >>> 15 & 0x7FFFL);
        out[offset] = (char)(val & 0x7FFFL);
        return 5;
    }

    public static long SortableStr2long(String sval, int offset, int len) {
        long val = (long)sval.charAt(offset++) << 60;
        val |= (long)sval.charAt(offset++) << 45;
        val |= (long)sval.charAt(offset++) << 30;
        val |= (long)(sval.charAt(offset++) << 15);
        val |= (long)sval.charAt(offset);
        return val -= Long.MIN_VALUE;
    }
}

