/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store.wrapper;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.store.RAMOutputStream;
import org.compass.core.util.concurrent.NamedThreadFactory;

public class AsyncMemoryMirrorDirectoryWrapper
extends Directory {
    private static final Log log = LogFactory.getLog(AsyncMemoryMirrorDirectoryWrapper.class);
    private Directory dir;
    private RAMDirectory ramDir;
    private ExecutorService executorService;
    private long awaitTermination;

    public AsyncMemoryMirrorDirectoryWrapper(Directory dir) throws IOException {
        this(dir, 2L);
    }

    public AsyncMemoryMirrorDirectoryWrapper(Directory dir, long awaitTermination) throws IOException {
        this(dir, awaitTermination, Executors.newSingleThreadExecutor(new NamedThreadFactory("AsyncMirror[" + dir + "]", false)));
    }

    public AsyncMemoryMirrorDirectoryWrapper(Directory dir, long awaitTermination, ExecutorService executorService) throws IOException {
        this.dir = dir;
        this.ramDir = new RAMDirectory(dir);
        this.executorService = executorService;
        this.awaitTermination = awaitTermination;
    }

    public void deleteFile(final String name) throws IOException {
        this.ramDir.deleteFile(name);
        this.executorService.submit(new Runnable(){

            public void run() {
                try {
                    AsyncMemoryMirrorDirectoryWrapper.this.dir.deleteFile(name);
                }
                catch (IOException e) {
                    AsyncMemoryMirrorDirectoryWrapper.this.logAsyncErrorMessage("delete [" + name + "]");
                }
            }
        });
    }

    public boolean fileExists(String name) throws IOException {
        return this.ramDir.fileExists(name);
    }

    public long fileLength(String name) throws IOException {
        return this.ramDir.fileLength(name);
    }

    public long fileModified(String name) throws IOException {
        return this.ramDir.fileModified(name);
    }

    public String[] list() throws IOException {
        return this.ramDir.list();
    }

    public void renameFile(final String from, final String to) throws IOException {
        this.ramDir.renameFile(from, to);
        this.executorService.submit(new Runnable(){

            public void run() {
                try {
                    AsyncMemoryMirrorDirectoryWrapper.this.dir.renameFile(from, to);
                }
                catch (IOException e) {
                    AsyncMemoryMirrorDirectoryWrapper.this.logAsyncErrorMessage("rename from[" + from + "] to[" + to + "]");
                }
            }
        });
    }

    public void touchFile(final String name) throws IOException {
        this.ramDir.touchFile(name);
        this.executorService.submit(new Runnable(){

            public void run() {
                try {
                    AsyncMemoryMirrorDirectoryWrapper.this.dir.touchFile(name);
                }
                catch (IOException e) {
                    AsyncMemoryMirrorDirectoryWrapper.this.logAsyncErrorMessage("touch [" + name + "]");
                }
            }
        });
    }

    public Lock makeLock(String name) {
        return this.ramDir.makeLock(name);
    }

    public void close() throws IOException {
        this.ramDir.close();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Directory [" + this.dir + "] shutsdown, waiting for [" + this.awaitTermination + "] minutes for tasks to finish executing"));
        }
        this.executorService.shutdown();
        if (!this.executorService.isTerminated()) {
            try {
                if (!this.executorService.awaitTermination(60L * this.awaitTermination, TimeUnit.SECONDS)) {
                    this.logAsyncErrorMessage("wait for async tasks to shutdown");
                }
            }
            catch (InterruptedException e) {
                this.logAsyncErrorMessage("wait for async tasks to shutdown");
            }
        }
        this.dir.close();
    }

    public IndexInput openInput(String name) throws IOException {
        return this.ramDir.openInput(name);
    }

    public IndexOutput createOutput(String name) throws IOException {
        return new AsyncMemoryMirrorIndexOutput(name, (RAMOutputStream)this.ramDir.createOutput(name));
    }

    private void logAsyncErrorMessage(String message) {
        log.error((Object)("Async wrapper for [" + this.dir + "] failed to " + message));
    }

    public class AsyncMemoryMirrorIndexOutput
    extends IndexOutput {
        private String name;
        private RAMOutputStream ramIndexOutput;

        public AsyncMemoryMirrorIndexOutput(String name, RAMOutputStream ramIndexOutput) {
            this.name = name;
            this.ramIndexOutput = ramIndexOutput;
        }

        public void writeByte(byte b) throws IOException {
            this.ramIndexOutput.writeByte(b);
        }

        public void writeBytes(byte[] b, int offset, int length) throws IOException {
            this.ramIndexOutput.writeBytes(b, offset, length);
        }

        public void seek(long size) throws IOException {
            this.ramIndexOutput.seek(size);
        }

        public long length() throws IOException {
            return this.ramIndexOutput.length();
        }

        public long getFilePointer() {
            return this.ramIndexOutput.getFilePointer();
        }

        public void flush() throws IOException {
            this.ramIndexOutput.flush();
        }

        public void close() throws IOException {
            this.ramIndexOutput.close();
            AsyncMemoryMirrorDirectoryWrapper.this.executorService.submit(new Runnable(){

                public void run() {
                    try {
                        IndexOutput indexOutput = AsyncMemoryMirrorDirectoryWrapper.this.dir.createOutput(AsyncMemoryMirrorIndexOutput.this.name);
                        AsyncMemoryMirrorIndexOutput.this.ramIndexOutput.writeTo(indexOutput);
                        indexOutput.close();
                    }
                    catch (IOException e) {
                        AsyncMemoryMirrorDirectoryWrapper.this.logAsyncErrorMessage("write [" + AsyncMemoryMirrorIndexOutput.this.name + "]");
                    }
                }
            });
        }
    }
}

