/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ibm.icu.impl;

import com.liferay.ibm.icu.impl.ICUCache;
import com.liferay.ibm.icu.impl.ICUDebug;
import com.liferay.ibm.icu.impl.ICUResourceBundleImpl;
import com.liferay.ibm.icu.impl.ICUResourceBundleReader;
import com.liferay.ibm.icu.impl.SimpleCache;
import com.liferay.ibm.icu.impl.URLHandler;
import com.liferay.ibm.icu.impl.Utility;
import com.liferay.ibm.icu.util.StringTokenizer;
import com.liferay.ibm.icu.util.ULocale;
import com.liferay.ibm.icu.util.UResourceBundle;
import com.liferay.ibm.icu.util.UResourceBundleIterator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;

public class ICUResourceBundle
extends UResourceBundle {
    protected static final String ICU_DATA_PATH = "com/liferay/ibm/icu/impl/";
    public static final String ICU_BUNDLE = "data/icudt40b";
    public static final String ICU_BASE_NAME = "com/liferay/ibm/icu/impl/data/icudt40b";
    public static final String ICU_COLLATION_BASE_NAME = "com/liferay/ibm/icu/impl/data/icudt40b/coll";
    public static final String ICU_BRKITR_NAME = "/brkitr";
    public static final String ICU_BRKITR_BASE_NAME = "com/liferay/ibm/icu/impl/data/icudt40b/brkitr";
    public static final String ICU_RBNF_BASE_NAME = "com/liferay/ibm/icu/impl/data/icudt40b/rbnf";
    public static final String ICU_TRANSLIT_BASE_NAME = "com/liferay/ibm/icu/impl/data/icudt40b/translit";
    protected String resPath;
    protected static final long UNSIGNED_INT_MASK = 0xFFFFFFFFL;
    public static final ClassLoader ICU_DATA_CLASS_LOADER;
    protected static final String INSTALLED_LOCALES = "InstalledLocales";
    public static final int FROM_FALLBACK = 1;
    public static final int FROM_ROOT = 2;
    public static final int FROM_DEFAULT = 3;
    public static final int FROM_LOCALE = 4;
    private int loadingStatus = -1;
    private static final String ICU_RESOURCE_INDEX = "res_index";
    private static final String DEFAULT_TAG = "default";
    private static final boolean DEBUG;
    private static SoftReference GET_AVAILABLE_CACHE;
    protected byte[] rawData;
    protected long rootResource;
    protected boolean noFallback;
    protected String localeID;
    protected String baseName;
    protected ULocale ulocale;
    protected ClassLoader loader;
    private static final char RES_PATH_SEP_CHAR = '/';
    private static final String RES_PATH_SEP_STR = "/";
    private static final String ICUDATA = "ICUDATA";
    private static final char HYPHEN = '-';
    private static final String LOCALE = "LOCALE";
    protected ICUCache lookup;
    private static final int MAX_INITIAL_LOOKUP_SIZE = 64;
    static /* synthetic */ Class class$com$liferay$ibm$icu$impl$ICUData;

    public void setLoadingStatus(int newStatus) {
        this.loadingStatus = newStatus;
    }

    public int getLoadingStatus() {
        return this.loadingStatus;
    }

    public void setLoadingStatus(String requestedLocale) {
        String locale = this.getLocaleID();
        if (locale.equals("root")) {
            this.setLoadingStatus(2);
        } else if (locale.equals(requestedLocale)) {
            this.setLoadingStatus(4);
        } else {
            this.setLoadingStatus(1);
        }
    }

    public String getResPath() {
        return this.resPath;
    }

    public static final ULocale getFunctionalEquivalent(String baseName, String resName, String keyword, ULocale locID, boolean[] isAvailable, boolean omitDefault) {
        ICUResourceBundle irb;
        String kwVal = locID.getKeywordValue(keyword);
        String baseLoc = locID.getBaseName();
        String defStr = null;
        ULocale parent = new ULocale(baseLoc);
        ULocale defLoc = null;
        boolean lookForDefault = false;
        ULocale fullBase = null;
        int defDepth = 0;
        int resDepth = 0;
        if (kwVal == null || kwVal.length() == 0 || kwVal.equals(DEFAULT_TAG)) {
            kwVal = "";
            lookForDefault = true;
        }
        ICUResourceBundle r = null;
        r = (ICUResourceBundle)UResourceBundle.getBundleInstance(baseName, parent);
        if (isAvailable != null) {
            isAvailable[0] = false;
            ULocale[] availableULocales = ICUResourceBundle.getAvailEntry(baseName).getULocaleList();
            for (int i = 0; i < availableULocales.length; ++i) {
                if (!parent.equals(availableULocales[i])) continue;
                isAvailable[0] = true;
                break;
            }
        }
        do {
            try {
                irb = (ICUResourceBundle)r.get(resName);
                defStr = irb.getString(DEFAULT_TAG);
                if (lookForDefault) {
                    kwVal = defStr;
                    lookForDefault = false;
                }
                defLoc = r.getULocale();
            }
            catch (MissingResourceException t) {
                // empty catch block
            }
            if (defLoc != null) continue;
            r = (ICUResourceBundle)r.getParent();
            ++defDepth;
        } while (r != null && defLoc == null);
        parent = new ULocale(baseLoc);
        r = (ICUResourceBundle)UResourceBundle.getBundleInstance(baseName, parent);
        do {
            try {
                irb = (ICUResourceBundle)r.get(resName);
                irb.get(kwVal);
                fullBase = irb.getULocale();
                if (fullBase != null && resDepth > defDepth) {
                    defStr = irb.getString(DEFAULT_TAG);
                    defLoc = r.getULocale();
                    defDepth = resDepth;
                }
            }
            catch (MissingResourceException t) {
                // empty catch block
            }
            if (fullBase != null) continue;
            r = (ICUResourceBundle)r.getParent();
            ++resDepth;
        } while (r != null && fullBase == null);
        if (fullBase == null && defStr != null && !defStr.equals(kwVal)) {
            kwVal = defStr;
            parent = new ULocale(baseLoc);
            r = (ICUResourceBundle)UResourceBundle.getBundleInstance(baseName, parent);
            resDepth = 0;
            do {
                try {
                    irb = (ICUResourceBundle)r.get(resName);
                    UResourceBundle urb = irb.get(kwVal);
                    fullBase = r.getULocale();
                    if (!fullBase.toString().equals(urb.getLocale().toString())) {
                        fullBase = null;
                    }
                    if (fullBase != null && resDepth > defDepth) {
                        defStr = irb.getString(DEFAULT_TAG);
                        defLoc = r.getULocale();
                        defDepth = resDepth;
                    }
                }
                catch (MissingResourceException t) {
                    // empty catch block
                }
                if (fullBase != null) continue;
                r = (ICUResourceBundle)r.getParent();
                ++resDepth;
            } while (r != null && fullBase == null);
        }
        if (fullBase == null) {
            throw new MissingResourceException("Could not find locale containing requested or default keyword.", baseName, keyword + "=" + kwVal);
        }
        if (omitDefault && defStr.equals(kwVal) && resDepth <= defDepth) {
            return fullBase;
        }
        return new ULocale(fullBase.toString() + "@" + keyword + "=" + kwVal);
    }

    public static final String[] getKeywordValues(String baseName, String keyword) {
        HashSet keywords = new HashSet();
        ULocale[] locales = ICUResourceBundle.createULocaleList(baseName, ICU_DATA_CLASS_LOADER);
        for (int i = 0; i < locales.length; ++i) {
            try {
                UResourceBundle b = UResourceBundle.getBundleInstance(baseName, locales[i]);
                ICUResourceBundle irb = (ICUResourceBundle)b.getObject(keyword);
                Enumeration e = irb.getKeys();
                while (e.hasMoreElements()) {
                    Object s = e.nextElement();
                    if (!(s instanceof String) || DEFAULT_TAG.equals(s)) continue;
                    keywords.add(s);
                }
                continue;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return keywords.toArray(new String[0]);
    }

    public ICUResourceBundle getWithFallback(String path) throws MissingResourceException {
        ICUResourceBundle result = null;
        ICUResourceBundle actualBundle = this;
        result = ICUResourceBundle.findResourceWithFallback(path, actualBundle, null);
        if (result == null) {
            throw new MissingResourceException("Can't find resource for bundle " + this.getClass().getName() + ", key " + this.getType(), path, this.getKey());
        }
        return result;
    }

    public String getStringWithFallback(String path) throws MissingResourceException {
        return this.getWithFallback(path).getString();
    }

    public static Set getAvailableLocaleNameSet(String bundlePrefix) {
        return ICUResourceBundle.getAvailEntry(bundlePrefix).getLocaleNameSet();
    }

    public static Set getFullLocaleNameSet() {
        return ICUResourceBundle.getFullLocaleNameSet(ICU_BASE_NAME);
    }

    public static Set getFullLocaleNameSet(String bundlePrefix) {
        return ICUResourceBundle.getAvailEntry(bundlePrefix).getFullLocaleNameSet();
    }

    public static Set getAvailableLocaleNameSet() {
        return ICUResourceBundle.getAvailableLocaleNameSet(ICU_BASE_NAME);
    }

    public static final ULocale[] getAvailableULocales(String baseName) {
        return ICUResourceBundle.getAvailEntry(baseName).getULocaleList();
    }

    public static final ULocale[] getAvailableULocales() {
        return ICUResourceBundle.getAvailableULocales(ICU_BASE_NAME);
    }

    public static final Locale[] getAvailableLocales(String baseName) {
        return ICUResourceBundle.getAvailEntry(baseName).getLocaleList();
    }

    public static final Locale[] getAvailableLocales() {
        return ICUResourceBundle.getAvailEntry(ICU_BASE_NAME).getLocaleList();
    }

    public static final Locale[] getLocaleList(ULocale[] ulocales) {
        ArrayList<Locale> list = new ArrayList<Locale>();
        HashSet<Locale> uniqueSet = new HashSet<Locale>();
        for (int i = 0; i < ulocales.length; ++i) {
            Locale loc = ulocales[i].toLocale();
            if (uniqueSet.contains(loc)) continue;
            list.add(loc);
            uniqueSet.add(loc);
        }
        return list.toArray(new Locale[list.size()]);
    }

    public Locale getLocale() {
        return this.getULocale().toLocale();
    }

    private static final ULocale[] createULocaleList(String baseName, ClassLoader root) {
        ICUResourceBundle bundle = (ICUResourceBundle)UResourceBundle.instantiateBundle(baseName, ICU_RESOURCE_INDEX, root, true);
        bundle = (ICUResourceBundle)bundle.get(INSTALLED_LOCALES);
        int length = bundle.getSize();
        int i = 0;
        ULocale[] locales = new ULocale[length];
        UResourceBundleIterator iter = bundle.getIterator();
        iter.reset();
        while (iter.hasNext()) {
            locales[i++] = new ULocale(iter.next().getKey());
        }
        bundle = null;
        return locales;
    }

    private static final Locale[] createLocaleList(String baseName) {
        ULocale[] ulocales = ICUResourceBundle.getAvailEntry(baseName).getULocaleList();
        return ICUResourceBundle.getLocaleList(ulocales);
    }

    private static final String[] createLocaleNameArray(String baseName, ClassLoader root) {
        ICUResourceBundle bundle = (ICUResourceBundle)UResourceBundle.instantiateBundle(baseName, ICU_RESOURCE_INDEX, root, true);
        bundle = (ICUResourceBundle)bundle.get(INSTALLED_LOCALES);
        int length = bundle.getSize();
        int i = 0;
        String[] locales = new String[length];
        UResourceBundleIterator iter = bundle.getIterator();
        iter.reset();
        while (iter.hasNext()) {
            locales[i++] = iter.next().getKey();
        }
        bundle = null;
        return locales;
    }

    private static final ArrayList createFullLocaleNameArray(final String baseName, final ClassLoader root) {
        ArrayList list = (ArrayList)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String bn = baseName.endsWith(ICUResourceBundle.RES_PATH_SEP_STR) ? baseName : baseName + ICUResourceBundle.RES_PATH_SEP_STR;
                try {
                    InputStream s = root.getResourceAsStream(bn + ICUResourceBundle.ICU_RESOURCE_INDEX + ".txt");
                    if (s != null) {
                        String line;
                        ArrayList<String> lst = new ArrayList<String>();
                        BufferedReader br = new BufferedReader(new InputStreamReader(s, "ASCII"));
                        while ((line = br.readLine()) != null) {
                            if (line.length() == 0 || line.startsWith("#")) continue;
                            lst.add(line);
                        }
                        return lst;
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
                URL url = root.getResource(bn);
                URLHandler handler = URLHandler.get(url);
                if (handler != null) {
                    final ArrayList lst = new ArrayList();
                    URLHandler.URLVisitor v = new URLHandler.URLVisitor(){

                        public void visit(String s) {
                            if (s.endsWith(".res") && !"res_index.res".equals(s)) {
                                lst.add(s.substring(0, s.length() - 4));
                            }
                        }
                    };
                    handler.guide(v, false);
                    return lst;
                }
                return null;
            }
        });
        return list;
    }

    private static Set createFullLocaleNameSet(String baseName) {
        ArrayList list = ICUResourceBundle.createFullLocaleNameArray(baseName, ICU_DATA_CLASS_LOADER);
        HashSet set = new HashSet();
        if (list == null) {
            throw new MissingResourceException("Could not find res_index", "", "");
        }
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    private static Set createLocaleNameSet(String baseName) {
        try {
            String[] locales = ICUResourceBundle.createLocaleNameArray(baseName, ICU_DATA_CLASS_LOADER);
            HashSet<String> set = new HashSet<String>();
            set.addAll(Arrays.asList(locales));
            return Collections.unmodifiableSet(set);
        }
        catch (MissingResourceException e) {
            if (DEBUG) {
                System.out.println("couldn't find index for bundleName: " + baseName);
                Thread.dumpStack();
            }
            return Collections.EMPTY_SET;
        }
    }

    private static AvailEntry getAvailEntry(String key) {
        AvailEntry ae = null;
        HashMap<String, AvailEntry> lcache = null;
        if (GET_AVAILABLE_CACHE != null && (lcache = (HashMap<String, AvailEntry>)GET_AVAILABLE_CACHE.get()) != null) {
            ae = (AvailEntry)lcache.get(key);
        }
        if (ae == null) {
            ae = new AvailEntry(key);
            if (lcache == null) {
                lcache = new HashMap<String, AvailEntry>();
                lcache.put(key, ae);
                GET_AVAILABLE_CACHE = new SoftReference(lcache);
            } else {
                lcache.put(key, ae);
            }
        }
        return ae;
    }

    protected static final ICUResourceBundle findResourceWithFallback(String path, UResourceBundle actualBundle, UResourceBundle requested) {
        ICUResourceBundle sub = null;
        if (requested == null) {
            requested = actualBundle;
        }
        while (actualBundle != null) {
            String subKey;
            StringTokenizer st = new StringTokenizer(path, RES_PATH_SEP_STR);
            ICUResourceBundle current = (ICUResourceBundle)actualBundle;
            while (st.hasMoreTokens() && (sub = (ICUResourceBundle)current.handleGet(subKey = st.nextToken(), null, requested)) != null) {
                current = sub;
            }
            if (sub != null) break;
            if (((ICUResourceBundle)actualBundle).resPath.length() != 0) {
                path = ((ICUResourceBundle)actualBundle).resPath + RES_PATH_SEP_STR + path;
            }
            actualBundle = ((ICUResourceBundle)actualBundle).getParent();
        }
        if (sub != null) {
            sub.setLoadingStatus(((ICUResourceBundle)requested).getLocaleID());
        }
        return sub;
    }

    public boolean equals(Object other) {
        if (other instanceof ICUResourceBundle) {
            ICUResourceBundle o = (ICUResourceBundle)other;
            if (this.getBaseName().equals(o.getBaseName()) && this.getLocaleID().equals(o.getLocaleID())) {
                return true;
            }
        }
        return false;
    }

    public static UResourceBundle getBundleInstance(String baseName, String localeID, ClassLoader root, boolean disableFallback) {
        UResourceBundle b = ICUResourceBundle.instantiateBundle(baseName, localeID, root, disableFallback);
        if (b == null) {
            throw new MissingResourceException("Could not find the bundle " + baseName + RES_PATH_SEP_STR + localeID + ".res", "", "");
        }
        return b;
    }

    protected static synchronized UResourceBundle instantiateBundle(String baseName, String localeID, ClassLoader root, boolean disableFallback) {
        ULocale defaultLocale = ULocale.getDefault();
        String localeName = localeID;
        if (localeName.indexOf(64) > 0) {
            localeName = ULocale.getBaseName(localeID);
        }
        String fullName = ICUResourceBundleReader.getFullName(baseName, localeName);
        ICUResourceBundle b = (ICUResourceBundle)ICUResourceBundle.loadFromCache(root, fullName, defaultLocale);
        String rootLocale = baseName.indexOf(46) == -1 ? "root" : "";
        String defaultID = ULocale.getDefault().toString();
        if (localeName.equals("")) {
            localeName = rootLocale;
        }
        if (DEBUG) {
            System.out.println("Creating " + fullName + " currently b is " + b);
        }
        if (b == null) {
            b = ICUResourceBundle.createBundle(baseName, localeName, root);
            if (DEBUG) {
                System.out.println("The bundle created is: " + b + " and disableFallback=" + disableFallback + " and bundle.getNoFallback=" + (b != null && b.getNoFallback()));
            }
            if (disableFallback || b != null && b.getNoFallback()) {
                ICUResourceBundle.addToCache(root, fullName, defaultLocale, b);
                return b;
            }
            if (b == null) {
                int i = localeName.lastIndexOf(95);
                if (i != -1) {
                    String temp = localeName.substring(0, i);
                    b = (ICUResourceBundle)ICUResourceBundle.instantiateBundle(baseName, temp, root, disableFallback);
                    if (b != null && b.getULocale().equals(temp)) {
                        b.setLoadingStatus(1);
                    }
                } else if (defaultID.indexOf(localeName) == -1) {
                    b = (ICUResourceBundle)ICUResourceBundle.instantiateBundle(baseName, defaultID, root, disableFallback);
                    if (b != null) {
                        b.setLoadingStatus(3);
                    }
                } else if (rootLocale.length() != 0 && (b = ICUResourceBundle.createBundle(baseName, rootLocale, root)) != null) {
                    b.setLoadingStatus(2);
                }
            } else {
                UResourceBundle parent = null;
                localeName = b.getLocaleID();
                int i = localeName.lastIndexOf(95);
                ICUResourceBundle.addToCache(root, fullName, defaultLocale, b);
                if (i != -1) {
                    parent = ICUResourceBundle.instantiateBundle(baseName, localeName.substring(0, i), root, disableFallback);
                } else if (!localeName.equals(rootLocale)) {
                    parent = ICUResourceBundle.instantiateBundle(baseName, rootLocale, root, true);
                }
                if (!b.equals(parent)) {
                    b.setParent(parent);
                }
            }
        }
        return b;
    }

    UResourceBundle get(String aKey, HashMap table, UResourceBundle requested) {
        ICUResourceBundle obj = (ICUResourceBundle)this.handleGet(aKey, table, requested);
        if (obj == null) {
            obj = (ICUResourceBundle)this.getParent();
            if (obj != null) {
                obj = (ICUResourceBundle)obj.get(aKey, table, requested);
            }
            if (obj == null) {
                String fullName = ICUResourceBundleReader.getFullName(this.getBaseName(), this.getLocaleID());
                throw new MissingResourceException("Can't find resource for bundle " + fullName + ", key " + aKey, this.getClass().getName(), aKey);
            }
        }
        obj.setLoadingStatus(((ICUResourceBundle)requested).getLocaleID());
        return obj;
    }

    public static ICUResourceBundle createBundle(String baseName, String localeID, ClassLoader root) {
        ICUResourceBundleReader reader = ICUResourceBundleReader.getReader(baseName, localeID, root);
        if (reader == null) {
            return null;
        }
        return ICUResourceBundle.getBundle(reader, baseName, localeID, root);
    }

    protected String getLocaleID() {
        return this.localeID;
    }

    protected String getBaseName() {
        return this.baseName;
    }

    public ULocale getULocale() {
        return this.ulocale;
    }

    public UResourceBundle getParent() {
        return (UResourceBundle)this.parent;
    }

    protected void setParent(ResourceBundle parent) {
        this.parent = parent;
    }

    protected boolean getNoFallback() {
        return this.noFallback;
    }

    private static ICUResourceBundle getBundle(ICUResourceBundleReader reader, String baseName, String localeID, ClassLoader loader) {
        long rootResource = 0xFFFFFFFFL & (long)reader.getRootResource();
        int type = ICUResourceBundle.RES_GET_TYPE(rootResource);
        if (type == 2) {
            ICUResourceBundleImpl.ResourceTable table = new ICUResourceBundleImpl.ResourceTable(reader, baseName, localeID, loader);
            if (table.getSize() >= 1) {
                UResourceBundle b = table.handleGetImpl(0, null, table, null);
                String itemKey = b.getKey();
                if (itemKey.equals("%%ALIAS")) {
                    String locale = b.getString();
                    UResourceBundle actual = UResourceBundle.getBundleInstance(baseName, locale);
                    return (ICUResourceBundleImpl.ResourceTable)actual;
                }
                return table;
            }
            return table;
        }
        if (type == 4) {
            return new ICUResourceBundleImpl.ResourceTable32(reader, baseName, localeID, loader);
        }
        throw new IllegalStateException("Invalid format error");
    }

    protected ICUResourceBundle() {
    }

    public static final int RES_GET_TYPE(long res) {
        return (int)(res >> 28);
    }

    protected static final int RES_GET_OFFSET(long res) {
        return (int)((res & 0xFFFFFFFL) << 2);
    }

    protected static final int RES_GET_INT(long res) {
        return (int)(res << 4) >> 4;
    }

    static final long RES_GET_UINT(long res) {
        long t = res & 0xFFFFFFFL;
        return t;
    }

    static final StringBuffer RES_GET_KEY(byte[] rawData, int keyOffset) {
        char ch;
        StringBuffer key = new StringBuffer();
        while ((ch = (char)rawData[keyOffset]) != '\u0000') {
            key.append(ch);
            ++keyOffset;
        }
        return key;
    }

    protected static final int getIntOffset(int offset) {
        return offset << 2;
    }

    static final int getCharOffset(int offset) {
        return offset << 1;
    }

    protected final ICUResourceBundle createBundleObject(String _key, long _resource, String _resPath, HashMap table, UResourceBundle requested, ICUResourceBundle bundle, boolean[] isAlias) {
        if (isAlias != null) {
            isAlias[0] = false;
        }
        switch (ICUResourceBundle.RES_GET_TYPE(_resource)) {
            case 0: {
                return new ICUResourceBundleImpl.ResourceString(_key, _resPath, _resource, this);
            }
            case 1: {
                return new ICUResourceBundleImpl.ResourceBinary(_key, _resPath, _resource, this);
            }
            case 3: {
                if (isAlias != null) {
                    isAlias[0] = true;
                }
                return this.findResource(_key, _resource, table, requested);
            }
            case 7: {
                return new ICUResourceBundleImpl.ResourceInt(_key, _resPath, _resource, this);
            }
            case 14: {
                return new ICUResourceBundleImpl.ResourceIntVector(_key, _resPath, _resource, this);
            }
            case 8: {
                return new ICUResourceBundleImpl.ResourceArray(_key, _resPath, _resource, this);
            }
            case 4: {
                return new ICUResourceBundleImpl.ResourceTable32(_key, _resPath, _resource, this);
            }
            case 2: {
                return new ICUResourceBundleImpl.ResourceTable(_key, _resPath, _resource, this);
            }
        }
        throw new IllegalStateException("The resource type is unknown");
    }

    static final void assign(ICUResourceBundle b1, ICUResourceBundle b2) {
        b1.rawData = b2.rawData;
        b1.rootResource = b2.rootResource;
        b1.noFallback = b2.noFallback;
        b1.baseName = b2.baseName;
        b1.localeID = b2.localeID;
        b1.ulocale = b2.ulocale;
        b1.loader = b2.loader;
        b1.parent = b2.parent;
    }

    int findKey(int siz, int currentOffset, ICUResourceBundle res, String target) {
        int mid = 0;
        int start = 0;
        int limit = siz;
        int lastMid = -1;
        int targetLength = target.length();
        block0: while (lastMid != (mid = start + limit >> 1)) {
            char actualChar;
            lastMid = mid;
            int offset = res.getOffset(currentOffset, mid);
            for (int i = 0; i < targetLength; ++i) {
                char targetChar = target.charAt(i);
                actualChar = (char)this.rawData[offset];
                if (actualChar == '\u0000' || targetChar > actualChar) {
                    start = mid;
                    continue block0;
                }
                if (targetChar < actualChar) {
                    limit = mid;
                    continue block0;
                }
                ++offset;
            }
            actualChar = (char)this.rawData[offset];
            if (actualChar != '\u0000') {
                limit = mid;
                continue;
            }
            return mid;
        }
        return -1;
    }

    public int getOffset(int currentOfset, int index) {
        return -1;
    }

    private static final char makeChar(byte[] data, int offset) {
        return (char)(data[offset++] << 8 | data[offset] & 0xFF);
    }

    static char getChar(byte[] data, int offset) {
        return ICUResourceBundle.makeChar(data, offset);
    }

    private static final int makeInt(byte[] data, int offset) {
        return data[offset++] << 24 | (data[offset++] & 0xFF) << 16 | (data[offset++] & 0xFF) << 8 | data[offset] & 0xFF;
    }

    protected static int getInt(byte[] data, int offset) {
        return ICUResourceBundle.makeInt(data, offset);
    }

    String getStringValue(long res) {
        if (res == 0L) {
            return "";
        }
        int offset = ICUResourceBundle.RES_GET_OFFSET(res);
        int length = ICUResourceBundle.getInt(this.rawData, offset);
        int stringOffset = offset + ICUResourceBundle.getIntOffset(1);
        char[] dst = new char[length];
        for (int i = 0; i < length; ++i) {
            dst[i] = ICUResourceBundle.getChar(this.rawData, stringOffset + ICUResourceBundle.getCharOffset(i));
        }
        return new String(dst);
    }

    protected static final int getIndex(String s) {
        if (s.length() >= 1) {
            return Integer.valueOf(s);
        }
        return -1;
    }

    private ICUResourceBundle findResource(String _key, long _resource, HashMap table, UResourceBundle requested) {
        String bundleName;
        int i;
        ClassLoader loaderToUse = this.loader;
        String locale = null;
        String keyPath = null;
        String rpath = this.getStringValue(_resource);
        if (table == null) {
            table = new HashMap<String, String>();
        }
        if (table.get(rpath) != null) {
            throw new IllegalArgumentException("Circular references in the resource bundles");
        }
        table.put(rpath, "");
        if (rpath.indexOf(47) == 0) {
            int idx;
            i = rpath.indexOf(47, 1);
            int j = rpath.indexOf(47, i + 1);
            bundleName = rpath.substring(1, i);
            locale = rpath.substring(i + 1);
            if (j != -1) {
                locale = rpath.substring(i + 1, j);
                keyPath = rpath.substring(j + 1, rpath.length());
            }
            if (bundleName.equals(ICUDATA)) {
                bundleName = ICU_BASE_NAME;
                loaderToUse = ICU_DATA_CLASS_LOADER;
            } else if (bundleName.indexOf(ICUDATA) > -1 && (idx = bundleName.indexOf(45)) > -1) {
                bundleName = "com/liferay/ibm/icu/impl/data/icudt40b/" + bundleName.substring(idx + 1, bundleName.length());
                loaderToUse = ICU_DATA_CLASS_LOADER;
            }
        } else {
            i = rpath.indexOf(47);
            keyPath = rpath.substring(i + 1);
            if (i != -1) {
                locale = rpath.substring(0, i);
            } else {
                locale = keyPath;
                keyPath = null;
            }
            bundleName = this.baseName;
        }
        ICUResourceBundle bundle = null;
        ICUResourceBundle sub = null;
        if (bundleName.equals(LOCALE)) {
            bundleName = this.baseName;
            bundle = (ICUResourceBundle)requested;
            keyPath = rpath.substring(LOCALE.length() + 2, rpath.length());
            locale = ((ICUResourceBundle)requested).getLocaleID();
            sub = ICUResourceBundle.findResourceWithFallback(keyPath, requested, null);
            sub.resPath = RES_PATH_SEP_STR + sub.getLocaleID() + RES_PATH_SEP_STR + keyPath;
        } else {
            bundle = locale == null ? (ICUResourceBundle)ICUResourceBundle.getBundleInstance(bundleName, "", loaderToUse, false) : (ICUResourceBundle)ICUResourceBundle.getBundleInstance(bundleName, locale, loaderToUse, false);
            if (keyPath != null) {
                String subKey;
                StringTokenizer st = new StringTokenizer(keyPath, RES_PATH_SEP_STR);
                ICUResourceBundle current = bundle;
                while (st.hasMoreTokens() && (sub = (ICUResourceBundle)current.get(subKey = st.nextToken(), table, requested)) != null) {
                    current = sub;
                }
            } else {
                sub = (ICUResourceBundle)bundle.get(_key);
            }
            sub.resPath = rpath;
        }
        if (sub == null) {
            throw new MissingResourceException(this.localeID, this.baseName, _key);
        }
        return sub;
    }

    protected void createLookupCache() {
        this.lookup = new SimpleCache(1, Math.max(this.size * 2, 64));
    }

    protected UResourceBundle handleGet(String resKey, HashMap table, UResourceBundle requested) {
        boolean[] alias;
        int[] index;
        UResourceBundle res = null;
        if (this.lookup != null) {
            res = (UResourceBundle)this.lookup.get(resKey);
        }
        if (res == null && (res = this.handleGetImpl(resKey, table, requested, index = new int[1], alias = new boolean[1])) != null && this.lookup != null && !alias[0]) {
            this.lookup.put(resKey, res);
            this.lookup.put(Utility.integerValueOf(index[0]), res);
        }
        return res;
    }

    protected UResourceBundle handleGet(int index, HashMap table, UResourceBundle requested) {
        boolean[] alias;
        UResourceBundle res = null;
        Integer indexKey = null;
        if (this.lookup != null) {
            indexKey = Utility.integerValueOf(index);
            res = (UResourceBundle)this.lookup.get(indexKey);
        }
        if (res == null && (res = this.handleGetImpl(index, table, requested, alias = new boolean[1])) != null && this.lookup != null && !alias[0]) {
            this.lookup.put(res.getKey(), res);
            this.lookup.put(indexKey, res);
        }
        return res;
    }

    protected UResourceBundle handleGetImpl(String resKey, HashMap table, UResourceBundle requested, int[] index, boolean[] isAlias) {
        return null;
    }

    protected UResourceBundle handleGetImpl(int index, HashMap table, UResourceBundle requested, boolean[] isAlias) {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ClassLoader loader = (class$com$liferay$ibm$icu$impl$ICUData == null ? (class$com$liferay$ibm$icu$impl$ICUData = ICUResourceBundle.class$("com.liferay.ibm.icu.impl.ICUData")) : class$com$liferay$ibm$icu$impl$ICUData).getClassLoader();
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        ICU_DATA_CLASS_LOADER = loader;
        DEBUG = ICUDebug.enabled("localedata");
    }

    private static final class AvailEntry {
        private String prefix;
        private ULocale[] ulocales;
        private Locale[] locales;
        private Set nameSet;
        private Set fullNameSet;

        AvailEntry(String prefix) {
            this.prefix = prefix;
        }

        ULocale[] getULocaleList() {
            if (this.ulocales == null) {
                this.ulocales = ICUResourceBundle.createULocaleList(this.prefix, ICU_DATA_CLASS_LOADER);
            }
            return this.ulocales;
        }

        Locale[] getLocaleList() {
            if (this.locales == null) {
                this.locales = ICUResourceBundle.createLocaleList(this.prefix);
            }
            return this.locales;
        }

        Set getLocaleNameSet() {
            if (this.nameSet == null) {
                this.nameSet = ICUResourceBundle.createLocaleNameSet(this.prefix);
            }
            return this.nameSet;
        }

        Set getFullLocaleNameSet() {
            if (this.fullNameSet == null) {
                this.fullNameSet = ICUResourceBundle.createFullLocaleNameSet(this.prefix);
            }
            return this.fullNameSet;
        }
    }
}

