/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.trees.patterns;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementRefs;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import org.gcube.data.trees.data.Edge;
import org.gcube.data.trees.data.Nodes;
import org.gcube.data.trees.patterns.AnyPattern;
import org.gcube.data.trees.patterns.BoolPattern;
import org.gcube.data.trees.patterns.CalendarPattern;
import org.gcube.data.trees.patterns.CutTreePattern;
import org.gcube.data.trees.patterns.DatePattern;
import org.gcube.data.trees.patterns.NumPattern;
import org.gcube.data.trees.patterns.Pattern;
import org.gcube.data.trees.patterns.TextPattern;
import org.gcube.data.trees.patterns.TreePattern;
import org.gcube.data.trees.patterns.URIPattern;

@XmlRootElement
@XmlType(propOrder={"label", "pattern", "condition"})
public abstract class EdgePattern
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElementRefs(value={@XmlElementRef(type=TreePattern.class), @XmlElementRef(type=CutTreePattern.class), @XmlElementRef(type=NumPattern.class), @XmlElementRef(type=BoolPattern.class), @XmlElementRef(type=TextPattern.class), @XmlElementRef(type=DatePattern.class), @XmlElementRef(type=CalendarPattern.class), @XmlElementRef(type=URIPattern.class), @XmlElementRef(type=AnyPattern.class)})
    private Pattern pattern;
    @XmlElement(name="l")
    private QName label;
    @XmlAttribute(name="cond")
    private boolean condition;

    public void setAsCondition() {
        this.condition = true;
    }

    public void unsetAsCondition() {
        this.condition = false;
    }

    public boolean isCondition() {
        return this.condition;
    }

    EdgePattern() {
    }

    EdgePattern(QName l, Pattern p) {
        this.pattern = p;
        this.label = l;
    }

    public Pattern pattern() {
        return this.pattern;
    }

    public void setPattern(Pattern p) {
        this.pattern = p;
    }

    public QName label() {
        return this.label;
    }

    abstract boolean matches(List<Edge> var1);

    abstract List<Edge> prune(List<Edge> var1) throws Exception;

    protected List<Edge> matchLabels(List<Edge> edges) {
        ArrayList<Edge> matches = new ArrayList<Edge>();
        for (Edge edge : edges) {
            if (!Nodes.matches(edge.label(), this.label())) continue;
            matches.add(edge);
        }
        return matches;
    }

    public abstract Range range();

    public abstract String name();

    public String toString() {
        return (this.isCondition() ? "[COND]" : "") + this.name() + " " + this.label + ":" + this.pattern;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.condition ? 1231 : 1237);
        result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
        result = 31 * result + (this.pattern == null ? 0 : this.pattern.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EdgePattern)) {
            return false;
        }
        EdgePattern other = (EdgePattern)obj;
        if (this.condition != other.condition) {
            return false;
        }
        if (this.label == null ? other.label != null : !this.label.equals(other.label)) {
            return false;
        }
        return !(this.pattern == null ? other.pattern != null : !this.pattern.equals(other.pattern));
    }

    public static class Range {
        private int min;
        private int max;

        Range(int min, int max) {
            this.min = min;
            this.max = max;
        }

        public int max() {
            return this.max;
        }

        public int min() {
            return this.min;
        }

        public boolean includes(Range other) {
            return this.min <= other.min && this.max >= other.max;
        }
    }
}

