/*
 * Decompiled with CFR 0.152.
 */
package uk.org.primrose.pool.datasource;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NoInitialContextException;
import uk.org.primrose.GeneralException;
import uk.org.primrose.Util;
import uk.org.primrose.pool.core.PoolLoader;
import uk.org.primrose.pool.datasource.PrimroseDataSource;

public class GenericDataSourceFactory {
    public PrimroseDataSource loadPool(String poolName, String configFile) throws GeneralException, IOException {
        if (poolName == null || configFile == null) {
            throw new GeneralException("You must specify a non-null 'poolName' and a 'configFile' as parameters");
        }
        Properties poolProps = Util.generatePropertiesForPoolName(configFile, poolName);
        return this.loadPool(poolName, poolProps);
    }

    public PrimroseDataSource loadPool(String poolName, Properties poolProps) throws GeneralException, IOException {
        if (poolName == null || poolProps == null) {
            throw new GeneralException("You must specify a non-null 'poolName' pool Properties object as parameters");
        }
        if (poolProps != null) {
            PoolLoader.loadPool(poolProps, true);
        }
        PrimroseDataSource pds = new PrimroseDataSource();
        pds.setPoolName(poolName);
        return pds;
    }

    public Context findOrBindJNDIEnvContext() throws GeneralException {
        Context envCtx = null;
        InitialContext initCtx = null;
        try {
            initCtx = new InitialContext();
            try {
                envCtx = (Context)initCtx.lookup("java:comp/env");
            }
            catch (NoInitialContextException e) {
                System.setProperty("java.naming.factory.url.pkgs", "uk.org.primrose.jndi");
                System.setProperty("java.naming.factory.initial", "uk.org.primrose.jndi.PrimroseInitialContextFactory");
                initCtx = new InitialContext();
                Context ctx = (Context)initCtx.lookup("java:comp");
                try {
                    envCtx = (Context)ctx.lookup("env");
                }
                catch (Exception e2) {
                }
            }
            catch (Exception e) {}
        }
        catch (Exception e) {
            throw new GeneralException("Error looking up JNDI context java:comp or java:comp/env", e);
        }
        if (envCtx == null) {
            try {
                Context ctx = (Context)initCtx.lookup("java:comp");
                envCtx = ctx.createSubcontext("env");
            }
            catch (Exception e2) {
                throw new GeneralException("Error creating JNDI subcontext 'env' under java:comp", e2);
            }
        }
        return envCtx;
    }

    public void loadPools(String primroseConfigFile) throws GeneralException {
        String currentPoolName = null;
        try {
            Context envCtx = this.findOrBindJNDIEnvContext();
            List<String> loadedPoolNames = PoolLoader.loadPool(primroseConfigFile, true);
            Iterator<String> i$ = loadedPoolNames.iterator();
            while (i$.hasNext()) {
                String poolName;
                currentPoolName = poolName = i$.next();
                PrimroseDataSource pds = new PrimroseDataSource();
                pds.setPoolName(poolName);
                envCtx.rebind(poolName, (Object)pds);
            }
        }
        catch (Exception e) {
            throw new GeneralException("Error loading pool '" + currentPoolName + "'", e);
        }
    }
}

