/*
 * Decompiled with CFR 0.152.
 */
package uk.org.primrose;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import uk.org.primrose.DebugLogger;
import uk.org.primrose.SendMail;
import uk.org.primrose.Syslog;
import uk.org.primrose.SyslogDefs;
import uk.org.primrose.SyslogException;

public class Logger {
    private PrintWriter logWriter = null;
    private boolean logVerbose = false;
    private boolean logInfo = false;
    private boolean logWarn = false;
    private boolean logError = false;
    private boolean logCrisis = false;
    private int syslogFacility = -1;
    private int syslogPriority = -1;
    private boolean useSyslog = false;
    private String logLevel;
    private int logDayOfMonth = -1;
    private String origLogName = null;
    private String emailEvents = null;
    private String mxServer = null;
    private String mxServerPort = null;
    private String toAddress = null;
    private String poolName = null;

    public void setLogWriter(String log) throws IOException {
        DebugLogger.log("Using log(" + log + ")");
        if (log == null) {
            return;
        }
        if (log.toLowerCase().startsWith("syslog")) {
            String[] parts = log.split("\\.");
            if (parts.length == 3) {
                String facility = parts[1];
                String priority = parts[2];
                try {
                    this.syslogPriority = SyslogDefs.getPriority(priority);
                    this.syslogFacility = SyslogDefs.getFacility(facility);
                    this.useSyslog = true;
                    Syslog.open("localhost", "primrose", 0);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            if (this.origLogName == null) {
                this.origLogName = log;
            }
            Calendar cal = Calendar.getInstance();
            int localLogDayOfMonth = cal.get(5);
            boolean makeNewLog = false;
            if (this.logDayOfMonth == -1 && this.logWriter == null) {
                makeNewLog = true;
            }
            if (this.origLogName.indexOf("${") > -1 && localLogDayOfMonth != this.logDayOfMonth) {
                String dateFormat = this.origLogName.substring(this.origLogName.indexOf("${") + 2, this.origLogName.indexOf("}"));
                String logPrefix = this.origLogName.substring(0, this.origLogName.indexOf("${"));
                String logSuffix = this.origLogName.substring(this.origLogName.indexOf("}") + 1, this.origLogName.length());
                SimpleDateFormat sdf2 = new SimpleDateFormat(dateFormat);
                Date tmp = new Date();
                String formattedDate = sdf2.format(tmp);
                log = logPrefix + formattedDate + logSuffix;
                this.logDayOfMonth = localLogDayOfMonth;
                makeNewLog = true;
            }
            if (makeNewLog) {
                if (DebugLogger.getEnabled()) {
                    DebugLogger.log("[Logger@" + this.poolName + "] Making new log (" + log + ")");
                }
                if (this.logWriter != null) {
                    this.logWriter.close();
                }
                this.logWriter = new PrintWriter(new FileOutputStream(log, true), true);
            }
        }
    }

    public void setEmailDetails(String emailEvents, String toAddress, String mxServer, String mxServerPort, String poolName) {
        if (emailEvents != null && emailEvents.length() > 0 && !emailEvents.equals("null")) {
            this.emailEvents = emailEvents.toUpperCase();
            this.emailEvents = this.emailEvents + ",CRISIS";
            this.toAddress = toAddress;
            this.mxServer = mxServer;
            this.mxServerPort = mxServerPort;
            this.poolName = poolName;
        }
    }

    public void setLogLevel(String level) {
        if (level != null && level.length() > 0) {
            String[] levels = level.split(",");
            for (int i = 0; i < levels.length; ++i) {
                if (levels[i].equalsIgnoreCase("verbose")) {
                    this.logVerbose = true;
                    continue;
                }
                if (levels[i].equalsIgnoreCase("info")) {
                    this.logInfo = true;
                    continue;
                }
                if (levels[i].equalsIgnoreCase("warn")) {
                    this.logWarn = true;
                    continue;
                }
                if (levels[i].equalsIgnoreCase("error")) {
                    this.logError = true;
                    continue;
                }
                if (levels[i].equalsIgnoreCase("crisis")) {
                    this.logCrisis = true;
                    continue;
                }
                if (!levels[i].equalsIgnoreCase("debug")) continue;
                DebugLogger.setEnabled(true);
            }
        }
        this.logLevel = level;
    }

    public void printStackTrace(Throwable t) {
        if (this.logWriter != null) {
            t.printStackTrace(this.logWriter);
        } else {
            t.printStackTrace(System.err);
        }
        if (DebugLogger.getEnabled()) {
            DebugLogger.printStackTrace(t);
        }
    }

    public void close() {
        if (this.logWriter != null) {
            this.logWriter.close();
        }
    }

    public void verbose(String data) {
        if (this.logVerbose) {
            this.log("VERBOSE", data);
        }
        if (DebugLogger.getEnabled()) {
            DebugLogger.log(data);
        }
    }

    public void info(byte[] data) {
        if (this.logInfo) {
            this.log("INFO", new String(data));
        }
    }

    public void info(String data) {
        if (this.logInfo) {
            this.log("INFO", data);
        }
        if (DebugLogger.getEnabled()) {
            DebugLogger.log(data);
        }
    }

    public void warn(String data) {
        if (this.logWarn) {
            this.log("WARN", data);
        }
        if (DebugLogger.getEnabled()) {
            DebugLogger.log(data);
        }
    }

    public void error(String data) {
        if (this.logError) {
            this.log("ERROR", data);
        }
        if (DebugLogger.getEnabled()) {
            DebugLogger.log(data);
        }
    }

    public void email(String eventType, String message) {
        if (this.emailEvents == null || this.emailEvents.indexOf(eventType.toUpperCase()) == -1) {
            return;
        }
        if (DebugLogger.getEnabled()) {
            DebugLogger.log("About to email event " + eventType + " :: " + message);
        }
        String host = "unknown_host";
        try {
            host = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            this.printStackTrace(e);
        }
        String fromAddress = "pools@primrose.org.uk";
        String subject = eventType + " : " + this.poolName + "@" + host;
        this.info("Sending email for eventType(" + eventType + "), toAddress(" + this.toAddress + "), fromAddress(" + fromAddress + ") message(" + message + ")");
        try {
            new SendMail(this, this.mxServer, this.mxServerPort, this.toAddress, fromAddress, subject, message).send();
        }
        catch (Exception e) {
            this.printStackTrace(e);
        }
    }

    public void crisis(String message) {
        if (this.logCrisis) {
            this.log("CRISIS", message);
        }
        if (DebugLogger.getEnabled()) {
            DebugLogger.log(message);
        }
        if (this.emailEvents == null) {
            return;
        }
        this.email("CRISIS", message);
    }

    private void log(String level, String data) {
        try {
            this.setLogWriter(this.origLogName);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        Calendar now = Calendar.getInstance();
        String nowString = now.get(5) + "/" + (now.get(2) + 1) + "/" + now.get(1) + " " + now.get(11) + ":" + now.get(12) + ":" + now.get(13);
        String message = nowString + " : " + level + ": " + data;
        if (this.useSyslog) {
            try {
                Syslog.log(this.syslogFacility, this.syslogPriority, message);
            }
            catch (SyslogException e) {
                e.printStackTrace();
            }
        } else if (this.logWriter == null) {
            System.out.println(message);
        } else {
            this.logWriter.println(message);
        }
    }

    public void linebreak() {
        if (this.logWriter == null) {
            System.out.println("\n");
        } else {
            this.logWriter.println("\n");
        }
    }

    public int getLogDayOfMonth() {
        return this.logDayOfMonth;
    }

    public void setLogDayOfMonth(int logDayOfMonth) {
        this.logDayOfMonth = logDayOfMonth;
    }

    public String getLogLevel() {
        return this.logLevel;
    }
}

