/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import org.jruby.util.ByteList;

public class ConvertDouble {
    public static final double byteListToDouble(ByteList bytes2, boolean strict) {
        return new DoubleConverter().parse(bytes2, strict, false);
    }

    public static final double byteListToDouble19(ByteList bytes2, boolean strict) {
        return new DoubleConverter().parse(bytes2, strict, true);
    }

    public static class DoubleConverter {
        private byte[] bytes;
        private int index;
        private int endIndex;
        private boolean isStrict;
        private boolean is19;
        private char[] chars;
        private int charsIndex;

        public void init(ByteList list2, boolean isStrict, boolean is19) {
            this.bytes = list2.getUnsafeBytes();
            this.index = list2.begin();
            this.endIndex = this.index + list2.length();
            this.isStrict = isStrict;
            this.is19 = is19;
            this.chars = new char[list2.length()];
            this.charsIndex = 0;
        }

        private byte next() {
            return this.bytes[this.index++];
        }

        private boolean previous() {
            --this.index;
            return false;
        }

        private boolean isDigit(byte b) {
            return b >= 48 && b <= 57;
        }

        private boolean isEOS() {
            return this.index >= this.endIndex;
        }

        private boolean isExponent(byte b) {
            return b == 101 || b == 69;
        }

        private boolean isWhitespace(byte b) {
            return b == 32 || b <= 13 && b >= 9 && b != 11;
        }

        private void addToResult(byte b) {
            this.chars[this.charsIndex++] = (char)b;
        }

        private boolean eatUnderscores() {
            while (!this.isEOS()) {
                byte value2 = this.next();
                if (value2 != 95) {
                    this.previous();
                    return this.isEOS();
                }
                if (!this.isStrict) continue;
                this.strictError();
            }
            return true;
        }

        private double completeCalculation() {
            if (this.charsIndex == 0 || this.charsIndex == 1 && this.chars[0] == '-') {
                if (this.isStrict) {
                    this.strictError();
                }
                return 0.0;
            }
            if (this.chars[this.charsIndex - 1] == 'e') {
                if (this.isStrict) {
                    this.strictError();
                }
                this.addToResult((byte)48);
            } else if (this.isStrict && !this.isEOS()) {
                this.strictError();
            }
            return Double.parseDouble(new String(this.chars));
        }

        private void strictError() {
            throw new NumberFormatException("does not meet strict criteria");
        }

        public double parse(ByteList list2, boolean strict, boolean is19) {
            this.init(list2, strict, is19);
            if (this.skipWhitespace()) {
                return this.completeCalculation();
            }
            if (this.parseOptionalSign()) {
                return this.completeCalculation();
            }
            this.parseDigits();
            return this.completeCalculation();
        }

        private boolean skipWhitespace() {
            while (!this.isEOS()) {
                byte value2 = this.next();
                if (this.isWhitespace(value2) || value2 == 95 && !this.isStrict && !this.is19) continue;
                return this.previous();
            }
            return true;
        }

        private boolean parseOptionalSign() {
            byte sign2 = this.next();
            if (sign2 == 45) {
                this.addToResult(sign2);
            } else if (sign2 != 43) {
                this.previous();
            }
            return this.isEOS();
        }

        /*
         * Enabled aggressive block sorting
         */
        private boolean parseDigits() {
            byte value2;
            block12: {
                if (!this.isEOS()) {
                    value2 = this.next();
                    if (this.isDigit(value2)) {
                        this.addToResult(value2);
                        break block12;
                    } else {
                        if (value2 == 46) {
                            this.addToResult(value2);
                            return this.parseDecimalDigits();
                        }
                        return this.isEOS();
                    }
                }
                if (this.isStrict) {
                    this.strictError();
                }
            }
            while (true) {
                if (this.isEOS()) {
                    return true;
                }
                value2 = this.next();
                if (this.isDigit(value2)) {
                    this.addToResult(value2);
                    continue;
                }
                if (value2 == 46) {
                    this.addToResult(value2);
                    return this.parseDecimalDigits();
                }
                if (value2 != 95) break;
                this.verifyNumberAfterUnderscore();
            }
            if (this.isExponent(value2)) {
                this.addToResult(value2);
                return this.parseExponent();
            }
            if (this.isWhitespace(value2)) {
                return this.skipWhitespace();
            }
            if (this.isStrict) {
                this.strictError();
            }
            return this.isEOS();
        }

        private boolean parseDecimalDigits() {
            if (this.isEOS()) {
                if (this.isStrict) {
                    this.strictError();
                }
                return true;
            }
            byte value2 = this.next();
            if (this.isDigit(value2)) {
                this.addToResult(value2);
            } else if (value2 == 95) {
                if (this.isStrict) {
                    this.strictError();
                }
                while (!this.isEOS()) {
                    value2 = this.next();
                    if (this.isDigit(value2)) {
                        this.addToResult(value2);
                        break;
                    }
                    if (value2 == 95) continue;
                    return true;
                }
            } else {
                if (this.isStrict) {
                    this.strictError();
                }
                return true;
            }
            while (!this.isEOS()) {
                value2 = this.next();
                if (this.isDigit(value2)) {
                    this.addToResult(value2);
                    continue;
                }
                if (this.isExponent(value2)) {
                    this.addToResult(value2);
                    return this.parseExponent();
                }
                if (value2 == 95) {
                    this.verifyNumberAfterUnderscore();
                    continue;
                }
                if (this.isWhitespace(value2)) {
                    return this.skipWhitespace();
                }
                if (this.isStrict) {
                    this.strictError();
                }
                return true;
            }
            return true;
        }

        private boolean parseExponent() {
            if (this.eatUnderscores()) {
                return this.isEOS();
            }
            byte value2 = this.next();
            if (value2 == 45 || value2 == 43) {
                this.addToResult(value2);
            } else {
                this.previous();
            }
            while (!this.isEOS()) {
                value2 = this.next();
                if (this.isDigit(value2)) {
                    this.addToResult(value2);
                    continue;
                }
                if (this.isWhitespace(value2)) {
                    return this.skipWhitespace();
                }
                if (value2 == 95) {
                    this.verifyNumberAfterUnderscore();
                    continue;
                }
                if (this.isStrict) {
                    this.strictError();
                }
                return true;
            }
            return true;
        }

        private void verifyNumberAfterUnderscore() {
            if (this.isStrict) {
                byte value2;
                if (this.isEOS()) {
                    this.strictError();
                }
                if (!this.isDigit(value2 = this.next())) {
                    this.previous();
                    this.strictError();
                } else {
                    this.addToResult(value2);
                }
            }
        }
    }
}

