/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.operands;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jruby.compiler.ir.operands.Operand;
import org.jruby.compiler.ir.operands.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompoundString
extends Operand {
    public final List<Operand> _pieces;

    public CompoundString(List<Operand> pieces) {
        this._pieces = pieces;
    }

    @Override
    public boolean isConstant() {
        if (this._pieces != null) {
            for (Operand o : this._pieces) {
                if (o.isConstant()) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return "COMPOUND_STRING" + (this._pieces == null ? "" : Arrays.toString(this._pieces.toArray()));
    }

    @Override
    public boolean isNonAtomicValue() {
        return true;
    }

    @Override
    public Operand getSimplifiedOperand(Map<Operand, Operand> valueMap) {
        int i = 0;
        for (Operand p2 : this._pieces) {
            this._pieces.set(i, p2.getSimplifiedOperand(valueMap));
            ++i;
        }
        return this;
    }

    @Override
    public void addUsedVariables(List<Variable> l) {
        for (Operand o : this._pieces) {
            o.addUsedVariables(l);
        }
    }
}

