/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jdo;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.datanucleus.api.jdo.JDOConnectionImpl;
import org.datanucleus.store.NucleusConnection;

public class JDOConnectionJDBCImpl
extends JDOConnectionImpl
implements Connection {
    private final Connection conn;
    private boolean isAvailable = true;

    public JDOConnectionJDBCImpl(NucleusConnection nconn) {
        super(nconn);
        this.conn = (Connection)nconn.getNativeConnection();
    }

    public boolean isAvailable() {
        return this.nucConn.isAvailable();
    }

    @Override
    public int getHoldability() throws SQLException {
        this.assertAvailable();
        return this.conn.getHoldability();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.assertAvailable();
        return this.conn.getTransactionIsolation();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.assertAvailable();
        this.conn.clearWarnings();
    }

    @Override
    public void commit() throws SQLException {
        super.throwExceptionUnsupportedOperation("commit");
    }

    @Override
    public void rollback() throws SQLException {
        super.throwExceptionUnsupportedOperation("rollback");
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.assertAvailable();
        return this.conn.getAutoCommit();
    }

    @Override
    public boolean isClosed() throws SQLException {
        if (this.nucConn.isAvailable()) {
            return this.conn.isClosed();
        }
        return true;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.assertAvailable();
        return this.conn.isReadOnly();
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        super.throwExceptionUnsupportedOperation("setHoldability");
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        super.throwExceptionUnsupportedOperation("setTransactionIsolation");
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        super.throwExceptionUnsupportedOperation("setAutoCommit");
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        super.throwExceptionUnsupportedOperation("setReadOnly");
    }

    @Override
    public String getCatalog() throws SQLException {
        this.assertAvailable();
        return this.conn.getCatalog();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        super.throwExceptionUnsupportedOperation("setCatalog");
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        super.throwExceptionUnsupportedOperation("getMetaData");
        return null;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.assertAvailable();
        return this.conn.getWarnings();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        super.throwExceptionUnsupportedOperation("setSavepoint");
        return null;
    }

    @Override
    public void releaseSavepoint(Savepoint pt) throws SQLException {
        super.throwExceptionUnsupportedOperation("releaseSavepoint");
    }

    @Override
    public void rollback(Savepoint pt) throws SQLException {
        super.throwExceptionUnsupportedOperation("rollback");
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.assertAvailable();
        return this.conn.createStatement();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.assertAvailable();
        return this.conn.createStatement(resultSetType, resultSetConcurrency);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.assertAvailable();
        return this.conn.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public Map getTypeMap() throws SQLException {
        this.assertAvailable();
        return this.conn.getTypeMap();
    }

    public void setTypeMap(Map map) throws SQLException {
        super.throwExceptionUnsupportedOperation("setTypeMap");
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.assertAvailable();
        return this.conn.nativeSQL(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        this.assertAvailable();
        return this.conn.prepareCall(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.assertAvailable();
        return this.conn.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public CallableStatement prepareCall(String arg0, int arg1, int arg2, int arg3) throws SQLException {
        this.assertAvailable();
        return this.conn.prepareCall(arg0, arg1, arg2, arg3);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.assertAvailable();
        return this.conn.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String arg0, int arg1) throws SQLException {
        this.assertAvailable();
        return this.conn.prepareStatement(arg0, arg1);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.assertAvailable();
        return this.conn.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String arg0, int arg1, int arg2, int arg3) throws SQLException {
        this.assertAvailable();
        return this.conn.prepareStatement(arg0, arg1, arg2, arg3);
    }

    @Override
    public PreparedStatement prepareStatement(String arg0, int[] arg1) throws SQLException {
        this.assertAvailable();
        return this.conn.prepareStatement(arg0, arg1);
    }

    @Override
    public Savepoint setSavepoint(String arg0) throws SQLException {
        super.throwExceptionUnsupportedOperation("setSavepoint");
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String arg0, String[] arg1) throws SQLException {
        this.assertAvailable();
        return this.conn.prepareStatement(arg0, arg1);
    }

    public void assertAvailable() {
        if (!this.isAvailable) {
            this.throwExceptionNotAvailable();
        }
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return this.conn.createArrayOf(typeName, elements);
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this.conn.createBlob();
    }

    @Override
    public Clob createClob() throws SQLException {
        return this.conn.createClob();
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return this.conn.createStruct(typeName, attributes);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.conn.getClientInfo();
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.conn.getClientInfo(name);
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this.conn.isValid(timeout);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            this.conn.setClientInfo(properties);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        try {
            this.conn.setClientInfo(name, value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this.conn.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this.conn.createSQLXML();
    }

    public boolean isWrapperFor(Class iface) throws SQLException {
        return Connection.class.equals((Object)iface);
    }

    public Object unwrap(Class iface) throws SQLException {
        if (!Connection.class.equals((Object)iface)) {
            throw new SQLException("Connection of type [" + this.getClass().getName() + "] can only be unwrapped as [java.sql.Connection], not as [" + iface.getName() + "]");
        }
        return this;
    }

    @Override
    public void setSchema(String schema) throws SQLException {
    }

    @Override
    public String getSchema() throws SQLException {
        return null;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return 0;
    }
}

