/*
 * Decompiled with CFR 0.152.
 */
package com.metaparadigm.jsonrpc;

import com.metaparadigm.jsonrpc.ErrorInvocationCallback;
import com.metaparadigm.jsonrpc.HttpServletRequestArgResolver;
import com.metaparadigm.jsonrpc.HttpSessionArgResolver;
import com.metaparadigm.jsonrpc.InvocationCallback;
import com.metaparadigm.jsonrpc.JSONRPCBridgeServletArgResolver;
import com.metaparadigm.jsonrpc.JSONRPCResult;
import com.metaparadigm.jsonrpc.JSONSerializer;
import com.metaparadigm.jsonrpc.LocalArgResolveException;
import com.metaparadigm.jsonrpc.LocalArgResolver;
import com.metaparadigm.jsonrpc.MarshallException;
import com.metaparadigm.jsonrpc.ObjectMatch;
import com.metaparadigm.jsonrpc.ReferenceSerializer;
import com.metaparadigm.jsonrpc.Serializer;
import com.metaparadigm.jsonrpc.SerializerState;
import com.metaparadigm.jsonrpc.UnmarshallException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.json.JSONArray;
import org.json.JSONObject;

public class JSONRPCBridge
implements Serializable {
    private static final Logger log = Logger.getLogger(JSONRPCBridge.class.getName());
    private boolean debug = false;
    private static JSONRPCBridge globalBridge = new JSONRPCBridge();
    private static HashMap classCache = new HashMap();
    private static HashMap localArgResolverMap = new HashMap();
    private JSONSerializer ser = new JSONSerializer();
    private HashSet callbackSet = new HashSet();
    private HashMap classMap = new HashMap();
    private HashMap objectMap = new HashMap();
    protected HashMap referenceMap = new HashMap();
    protected Serializer referenceSer = null;
    protected HashSet referenceSet = new HashSet();
    protected HashSet callableReferenceSet = new HashSet();
    private static HttpServletRequestArgResolver requestResolver = new HttpServletRequestArgResolver();
    private static HttpSessionArgResolver sessionResolver = new HttpSessionArgResolver();
    private static JSONRPCBridgeServletArgResolver bridgeResolver = new JSONRPCBridgeServletArgResolver();
    static /* synthetic */ Class class$java$lang$Object;

    public void setDebug(boolean debug) {
        this.debug = debug;
        this.ser.setDebug(debug);
    }

    protected boolean isDebug() {
        return this.debug;
    }

    public static JSONRPCBridge getGlobalBridge() {
        return globalBridge;
    }

    public JSONRPCBridge() {
        this(true);
    }

    public JSONRPCBridge(boolean useDefaultSerializers) {
        if (useDefaultSerializers) {
            try {
                this.ser.registerDefaultSerializers();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClassData analyzeClass(Class clazz) {
        ArrayList marr;
        Map.Entry entry;
        log.info("analyzing " + clazz.getName());
        Method[] methods = clazz.getMethods();
        ClassData cd = new ClassData();
        cd.clazz = clazz;
        HashMap<MethodKey, ArrayList<Method>> staticMethodMap = new HashMap<MethodKey, ArrayList<Method>>();
        HashMap<MethodKey, ArrayList<Method>> methodMap = new HashMap<MethodKey, ArrayList<Method>>();
        for (int i = 0; i < methods.length; ++i) {
            int mod;
            Method method = methods[i];
            if (method.getDeclaringClass() == (class$java$lang$Object == null ? JSONRPCBridge.class$("java.lang.Object") : class$java$lang$Object) || !Modifier.isPublic(mod = methods[i].getModifiers())) continue;
            Class<?>[] param = method.getParameterTypes();
            int argCount = 0;
            HashMap hashMap = localArgResolverMap;
            synchronized (hashMap) {
                for (int n = 0; n < param.length; ++n) {
                    HashSet resolvers = (HashSet)localArgResolverMap.get(param[n]);
                    if (resolvers != null) continue;
                    ++argCount;
                }
            }
            MethodKey mk = new MethodKey(method.getName(), argCount);
            ArrayList<Method> marr2 = (ArrayList<Method>)methodMap.get(mk);
            if (marr2 == null) {
                marr2 = new ArrayList<Method>();
                methodMap.put(mk, marr2);
            }
            marr2.add(method);
            if (!Modifier.isStatic(mod)) continue;
            marr2 = (ArrayList<Method>)staticMethodMap.get(mk);
            if (marr2 == null) {
                marr2 = new ArrayList<Method>();
                staticMethodMap.put(mk, marr2);
            }
            marr2.add(method);
        }
        cd.methodMap = new HashMap();
        cd.staticMethodMap = new HashMap();
        Iterator i = methodMap.entrySet().iterator();
        while (i.hasNext()) {
            entry = i.next();
            MethodKey mk = (MethodKey)entry.getKey();
            marr = (ArrayList)entry.getValue();
            if (marr.size() == 1) {
                cd.methodMap.put(mk, marr.get(0));
                continue;
            }
            cd.methodMap.put(mk, marr.toArray(new Method[0]));
        }
        i = staticMethodMap.entrySet().iterator();
        while (i.hasNext()) {
            entry = i.next();
            MethodKey mk = (MethodKey)entry.getKey();
            marr = (ArrayList)entry.getValue();
            if (marr.size() == 1) {
                cd.staticMethodMap.put(mk, marr.get(0));
                continue;
            }
            cd.staticMethodMap.put(mk, marr.toArray(new Method[0]));
        }
        return cd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClassData getClassData(Class clazz) {
        ClassData cd;
        HashMap hashMap = classCache;
        synchronized (hashMap) {
            cd = (ClassData)classCache.get(clazz);
            if (cd == null) {
                cd = JSONRPCBridge.analyzeClass(clazz);
                classCache.put(clazz, cd);
            }
        }
        return cd;
    }

    public void registerSerializer(Serializer s) throws Exception {
        this.ser.registerSerializer(s);
    }

    public void enableReferences() throws Exception {
        if (this.referenceSer == null) {
            this.referenceSer = new ReferenceSerializer(this);
            this.ser.registerSerializer(this.referenceSer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerReference(Class clazz) throws Exception {
        HashSet hashSet = this.referenceSet;
        synchronized (hashSet) {
            this.referenceSet.add(clazz);
        }
        if (this.debug) {
            log.info("registered reference " + clazz.getName());
        }
    }

    protected boolean isReference(Class clazz) {
        if (this.referenceSet.contains(clazz)) {
            return true;
        }
        if (this == globalBridge) {
            return false;
        }
        return globalBridge.isReference(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCallableReference(Class clazz) throws Exception {
        HashSet hashSet = this.callableReferenceSet;
        synchronized (hashSet) {
            this.callableReferenceSet.add(clazz);
        }
        if (this.debug) {
            log.info("registered callable reference " + clazz.getName());
        }
    }

    protected boolean isCallableReference(Class clazz) {
        if (this.callableReferenceSet.contains(clazz)) {
            return true;
        }
        if (this == globalBridge) {
            return false;
        }
        return globalBridge.isCallableReference(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerClass(String name, Class clazz) throws Exception {
        HashMap hashMap = this.classMap;
        synchronized (hashMap) {
            Class exists = (Class)this.classMap.get(name);
            if (exists != null && exists != clazz) {
                throw new Exception("different class registered as " + name);
            }
            if (exists == null) {
                this.classMap.put(name, clazz);
            }
        }
        if (this.debug) {
            log.info("registered class " + clazz.getName() + " as " + name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterClass(String name) throws Exception {
        Class clazz = null;
        HashMap hashMap = this.classMap;
        synchronized (hashMap) {
            clazz = (Class)this.classMap.get(name);
            if (clazz != null) {
                this.classMap.remove(name);
                if (this.debug) {
                    log.info("unregistered class " + clazz.getName() + " from " + name);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class lookupClass(String name) throws Exception {
        HashMap hashMap = this.classMap;
        synchronized (hashMap) {
            return (Class)this.classMap.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassData resolveClass(String className) {
        Class clazz = null;
        ClassData cd = null;
        HashMap hashMap = this.classMap;
        synchronized (hashMap) {
            clazz = (Class)this.classMap.get(className);
        }
        if (clazz != null) {
            cd = JSONRPCBridge.getClassData(clazz);
        }
        if (cd != null) {
            if (this.debug) {
                log.fine("found class " + cd.clazz.getName() + " named " + className);
            }
            return cd;
        }
        if (this != globalBridge) {
            return globalBridge.resolveClass(className);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerObject(Object key, Object o) {
        Class<?> clazz = o.getClass();
        ObjectInstance oi = new ObjectInstance(o);
        HashMap hashMap = this.objectMap;
        synchronized (hashMap) {
            this.objectMap.put(key, oi);
        }
        if (this.debug) {
            log.info("registered object " + o.hashCode() + " of class " + clazz.getName() + " as " + key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerObject(Object key, Object o, Class interfaceClass) {
        ObjectInstance inst = new ObjectInstance(o, interfaceClass);
        HashMap hashMap = this.objectMap;
        synchronized (hashMap) {
            this.objectMap.put(key, inst);
        }
        if (this.debug) {
            log.info("registered object " + o.hashCode() + " of class " + interfaceClass.getName() + " as " + key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterObject(Object key) {
        ObjectInstance oi = null;
        HashMap hashMap = this.objectMap;
        synchronized (hashMap) {
            oi = (ObjectInstance)this.objectMap.get(key);
            if (oi != null) {
                this.objectMap.remove(key);
                Class<?> clazz = oi.o.getClass();
                if (this.debug) {
                    log.info("unregistered object " + oi.o.hashCode() + " of class " + clazz.getName() + " from " + key);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object lookupObject(String key) throws Exception {
        HashMap hashMap = this.objectMap;
        synchronized (hashMap) {
            ObjectInstance oi = (ObjectInstance)this.objectMap.get(key);
            if (oi != null) {
                return oi.o;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectInstance resolveObject(Object key) {
        ObjectInstance oi;
        HashMap hashMap = this.objectMap;
        synchronized (hashMap) {
            oi = (ObjectInstance)this.objectMap.get(key);
        }
        if (this.debug && oi != null) {
            log.fine("found object " + oi.o.hashCode() + " of class " + oi.classData().clazz.getName() + " with key " + key);
        }
        if (oi == null && this != globalBridge) {
            return globalBridge.resolveObject(key);
        }
        return oi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCallback(InvocationCallback callback, Class contextInterface) {
        HashSet hashSet = this.callbackSet;
        synchronized (hashSet) {
            this.callbackSet.add(new CallbackData(callback, contextInterface));
        }
        if (this.debug) {
            log.info("registered callback " + callback.getClass().getName() + " with context interface " + contextInterface.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterCallback(InvocationCallback callback, Class contextInterface) {
        HashSet hashSet = this.callbackSet;
        synchronized (hashSet) {
            this.callbackSet.remove(new CallbackData(callback, contextInterface));
        }
        if (this.debug) {
            log.info("unregistered callback " + callback.getClass().getName() + " with context " + contextInterface.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerLocalArgResolver(Class argClazz, Class contextInterface, LocalArgResolver argResolver) {
        HashMap hashMap = localArgResolverMap;
        synchronized (hashMap) {
            HashSet<LocalArgResolverData> resolverSet = (HashSet<LocalArgResolverData>)localArgResolverMap.get(argClazz);
            if (resolverSet == null) {
                resolverSet = new HashSet<LocalArgResolverData>();
                localArgResolverMap.put(argClazz, resolverSet);
            }
            resolverSet.add(new LocalArgResolverData(argResolver, argClazz, contextInterface));
            classCache = new HashMap();
        }
        log.info("registered local arg resolver " + argResolver.getClass().getName() + " for local class " + argClazz.getName() + " with context " + contextInterface.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterLocalArgResolver(Class argClazz, Class contextInterface, LocalArgResolver argResolver) {
        HashMap hashMap = localArgResolverMap;
        synchronized (hashMap) {
            HashSet resolverSet = (HashSet)localArgResolverMap.get(argClazz);
            if (resolverSet == null || !resolverSet.remove(new LocalArgResolverData(argResolver, argClazz, contextInterface))) {
                log.warning("local arg resolver " + argResolver.getClass().getName() + " not registered for local class " + argClazz.getName() + " with context " + contextInterface.getName());
                return;
            }
            if (resolverSet.isEmpty()) {
                localArgResolverMap.remove(argClazz);
            }
            classCache = new HashMap();
        }
        log.info("unregistered local arg resolver " + argResolver.getClass().getName() + " for local class " + argClazz.getName() + " with context " + contextInterface.getName());
    }

    private Method resolveMethod(HashMap methodMap, String methodName, JSONArray arguments) {
        Method[] method = null;
        MethodKey mk = new MethodKey(methodName, arguments.length());
        Object o = methodMap.get(mk);
        if (o instanceof Method) {
            Method m = (Method)o;
            if (this.debug) {
                log.fine("found method " + methodName + "(" + JSONRPCBridge.argSignature(m) + ")");
            }
            return m;
        }
        if (!(o instanceof Method[])) {
            return null;
        }
        method = (Method[])o;
        ArrayList<MethodCandidate> candidate = new ArrayList<MethodCandidate>();
        if (this.debug) {
            log.fine("looking for method " + methodName + "(" + JSONRPCBridge.argSignature(arguments) + ")");
        }
        for (int i = 0; i < method.length; ++i) {
            try {
                candidate.add(this.tryUnmarshallArgs(method[i], arguments));
                if (!this.debug) continue;
                log.fine("+++ possible match with method " + methodName + "(" + JSONRPCBridge.argSignature(method[i]) + ")");
                continue;
            }
            catch (Exception e) {
                if (!this.debug) continue;
                log.fine("xxx " + e.getMessage() + " in " + methodName + "(" + JSONRPCBridge.argSignature(method[i]) + ")");
            }
        }
        MethodCandidate best = null;
        for (int i = 0; i < candidate.size(); ++i) {
            MethodCandidate c = (MethodCandidate)candidate.get(i);
            if (best == null) {
                best = c;
                continue;
            }
            ObjectMatch bestMatch = best.getMatch();
            ObjectMatch cMatch = c.getMatch();
            if (bestMatch.mismatch > cMatch.mismatch) {
                best = c;
                continue;
            }
            if (bestMatch.mismatch != cMatch.mismatch) continue;
            best = this.betterSignature(best, c);
        }
        if (best != null) {
            Method m = best.method;
            if (this.debug) {
                log.fine("found method " + methodName + "(" + JSONRPCBridge.argSignature(m) + ")");
            }
            return m;
        }
        return null;
    }

    private MethodCandidate betterSignature(MethodCandidate methodCandidate, MethodCandidate methodCandidate1) {
        Method method = methodCandidate.method;
        Method method1 = methodCandidate1.method;
        Class<?>[] parameters = method.getParameterTypes();
        Class<?>[] parameters1 = method1.getParameterTypes();
        int c = 0;
        int c1 = 0;
        for (int i = 0; i < parameters.length; ++i) {
            Class<?> parameterClass = parameters[i];
            Class<?> parameterClass1 = parameters1[i];
            if (parameterClass == parameterClass1) continue;
            if (parameterClass.isAssignableFrom(parameterClass1)) {
                ++c1;
                continue;
            }
            ++c;
        }
        if (c1 > c) {
            return methodCandidate1;
        }
        return methodCandidate;
    }

    private static String argSignature(Method method) {
        Class<?>[] param = method.getParameterTypes();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < param.length; ++i) {
            if (i > 0) {
                buf.append(",");
            }
            buf.append(param[i].getName());
        }
        return buf.toString();
    }

    private static String argSignature(JSONArray arguments) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < arguments.length(); ++i) {
            Object jso;
            if (i > 0) {
                buf.append(",");
            }
            if ((jso = arguments.get(i)) == null) {
                buf.append("java.lang.Object");
                continue;
            }
            if (jso instanceof String) {
                buf.append("java.lang.String");
                continue;
            }
            if (jso instanceof Number) {
                buf.append("java.lang.Number");
                continue;
            }
            if (jso instanceof JSONArray) {
                buf.append("java.lang.Object[]");
                continue;
            }
            buf.append("java.lang.Object");
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MethodCandidate tryUnmarshallArgs(Method method, JSONArray arguments) throws UnmarshallException {
        int i;
        MethodCandidate candidate = new MethodCandidate(method);
        Class<?>[] param = method.getParameterTypes();
        int j = 0;
        try {
            for (i = 0; i < param.length; ++i) {
                HashSet resolverSet;
                SerializerState state = new SerializerState();
                HashMap hashMap = localArgResolverMap;
                synchronized (hashMap) {
                    resolverSet = (HashSet)localArgResolverMap.get(param[i]);
                }
                ((MethodCandidate)candidate).match[i] = resolverSet != null ? ObjectMatch.OKAY : this.ser.tryUnmarshall(state, param[i], arguments.get(j++));
            }
        }
        catch (UnmarshallException e) {
            throw new UnmarshallException("arg " + (i + 1) + " " + e.getMessage());
        }
        return candidate;
    }

    private Object resolveLocalArg(Object[] context, HashSet resolverSet) throws UnmarshallException {
        Iterator i = resolverSet.iterator();
        while (i.hasNext()) {
            LocalArgResolverData resolverData = (LocalArgResolverData)i.next();
            for (int j = 0; j < context.length; ++j) {
                if (!resolverData.understands(context[j])) continue;
                try {
                    return resolverData.argResolver.resolveArg(context[j]);
                }
                catch (LocalArgResolveException e) {
                    throw new UnmarshallException("error resolving local argument: " + e);
                }
            }
        }
        throw new UnmarshallException("couldn't find local arg resolver");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] unmarshallArgs(Object[] context, Method method, JSONArray arguments) throws UnmarshallException {
        int i;
        Class<?>[] param = method.getParameterTypes();
        Object[] javaArgs = new Object[param.length];
        int j = 0;
        try {
            for (i = 0; i < param.length; ++i) {
                HashSet resolverSet;
                SerializerState state = new SerializerState();
                HashMap hashMap = localArgResolverMap;
                synchronized (hashMap) {
                    resolverSet = (HashSet)localArgResolverMap.get(param[i]);
                }
                javaArgs[i] = resolverSet != null ? this.resolveLocalArg(context, resolverSet) : this.ser.unmarshall(state, param[i], arguments.get(j++));
            }
        }
        catch (UnmarshallException e) {
            throw new UnmarshallException("arg " + (i + 1) + " " + e.getMessage());
        }
        return javaArgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preInvokeCallback(Object context, Object instance, Method m, Object[] arguments) throws Exception {
        HashSet hashSet = this.callbackSet;
        synchronized (hashSet) {
            Iterator i = this.callbackSet.iterator();
            while (i.hasNext()) {
                CallbackData cbdata = (CallbackData)i.next();
                if (!cbdata.understands(context)) continue;
                cbdata.cb.preInvoke(context, instance, m, arguments);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postInvokeCallback(Object context, Object instance, Method m, Object result) throws Exception {
        HashSet hashSet = this.callbackSet;
        synchronized (hashSet) {
            Iterator i = this.callbackSet.iterator();
            while (i.hasNext()) {
                CallbackData cbdata = (CallbackData)i.next();
                if (!cbdata.understands(context)) continue;
                cbdata.cb.postInvoke(context, instance, m, result);
            }
        }
    }

    public JSONRPCResult call(Object[] context, JSONObject jsonReq) {
        JSONRPCResult result = null;
        String encodedMethod = null;
        Object requestId = null;
        JSONArray arguments = null;
        try {
            encodedMethod = jsonReq.getString("method");
            arguments = jsonReq.getJSONArray("params");
            requestId = jsonReq.opt("id");
        }
        catch (NoSuchElementException e) {
            log.severe("no method or parameters in request");
            return new JSONRPCResult(591, null, "method not found (session may have timed out)");
        }
        if (this.isDebug()) {
            log.fine("call " + encodedMethod + "(" + arguments + ")" + ", requestId=" + requestId);
        }
        String className = null;
        String methodName = null;
        int objectID = 0;
        StringTokenizer t = new StringTokenizer(encodedMethod, ".");
        if (t.hasMoreElements()) {
            className = t.nextToken();
        }
        if (t.hasMoreElements()) {
            methodName = t.nextToken();
        }
        if (encodedMethod.startsWith(".obj#")) {
            t = new StringTokenizer(className, "#");
            t.nextToken();
            objectID = Integer.parseInt(t.nextToken());
        }
        ObjectInstance oi = null;
        ClassData cd = null;
        HashMap methodMap = null;
        Method method = null;
        Object itsThis = null;
        if (objectID == 0) {
            if (encodedMethod.equals("system.listMethods")) {
                HashSet m = new HashSet();
                globalBridge.allInstanceMethods(m);
                if (globalBridge != this) {
                    globalBridge.allStaticMethods(m);
                    globalBridge.allInstanceMethods(m);
                }
                this.allStaticMethods(m);
                this.allInstanceMethods(m);
                JSONArray methods = new JSONArray();
                Iterator i = m.iterator();
                while (i.hasNext()) {
                    methods.put((Object)((String)i.next()));
                }
                return new JSONRPCResult(0, requestId, methods);
            }
            if (className == null || methodName == null || (oi = this.resolveObject(className)) == null && (cd = this.resolveClass(className)) == null) {
                return new JSONRPCResult(591, requestId, "method not found (session may have timed out)");
            }
            if (oi != null) {
                itsThis = oi.o;
                methodMap = oi.classData().methodMap;
            } else {
                methodMap = cd.staticMethodMap;
            }
        } else {
            oi = this.resolveObject(new Integer(objectID));
            if (oi == null) {
                return new JSONRPCResult(591, requestId, "method not found (session may have timed out)");
            }
            itsThis = oi.o;
            methodMap = oi.classData().methodMap;
            if (methodName.equals("listMethods")) {
                HashSet m = new HashSet();
                this.uniqueMethods(m, "", oi.classData().staticMethodMap);
                this.uniqueMethods(m, "", oi.classData().methodMap);
                JSONArray methods = new JSONArray();
                Iterator i = m.iterator();
                while (i.hasNext()) {
                    methods.put((Object)((String)i.next()));
                }
                return new JSONRPCResult(0, requestId, methods);
            }
        }
        method = this.resolveMethod(methodMap, methodName, arguments);
        if (method == null) {
            return new JSONRPCResult(591, requestId, "method not found (session may have timed out)");
        }
        try {
            if (this.debug) {
                log.fine("invoking " + method.getReturnType().getName() + " " + method.getName() + "(" + JSONRPCBridge.argSignature(method) + ")");
            }
            Object[] javaArgs = this.unmarshallArgs(context, method, arguments);
            for (int i = 0; i < context.length; ++i) {
                this.preInvokeCallback(context[i], itsThis, method, javaArgs);
            }
            Object o = method.invoke(itsThis, javaArgs);
            for (int i = 0; i < context.length; ++i) {
                this.postInvokeCallback(context[i], itsThis, method, o);
            }
            SerializerState state = new SerializerState();
            result = new JSONRPCResult(0, requestId, this.ser.marshall(state, o));
        }
        catch (UnmarshallException e) {
            for (int i = 0; i < context.length; ++i) {
                this.errorCallback(context[i], itsThis, method, e);
            }
            result = new JSONRPCResult(592, requestId, e.getMessage());
        }
        catch (MarshallException e) {
            for (int i = 0; i < context.length; ++i) {
                this.errorCallback(context[i], itsThis, method, e);
            }
            result = new JSONRPCResult(593, requestId, e.getMessage());
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getTargetException();
            }
            for (int i = 0; i < context.length; ++i) {
                this.errorCallback(context[i], itsThis, method, e);
            }
            result = new JSONRPCResult(490, requestId, e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void errorCallback(Object context, Object instance, Method method, Throwable error) {
        HashSet hashSet = this.callbackSet;
        synchronized (hashSet) {
            Iterator i = this.callbackSet.iterator();
            while (i.hasNext()) {
                CallbackData cbdata = (CallbackData)i.next();
                if (!cbdata.understands(context) || !(cbdata.cb instanceof ErrorInvocationCallback)) continue;
                ErrorInvocationCallback ecb = (ErrorInvocationCallback)cbdata.cb;
                try {
                    ecb.invocationError(context, instance, method, error);
                }
                catch (Throwable th) {}
            }
        }
    }

    private void uniqueMethods(HashSet m, String prefix, HashMap methodMap) {
        Iterator i = methodMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry mentry = i.next();
            MethodKey mk = (MethodKey)mentry.getKey();
            m.add(prefix + mk.methodName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void allStaticMethods(HashSet m) {
        HashMap hashMap = this.classMap;
        synchronized (hashMap) {
            Iterator i = this.classMap.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry cdentry = i.next();
                String name = (String)cdentry.getKey();
                Class clazz = (Class)cdentry.getValue();
                ClassData cd = JSONRPCBridge.getClassData(clazz);
                this.uniqueMethods(m, name + ".", cd.staticMethodMap);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void allInstanceMethods(HashSet m) {
        HashMap hashMap = this.objectMap;
        synchronized (hashMap) {
            Iterator i = this.objectMap.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry oientry = i.next();
                Object key = oientry.getKey();
                if (!(key instanceof String)) continue;
                String name = (String)key;
                ObjectInstance oi = (ObjectInstance)oientry.getValue();
                this.uniqueMethods(m, name + ".", oi.classData().methodMap);
                this.uniqueMethods(m, name + ".", oi.classData().staticMethodMap);
            }
        }
    }

    public JSONSerializer getSerializer() {
        return this.ser;
    }

    public void setSerializer(JSONSerializer ser) {
        this.ser = ser;
    }

    static {
        JSONRPCBridge.registerLocalArgResolver(HttpServletRequest.class, HttpServletRequest.class, requestResolver);
        JSONRPCBridge.registerLocalArgResolver(HttpSession.class, HttpServletRequest.class, sessionResolver);
        JSONRPCBridge.registerLocalArgResolver(JSONRPCBridge.class, HttpServletRequest.class, bridgeResolver);
    }

    protected static class MethodCandidate {
        private Method method;
        private ObjectMatch[] match;

        public MethodCandidate(Method method) {
            this.method = method;
            this.match = new ObjectMatch[method.getParameterTypes().length];
        }

        public ObjectMatch getMatch() {
            int mismatch = -1;
            for (int i = 0; i < this.match.length; ++i) {
                mismatch = Math.max(mismatch, this.match[i].mismatch);
            }
            if (mismatch == -1) {
                return ObjectMatch.OKAY;
            }
            return new ObjectMatch(mismatch);
        }
    }

    protected static class MethodKey {
        private String methodName;
        private int numArgs;

        public MethodKey(String methodName, int numArgs) {
            this.methodName = methodName;
            this.numArgs = numArgs;
        }

        public int hashCode() {
            return this.methodName.hashCode() * this.numArgs;
        }

        public boolean equals(Object o) {
            if (!(o instanceof MethodKey)) {
                return false;
            }
            return this.methodName.equals(((MethodKey)o).methodName) && this.numArgs == ((MethodKey)o).numArgs;
        }
    }

    protected static class ObjectInstance
    implements Serializable {
        private Object o;
        private Class clazz;

        public ObjectInstance(Object o, Class clazz) {
            if (!clazz.isInstance(o)) {
                throw new ClassCastException("Attempt to register jsonrpc object with invalid class.");
            }
            this.o = o;
            this.clazz = clazz;
        }

        public ObjectInstance(Object o) {
            this.o = o;
            this.clazz = o.getClass();
        }

        public ClassData classData() {
            return JSONRPCBridge.getClassData(this.clazz);
        }
    }

    protected static class LocalArgResolverData {
        private LocalArgResolver argResolver;
        private Class argClazz;
        private Class contextInterface;

        public LocalArgResolverData(LocalArgResolver argResolver, Class argClazz, Class contextInterface) {
            this.argResolver = argResolver;
            this.argClazz = argClazz;
            this.contextInterface = contextInterface;
        }

        public boolean understands(Object context) {
            return this.contextInterface.isAssignableFrom(context.getClass());
        }

        public int hashCode() {
            return this.argResolver.hashCode() * this.argClazz.hashCode() * this.contextInterface.hashCode();
        }

        public boolean equals(Object o) {
            LocalArgResolverData cmp = (LocalArgResolverData)o;
            return this.argResolver.equals(cmp.argResolver) && this.argClazz.equals(cmp.argClazz) && this.contextInterface.equals(cmp.contextInterface);
        }
    }

    protected static class CallbackData
    implements Serializable {
        private InvocationCallback cb;
        private Class contextInterface;

        public CallbackData(InvocationCallback cb, Class contextInterface) {
            this.cb = cb;
            this.contextInterface = contextInterface;
        }

        public boolean understands(Object context) {
            return this.contextInterface.isAssignableFrom(context.getClass());
        }

        public int hashCode() {
            return this.cb.hashCode() * this.contextInterface.hashCode();
        }

        public boolean equals(Object o) {
            CallbackData cmp = (CallbackData)o;
            return this.cb.equals(cmp.cb) && this.contextInterface.equals(cmp.contextInterface);
        }
    }

    protected static class ClassData {
        private Class clazz;
        private HashMap methodMap;
        private HashMap staticMethodMap;

        protected ClassData() {
        }
    }
}

