/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.distribution;

import java.io.Serializable;
import org.apache.commons.math.MathException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.distribution.AbstractContinuousDistribution;
import org.apache.commons.math.distribution.GammaDistribution;
import org.apache.commons.math.special.Gamma;

public class GammaDistributionImpl
extends AbstractContinuousDistribution
implements GammaDistribution,
Serializable {
    private static final long serialVersionUID = -3239549463135430361L;
    private double alpha;
    private double beta;

    public GammaDistributionImpl(double alpha, double beta) {
        this.setAlpha(alpha);
        this.setBeta(beta);
    }

    public double cumulativeProbability(double x) throws MathException {
        double ret = x <= 0.0 ? 0.0 : Gamma.regularizedGammaP(this.getAlpha(), x / this.getBeta());
        return ret;
    }

    public double inverseCumulativeProbability(double p) throws MathException {
        if (p == 0.0) {
            return 0.0;
        }
        if (p == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return super.inverseCumulativeProbability(p);
    }

    public void setAlpha(double alpha) {
        if (alpha <= 0.0) {
            throw MathRuntimeException.createIllegalArgumentException("alpha must be positive ({0})", alpha);
        }
        this.alpha = alpha;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public void setBeta(double beta) {
        if (beta <= 0.0) {
            throw MathRuntimeException.createIllegalArgumentException("beta must be positive ({0})", beta);
        }
        this.beta = beta;
    }

    public double getBeta() {
        return this.beta;
    }

    public double density(Double x) {
        if (x < 0.0) {
            return 0.0;
        }
        return Math.pow(x / this.getBeta(), this.getAlpha() - 1.0) / this.getBeta() * Math.exp(-x.doubleValue() / this.getBeta()) / Math.exp(Gamma.logGamma(this.getAlpha()));
    }

    protected double getDomainLowerBound(double p) {
        return Double.MIN_VALUE;
    }

    protected double getDomainUpperBound(double p) {
        double ret = p < 0.5 ? this.getAlpha() * this.getBeta() : Double.MAX_VALUE;
        return ret;
    }

    protected double getInitialDomain(double p) {
        double ret = p < 0.5 ? this.getAlpha() * this.getBeta() * 0.5 : this.getAlpha() * this.getBeta();
        return ret;
    }
}

