/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.query;

import com.hp.hpl.jena.rdf.query.EvalFailureException;
import com.hp.hpl.jena.rdf.query.QSys;
import com.hp.hpl.jena.rdf.query.QueryEngine;
import com.hp.hpl.jena.rdf.query.QueryException;
import com.hp.hpl.jena.rdf.query.RDQL_InternalErrorException;
import com.hp.hpl.jena.rdf.query.ResultBinding;
import com.hp.hpl.jena.rdf.query.Slot;
import com.hp.hpl.jena.rdf.query.Value;
import com.hp.hpl.jena.util.Log;
import com.hp.hpl.mesa.rdf.jena.common.SelectorImpl;
import com.hp.hpl.mesa.rdf.jena.model.Model;
import com.hp.hpl.mesa.rdf.jena.model.Property;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import com.hp.hpl.mesa.rdf.jena.model.RDFNode;
import com.hp.hpl.mesa.rdf.jena.model.Resource;
import com.hp.hpl.mesa.rdf.jena.model.Statement;
import com.hp.hpl.mesa.rdf.jena.model.StmtIterator;
import java.util.Iterator;

public class TriplePattern {
    boolean initialized = false;
    Slot subjectSlot;
    Resource fixed_s;
    Slot predicateSlot;
    Property fixed_p;
    Slot objectSlot;
    RDFNode fixed_o;
    QueryEngine queryEngine = null;

    public TriplePattern(Slot slot, Slot slot2, Slot slot3) {
        this.subjectSlot = slot;
        this.fixed_s = null;
        this.predicateSlot = slot2;
        this.fixed_p = null;
        this.objectSlot = slot3;
        this.fixed_o = null;
        this.initialized = false;
    }

    private void init(Model model) {
        try {
            if (this.subjectSlot.isValue()) {
                if (!this.subjectSlot.getValue().isURI()) {
                    throw new QueryException("TriplePattern: subject is not a URI");
                }
                this.fixed_s = model.createResource(this.subjectSlot.getValue().getURI());
            }
            if (this.subjectSlot.isResource()) {
                this.fixed_s = this.subjectSlot.getResource();
            }
            if (this.subjectSlot.isProperty()) {
                this.fixed_s = this.subjectSlot.getProperty();
            }
            if (this.predicateSlot.isValue()) {
                if (!this.predicateSlot.getValue().isURI()) {
                    throw new QueryException("TriplePattern: property is not a URI");
                }
                this.fixed_p = model.createProperty(this.predicateSlot.getValue().getURI());
            }
            if (this.predicateSlot.isProperty()) {
                this.fixed_p = this.predicateSlot.getProperty();
            }
            if (this.predicateSlot.isResource()) {
                this.fixed_p = this.resourceToProperty(model, this.predicateSlot.getResource());
            }
            if (this.objectSlot.isValue()) {
                this.fixed_o = this.valueToRDFNode(model, this.objectSlot.getValue());
            }
            if (this.objectSlot.isResource()) {
                this.fixed_o = this.objectSlot.getResource();
            }
            if (this.objectSlot.isProperty()) {
                this.fixed_o = this.objectSlot.getProperty();
            }
            this.initialized = true;
        }
        catch (RDFException rDFException) {
            QSys.unhandledException(rDFException, "TriplePattern", "init");
        }
    }

    public Iterator match(Log log, QueryEngine queryEngine, Model model, ResultBinding resultBinding) {
        this.queryEngine = queryEngine;
        if (!this.initialized) {
            this.init(model);
        }
        try {
            Object object;
            Object object2;
            Object object3;
            Resource resource = this.fixed_s;
            if (resource == null && resultBinding != null && this.subjectSlot.isVar() && (object3 = resultBinding.get(this.subjectSlot.getVarName())) != null) {
                if (object3 instanceof Resource) {
                    resource = (Resource)object3;
                } else {
                    if (object3 instanceof RDFNode) {
                        throw new EvalFailureException();
                    }
                    if (object3 instanceof Value) {
                        object2 = (Value)object3;
                        if (!object2.isURI()) {
                            throw new EvalFailureException();
                        }
                        resource = model.createResource(object2.getURI());
                    } else {
                        throw new RDQL_InternalErrorException("TriplePattern.match: Subject: Unexpected class in ResultBinding: " + object3.getClass().getName());
                    }
                }
            }
            if ((object3 = this.fixed_p) == null && resultBinding != null && this.predicateSlot.isVar() && (object2 = resultBinding.get(this.predicateSlot.getVarName())) != null) {
                if (object2 instanceof Property) {
                    object3 = (Property)object2;
                } else if (object2 instanceof Resource) {
                    object3 = this.resourceToProperty(model, (Resource)object2);
                    if (object3 == null) {
                        if (log != null) {
                            Log.warning("Attempt to match an anonymous resource with a property", "TriplePattern", "match");
                        }
                        return null;
                    }
                } else {
                    if (object2 instanceof RDFNode) {
                        throw new RDQL_InternalErrorException("TriplePattern.match: Property: Unexpected RDFNode in ResultBinding: " + ((RDFNode)object2).toString() + " (" + object2.getClass().getName() + ")");
                    }
                    if (object2 instanceof Value) {
                        object = (Value)object2;
                        if (!object.isURI()) {
                            throw new EvalFailureException();
                        }
                        object3 = model.createProperty(object.getURI());
                    }
                }
            }
            if ((object2 = this.fixed_o) == null && resultBinding != null && this.objectSlot.isVar() && (object = resultBinding.get(this.objectSlot.getVarName())) != null) {
                if (object instanceof RDFNode) {
                    object2 = (RDFNode)object;
                } else if (object instanceof Value) {
                    object2 = this.valueToRDFNode(model, (Value)object);
                } else {
                    throw new RDQL_InternalErrorException("TriplePattern.match: Object: Unexpected class in ResultBinding: " + object.getClass().getName());
                }
            }
            if (log != null) {
                Log.debug("Match ... ");
                Log.debug("    Subject:  Slot:   " + this.subjectSlot);
                Log.debug("              Select: " + (resource == null ? this.subjectSlot.getVar().toString() : resource.toString()));
                Log.debug("    Property: Slot:   " + this.predicateSlot);
                Log.debug("              Select: " + (object3 == null ? this.predicateSlot.getVar().toString() : object3.toString()));
                Log.debug("    RDFNode:  Slot:   " + this.objectSlot);
                Log.debug("              Select: " + (object2 == null ? this.objectSlot.getVar().toString() : object2.toString()));
            }
            return new BindingIterator(log, model, resource, (Property)object3, (RDFNode)object2, resultBinding);
        }
        catch (EvalFailureException evalFailureException) {
            return null;
        }
        catch (RDFException rDFException) {
            QSys.unhandledException(rDFException, "TriplePattern", "match");
            return null;
        }
    }

    private RDFNode valueToRDFNode(Model model, Value value) throws RDFException {
        if (value.isURI()) {
            return model.createResource(value.getURI());
        }
        if (value.isInt()) {
            return model.createLiteral(value.getInt());
        }
        if (value.isLong()) {
            return model.createLiteral(value.getLong());
        }
        if (value.isBoolean()) {
            return model.createLiteral(value.getBoolean());
        }
        if (value.isString()) {
            return model.createLiteral(value.getString());
        }
        throw new QueryException("TriplePattern.valueToRDFNode: Unsupported value type: " + value);
    }

    private Property resourceToProperty(Model model, Resource resource) throws EvalFailureException {
        try {
            String string = resource.getURI();
            if (string == null || string.equals("")) {
                return null;
            }
            return model.createProperty(string);
        }
        catch (RDFException rDFException) {
            return null;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        stringBuffer.append(this.subjectSlot.toString());
        stringBuffer.append(", ");
        stringBuffer.append(this.predicateSlot.toString());
        stringBuffer.append(", ");
        stringBuffer.append(this.objectSlot.toString());
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    class BindingIterator
    implements Iterator {
        StmtIterator sIter;
        Resource s;
        Property p;
        RDFNode o;
        Log log;
        ResultBinding currentBinding;
        Object current;
        boolean finished = false;

        BindingIterator(Log log, Model model, Resource resource, Property property, RDFNode rDFNode, ResultBinding resultBinding) {
            this.log = log;
            this.s = resource;
            this.p = property;
            this.o = rDFNode;
            this.currentBinding = resultBinding;
            try {
                SelectorImpl selectorImpl = new SelectorImpl(this.s, this.p, this.o);
                this.sIter = model.listStatements(selectorImpl);
            }
            catch (RDFException rDFException) {
                QSys.unhandledException(rDFException, "TriplePattern.BindingIterator(RDFException)", "BindingIterator");
            }
            catch (Throwable throwable) {
                QSys.unhandledException(throwable, "TriplePattern.BindingIterator(Throwable)", "BindingIterator");
            }
        }

        public boolean hasNext() {
            if (TriplePattern.this.queryEngine.queryStop) {
                this.finished = true;
                if (this.sIter != null) {
                    try {
                        this.sIter.close();
                    }
                    catch (RDFException rDFException) {
                        QSys.unhandledException(rDFException, "BindingIterator", "hasNext");
                    }
                    this.sIter = null;
                    return false;
                }
            }
            if (this.finished) {
                return false;
            }
            if (this.current == null) {
                this.current = this.process();
                String string = this.current != null ? ((ResultBinding)this.current).toString() : "<<null>>";
                Log.debug("(" + Thread.currentThread().getName() + ") BindingIterator.next: " + string);
            }
            return this.current != null;
        }

        public Object next() {
            if (this.hasNext()) {
                String string = this.current != null ? ((ResultBinding)this.current).toString() : "<<null>>";
                Log.debug("(" + Thread.currentThread().getName() + ") BindingIterator.next: " + string);
                Object object = this.current;
                this.current = null;
                return object;
            }
            return null;
        }

        private Object process() {
            try {
                RDFNode rDFNode;
                Property property;
                Resource resource;
                String string;
                String string2;
                String string3;
                Object object;
                block17: {
                    while (true) {
                        if (!this.sIter.hasNext()) {
                            this.finished = true;
                            this.sIter.close();
                            this.sIter = null;
                            object = Thread.currentThread().getName();
                            Log.debug("(" + (String)object + ") sIter close");
                            return null;
                        }
                        object = this.sIter.next();
                        if (this.log != null) {
                            Log.debug("Triple: " + object);
                        }
                        string3 = null;
                        string2 = null;
                        string = null;
                        resource = object.getSubject();
                        property = object.getPredicate();
                        rDFNode = object.getObject();
                        if (this.s == null) {
                            string3 = TriplePattern.this.subjectSlot.getVarName();
                        }
                        if (this.p == null) {
                            string2 = TriplePattern.this.predicateSlot.getVarName();
                            if (string3 != null && string3.equals(string2)) {
                                if (!property.equals(resource)) {
                                    if (this.log == null) continue;
                                    Log.debug("Triple binding clash: subject/predicate");
                                    continue;
                                }
                                string2 = null;
                            }
                        }
                        if (this.o != null) break block17;
                        string = TriplePattern.this.objectSlot.getVarName();
                        if (string3 != null && string3.equals(string)) {
                            if (!(rDFNode instanceof Resource) || !((Resource)rDFNode).equals(resource)) {
                                if (this.log == null) continue;
                                Log.debug("Triple binding clash: subject/object");
                                continue;
                            }
                            string = null;
                        }
                        if (string2 == null || !string2.equals(string)) break block17;
                        if (rDFNode instanceof Resource && ((Resource)rDFNode).equals(property)) break;
                        if (this.log == null) continue;
                        Log.debug("Triple binding clash: predicate/object");
                    }
                    string = null;
                }
                if (string3 == null && string2 == null && string == null) {
                    return this.currentBinding;
                }
                ResultBinding resultBinding = new ResultBinding();
                if (string3 != null) {
                    resultBinding.add(string3, resource);
                }
                if (string2 != null) {
                    resultBinding.add(string2, property);
                }
                if (string != null) {
                    resultBinding.add(string, rDFNode);
                }
                if (resultBinding.size() == 0) {
                    throw new RDQL_InternalErrorException("TriplePattern.BindingIterator: Environemnt is still empty");
                }
                resultBinding.setParent(this.currentBinding);
                resultBinding.addTriple((Statement)object);
                return resultBinding;
            }
            catch (RDFException rDFException) {
                QSys.unhandledException(rDFException, "TriplePattern.BindingIterator(RDFException)", "next");
            }
            catch (Throwable throwable) {
                QSys.unhandledException(throwable, "TriplePattern.BindingIterator(Throwable)", "next");
            }
            return null;
        }

        public void remove() {
            throw new UnsupportedOperationException("BindingIterator.remove");
        }
    }
}

