/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.util.TimeZoneThreadLocal;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

public class TimeZoneUtil {
    private static TimeZoneUtil _instance = new TimeZoneUtil();
    private TimeZone _timeZone;
    private Map<String, TimeZone> _timeZones = new HashMap<String, TimeZone>();

    public static TimeZone getDefault() {
        return _instance._getDefault();
    }

    public static TimeZone getTimeZone(String timeZoneId) {
        return _instance._getTimeZone(timeZoneId);
    }

    public static void setDefault(String timeZoneId) {
        _instance._setDefault(timeZoneId);
    }

    private TimeZoneUtil() {
        this._timeZone = this._getTimeZone("UTC");
    }

    private TimeZone _getDefault() {
        TimeZone timeZone = TimeZoneThreadLocal.getTimeZone();
        if (timeZone != null) {
            return timeZone;
        }
        return this._timeZone;
    }

    private TimeZone _getTimeZone(String timeZoneId) {
        TimeZone timeZone = this._timeZones.get(timeZoneId);
        if (timeZone == null) {
            timeZone = TimeZone.getTimeZone(timeZoneId);
            this._timeZones.put(timeZoneId, timeZone);
        }
        return timeZone;
    }

    private void _setDefault(String timeZoneId) {
        if (Validator.isNotNull(timeZoneId)) {
            this._timeZone = TimeZone.getTimeZone(timeZoneId);
        }
    }
}

