/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class PrettyDateFormat
extends DateFormat {
    private Locale _locale;
    private TimeZone _timeZone;
    private String _todayString;
    private String _yesterdayString;

    public PrettyDateFormat(Locale locale, TimeZone timeZone) {
        this._locale = locale;
        this._timeZone = timeZone;
        this._todayString = LanguageUtil.get(this._locale, "today");
        this._yesterdayString = LanguageUtil.get(this._locale, "yesterday");
    }

    public PrettyDateFormat(long companyId, Locale locale, TimeZone timeZone) {
        this(locale, timeZone);
    }

    public StringBuffer format(Date date, StringBuffer sb, FieldPosition pos) {
        String dateString = "&nbsp;";
        if (date != null) {
            Date today = new Date();
            Calendar cal = Calendar.getInstance(this._timeZone, this._locale);
            cal.setTime(today);
            cal.add(5, -1);
            Date yesterday = cal.getTime();
            Format dateFormatDate = FastDateFormatFactoryUtil.getDate(this._locale, this._timeZone);
            Format dateFormatDateTime = FastDateFormatFactoryUtil.getDateTime(this._locale, this._timeZone);
            Format dateFormatTime = FastDateFormatFactoryUtil.getTime(this._locale, this._timeZone);
            dateString = dateFormatDate.format(date);
            dateString = dateString.equals(dateFormatDate.format(today)) ? String.valueOf(this._todayString) + " " + dateFormatTime.format(date) : (dateString.equals(dateFormatDate.format(yesterday)) ? String.valueOf(this._yesterdayString) + " " + dateFormatTime.format(date) : dateFormatDateTime.format(date));
        }
        return sb.append(dateString);
    }

    public Date parse(String source, ParsePosition pos) {
        Format dateFormatDate = FastDateFormatFactoryUtil.getDate(this._locale, this._timeZone);
        DateFormat dateFormatDateTime = DateFormatFactoryUtil.getDateTime(this._locale, this._timeZone);
        Date today = new Date();
        String dateString = source.substring(pos.getIndex());
        if (dateString.startsWith(this._todayString)) {
            dateString = dateString.replaceFirst(this._todayString, dateFormatDate.format(today));
        } else if (dateString.startsWith(this._yesterdayString)) {
            Calendar cal = Calendar.getInstance(this._timeZone, this._locale);
            cal.setTime(today);
            cal.add(5, -1);
            Date yesterday = cal.getTime();
            dateString = dateString.replaceFirst(this._todayString, dateFormatDate.format(yesterday));
        }
        return dateFormatDateTime.parse(dateString, new ParsePosition(0));
    }
}

