/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.servlet.PortletSessionListenerManager;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

public class PortletSessionTracker
implements HttpSessionListener,
HttpSessionBindingListener,
Serializable {
    private static PortletSessionTracker _instance = new PortletSessionTracker();
    private transient Map<String, Set<HttpSession>> _sessions = new HashMap<String, Set<HttpSession>>();

    public static void add(HttpSession session) {
        _instance._add(session);
    }

    public static void invalidate(HttpSession session) {
        _instance._invalidate(session.getId());
    }

    public static HttpSessionBindingListener getInstance() {
        return _instance;
    }

    public static void invalidate(String sessionId) {
        _instance._invalidate(sessionId);
    }

    public void sessionCreated(HttpSessionEvent httpSessionEvent) {
    }

    public void sessionDestroyed(HttpSessionEvent httpSessionEvent) {
        this._invalidate(httpSessionEvent.getSession().getId());
    }

    public void valueBound(HttpSessionBindingEvent event) {
    }

    public void valueUnbound(HttpSessionBindingEvent event) {
        PortletSessionTracker.invalidate(event.getSession().getId());
    }

    private PortletSessionTracker() {
        PortletSessionListenerManager.addListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _add(HttpSession session) {
        String sessionId = session.getId();
        Map<String, Set<HttpSession>> map = this._sessions;
        synchronized (map) {
            Set<HttpSession> portletSessions = this._sessions.get(sessionId);
            if (portletSessions == null) {
                portletSessions = new HashSet<HttpSession>();
                this._sessions.put(sessionId, portletSessions);
            }
            portletSessions.add(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _invalidate(String sessionId) {
        HashSet<HttpSession> sessionsToInvalidate = null;
        Map<String, Set<HttpSession>> map = this._sessions;
        synchronized (map) {
            Set<HttpSession> portletSessions = this._sessions.get(sessionId);
            if (portletSessions != null) {
                sessionsToInvalidate = new HashSet<HttpSession>(portletSessions);
            }
            this._sessions.remove(sessionId);
        }
        if (sessionsToInvalidate != null) {
            for (HttpSession session : sessionsToInvalidate) {
                try {
                    session.invalidate();
                }
                catch (Exception exception) {}
            }
        }
    }
}

