/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.io.unsync;

import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;

public class UnsyncCharArrayReader
extends Reader {
    protected char[] buffer;
    protected int capacity;
    protected int index;
    protected int markIndex;

    public UnsyncCharArrayReader(char[] charArray) {
        this.buffer = charArray;
        this.capacity = charArray.length;
        this.index = 0;
    }

    public UnsyncCharArrayReader(char[] charArray, int offset, int length) {
        this.buffer = charArray;
        this.capacity = Math.min(charArray.length, offset + length);
        this.index = offset;
        this.markIndex = offset;
    }

    public void close() {
        this.buffer = null;
    }

    public void mark(int readAheadLimit) throws IOException {
        if (this.buffer == null) {
            throw new IOException("Stream closed");
        }
        this.markIndex = this.index;
    }

    public boolean markSupported() {
        return true;
    }

    public int read() throws IOException {
        if (this.buffer == null) {
            throw new IOException("Stream closed");
        }
        if (this.index >= this.capacity) {
            return -1;
        }
        return this.buffer[this.index++];
    }

    public int read(char[] charArray) throws IOException {
        return this.read(charArray, 0, charArray.length);
    }

    public int read(char[] charArray, int offset, int length) throws IOException {
        if (this.buffer == null) {
            throw new IOException("Stream closed");
        }
        if (length <= 0) {
            return 0;
        }
        if (this.index >= this.capacity) {
            return -1;
        }
        int read = length;
        if (this.index + read > this.capacity) {
            read = this.capacity - this.index;
        }
        System.arraycopy(this.buffer, this.index, charArray, offset, read);
        this.index += read;
        return read;
    }

    public int read(CharBuffer charBuffer) throws IOException {
        if (this.buffer == null) {
            throw new IOException("Stream closed");
        }
        int length = charBuffer.remaining();
        if (length <= 0) {
            return 0;
        }
        if (this.index >= this.capacity) {
            return -1;
        }
        if (this.index + length > this.capacity) {
            length = this.capacity - this.index;
        }
        charBuffer.put(this.buffer, this.index, length);
        this.index += length;
        return length;
    }

    public boolean ready() throws IOException {
        if (this.buffer == null) {
            throw new IOException("Stream closed");
        }
        return this.capacity > this.index;
    }

    public void reset() throws IOException {
        if (this.buffer == null) {
            throw new IOException("Stream closed");
        }
        this.index = this.markIndex;
    }

    public long skip(long skip) throws IOException {
        if (this.buffer == null) {
            throw new IOException("Stream closed");
        }
        if (skip < 0L) {
            return 0L;
        }
        if ((long)this.index + skip > (long)this.capacity) {
            skip = this.capacity - this.index;
        }
        this.index = (int)((long)this.index + skip);
        return skip;
    }
}

